/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.opencypher.tools.Reflection;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.AttributeHandler;
import org.opencypher.tools.xml.CharactersHandler;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Comment;
import org.opencypher.tools.xml.Element;
import org.opencypher.tools.xml.HierarchicalClassValue;
import org.opencypher.tools.xml.NodeBuilder;

class Structure {
    private final Lookup lookup;
    private final Class<?> type;
    private final Element element;
    private final Map<Class<?>, Constructor<?>> constructors;
    private final AttributeHandler[] attributes;
    private final CharactersHandler characters;
    private final CharactersHandler comments;
    private final CharactersHandler headers;
    private final List<NestedChild> nested;
    private NodeBuilder[] children;

    public static Structure tree(Class<?> root) {
        return (Structure)new Lookup().get(root);
    }

    private Structure(Lookup lookup, Class<?> type, Element element, Map<Class<?>, Constructor<?>> constructors, List<Nested> children, List<Attr> attributes) {
        this.lookup = lookup;
        this.type = type;
        this.element = element;
        this.constructors = constructors;
        this.attributes = new AttributeHandler[attributes.size()];
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = attributes.get(i).handler(element.uri());
        }
        HashMap characters = null;
        this.nested = new ArrayList<NestedChild>(children.size());
        for (Nested child : children) {
            if (child instanceof NestedText) {
                NestedText text;
                if (characters == null) {
                    characters = new HashMap();
                }
                if (null == characters.put((text = (NestedText)child).type, text.handler)) continue;
                throw new IllegalStateException("Multiple text handling methods for type " + text.type.getSimpleName());
            }
            this.nested.add((NestedChild)child);
        }
        this.characters = Structure.textHandler(String.class, characters);
        this.comments = Structure.textHandler(Comment.class, characters);
        this.headers = Structure.textHandler(Comment.Header.class, characters);
    }

    public NodeBuilder factory(Class<?> parent, BiConsumer<Object, Object> handler) {
        Constructor<?> constructor;
        if (parent != null) {
            for (Class<?> type = parent; type != Object.class; type = type.getSuperclass()) {
                Constructor<?> constructor2 = this.constructors.get(type);
                if (constructor2 == null) continue;
                return this.newFactory(constructor2, handler);
            }
        }
        if ((constructor = this.constructors.get(null)) != null) {
            return this.newFactory(constructor, handler);
        }
        throw new IllegalStateException("No constructor of " + this.type + " for parent: " + parent);
    }

    private NodeBuilder newFactory(Constructor<?> constructor, BiConsumer<Object, Object> handler) {
        MethodHandle create;
        try {
            constructor.setAccessible(true);
            create = MethodHandles.publicLookup().unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (constructor.getParameterCount() == 0) {
            create = MethodHandles.dropArguments(create, 0, new Class[]{Object.class});
        }
        NodeBuilder[] children = null;
        if (this.children == null) {
            children = new NodeBuilder[this.nested.size()];
            this.children = children;
        }
        NodeBuilder builder = new NodeBuilder(this.element.uri(), this.element.name(), this.attributes, this.characters, this.comments, this.headers, this.children, Structure.factory(create), handler);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                NestedChild nested = this.nested.get(i);
                children[i] = ((Structure)this.lookup.get(nested.type)).factory(this.type, nested.adder);
            }
        }
        return builder;
    }

    private static Function<Object, Object> factory(MethodHandle create) {
        return parent -> Reflection.invoke(create, parent);
    }

    static CharactersHandler string(MethodHandle method) {
        return (target, buffer, start, length) -> {
            try {
                method.invokeExact(target, new String(buffer, start, length));
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    static CharactersHandler charBuffer(MethodHandle method) {
        return (target, buffer, start, length) -> {
            try {
                method.invokeWithArguments(target, buffer, start, length);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    private static CharactersHandler textHandler(Class<?> type, Map<Class<?>, CharactersHandler> characters) {
        CharactersHandler handler = characters == null ? null : characters.get(type);
        return handler != null ? handler : (target, buffer, start, length) -> {};
    }

    private static class Attr {
        private final String uri;
        private final String name;
        private final boolean optional;
        private final MethodHandle setter;

        Attr(String uri, String name, boolean optional, MethodHandle setter) {
            this.uri = uri;
            this.name = name;
            this.optional = optional;
            this.setter = setter;
        }

        public AttributeHandler handler(String elementUri) {
            return new AttributeHandler(this.uri == null ? elementUri : this.uri, this.name, this.optional, this.setter);
        }
    }

    private static class NestedChild
    extends Nested {
        private final Class<?> type;
        private final BiConsumer<Object, Object> adder;

        NestedChild(Class<?> type, MethodHandle adder) {
            this.type = type;
            this.adder = NestedChild.adder(adder);
        }

        static BiConsumer<Object, Object> adder(MethodHandle adder) {
            return (parent, child) -> {
                try {
                    adder.invokeWithArguments(parent, child);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            };
        }
    }

    private static class NestedText
    extends Nested {
        private final Class<?> type;
        private final CharactersHandler handler;

        NestedText(Class<?> type, CharactersHandler handler) {
            this.type = type;
            this.handler = handler;
        }
    }

    private static abstract class Nested {
        private Nested() {
        }
    }

    private static class Lookup
    extends ClassValue<Structure> {
        final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        final ClassValue<List<Attr>> attributeFields = new HierarchicalClassValue<Attr, Field, Attribute>(Class::getDeclaredFields, Attribute.class, this::createFieldAttribute);
        final ClassValue<List<Attr>> attributeMethods = new HierarchicalClassValue<Attr, Method, Attribute>(Class::getDeclaredMethods, Attribute.class, this::createMethodAttribute);
        final ClassValue<List<Nested>> children = new HierarchicalClassValue<Nested, Method, Child>(Class::getDeclaredMethods, Child.class, this::createNestedChild);

        private Lookup() {
        }

        @Override
        protected Structure computeValue(Class<?> type) {
            List<Attr> attributes;
            Element element = type.getAnnotation(Element.class);
            if (element == null) {
                throw new IllegalArgumentException("Not an element: " + type);
            }
            List<Attr> fields = this.attributeFields.get(type);
            List<Attr> methods = this.attributeMethods.get(type);
            if (methods.isEmpty()) {
                attributes = fields;
            } else if (fields.isEmpty()) {
                attributes = methods;
            } else {
                attributes = new ArrayList<Attr>(methods);
                attributes.addAll(fields);
            }
            return new Structure(this, type, element, this.constructors(type), this.children.get(type), attributes);
        }

        private Map<Class<?>, Constructor<?>> constructors(Class<?> type) {
            HashMap constructors = new HashMap();
            for (Constructor<?> constructor : type.getDeclaredConstructors()) {
                if (Modifier.isPrivate(constructor.getModifiers())) continue;
                if (constructor.getParameterCount() == 0) {
                    constructors.put(null, constructor);
                    continue;
                }
                if (constructor.getParameterCount() != 1) continue;
                for (Class<?> base = constructor.getParameterTypes()[0]; base != Object.class; base = base.getSuperclass()) {
                    constructors.putIfAbsent(base, constructor);
                }
            }
            if (constructors.isEmpty()) {
                throw new IllegalArgumentException("Cannot construct: " + type);
            }
            return constructors;
        }

        private Collection<Nested> createNestedChild(Method method, Child child) {
            if (method.getReturnType() == Void.TYPE) {
                Class<?>[] parameter;
                Class<?>[] types = child.value();
                if (method.getParameterCount() == 3 && (parameter = method.getParameterTypes())[0] == char[].class && parameter[1] == Integer.TYPE && parameter[2] == Integer.TYPE) {
                    return this.textChild(types, Structure.charBuffer(this.invoker(method)));
                }
                if (method.getParameterCount() == 1) {
                    Class<?> base = method.getParameterTypes()[0];
                    if (base == String.class) {
                        return this.textChild(types, Structure.string(this.invoker(method)));
                    }
                    if (types.length == 0) {
                        types = new Class[]{base};
                    }
                    Nested[] result = new Nested[types.length];
                    for (int i = 0; i < types.length; ++i) {
                        Class<?> type = types[i];
                        if (type.getAnnotation(Element.class) == null || !base.isAssignableFrom(type)) {
                            throw new IllegalArgumentException("Invalid child type: " + type);
                        }
                        result[i] = new NestedChild(type, this.invoker(method));
                    }
                    return Arrays.asList(result);
                }
            }
            throw new IllegalArgumentException("Invalid @Child method: " + method);
        }

        private Collection<Nested> textChild(Class<?>[] types, CharactersHandler handler) {
            if (types.length == 0 || types.length == 1 && types[0] == String.class) {
                return Collections.singletonList(new NestedText(String.class, handler));
            }
            for (Class<?> type : types) {
                if (type == Comment.class || type == Comment.Header.class) continue;
                throw new IllegalArgumentException("Invalid text @Child type: " + type);
            }
            NestedText[] result = new NestedText[types.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new NestedText(types[i], handler);
            }
            return Arrays.asList(result);
        }

        private Collection<Attr> createMethodAttribute(Method method, Attribute attribute) {
            if (method.getParameterCount() != 1) {
                throw new IllegalArgumentException("Bad attribute method: " + method);
            }
            return this.createAttribute(method, attribute, AttributeHandler.conversion(method.getParameterTypes()[0], this.invoker(method)));
        }

        private Collection<Attr> createFieldAttribute(Field field, Attribute attribute) {
            return this.createAttribute(field, attribute, this.setter(field));
        }

        private <T extends Member> Collection<Attr> createAttribute(T target, Attribute attribute, MethodHandle set) {
            String uri = attribute.uri();
            if (uri.isEmpty()) {
                uri = null;
            } else if (!attribute.optional()) {
                throw new IllegalArgumentException("Only optional attributes may define a namespace other then the namespace of the entity.");
            }
            String name = attribute.name();
            if (name.isEmpty()) {
                name = target.getName();
            }
            return Collections.singletonList(new Attr(uri, name, attribute.optional(), set));
        }

        private MethodHandle invoker(Method method) {
            try {
                method.setAccessible(true);
                return this.lookup.unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method should have been accessible", e);
            }
        }

        private MethodHandle setter(Field field) {
            MethodHandle setter;
            try {
                field.setAccessible(true);
                setter = this.lookup.unreflectSetter(field);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            return AttributeHandler.conversion(field.getType(), setter);
        }
    }
}

