/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.opencypher.grammar.Grammar;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Fixture
implements TestRule {
    private Class<?> testClass;
    private String testName;

    public String testName() {
        return this.testName;
    }

    public static Grammar grammarResource(Class<?> testClass, String resource, Grammar.ParserOption ... options) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        return Fixture.grammar(Fixture.resourceURL(testClass, resource), options);
    }

    public Grammar grammarResource(String resource, Grammar.ParserOption ... options) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        return Fixture.grammar(this.resource(resource), options);
    }

    public Document xmlResource(String resource) throws TransformerException, IOException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMResult result = new DOMResult();
        URL url = this.resource(resource);
        transformer.transform(new StreamSource(url.openStream(), url.toString()), result);
        return (Document)result.getNode();
    }

    public URL resource(String resource) {
        return Fixture.resourceURL(this.testClass, resource);
    }

    private static Grammar grammar(URL resource, Grammar.ParserOption ... options) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        return Grammar.parseXML((Path)Paths.get(resource.toURI()), (Grammar.ParserOption[])options);
    }

    private static URL resourceURL(Class<?> testClass, String resource) {
        URL url = testClass.getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("No such resource: " + resource);
        }
        return url;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Fixture.this.testClass = description.getTestClass();
                Fixture.this.testName = description.getMethodName();
                try {
                    base.evaluate();
                }
                finally {
                    Fixture.this.testClass = null;
                    Fixture.this.testName = null;
                }
            }
        };
    }
}

