/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Production;

public class GrammarTest {
    @Rule
    public final Fixture fixture = new Fixture();

    @Test
    public void shouldParseGrammar() throws Exception {
        Grammar grammar = Grammar.parseXML((Path)Paths.get(this.fixture.resource("/somegrammar.xml").toURI()), (Grammar.ParserOption[])new Grammar.ParserOption[]{Grammar.ParserOption.FAIL_ON_UNKNOWN_XML_ATTRIBUTE});
        Assert.assertNotNull((Object)grammar);
        Assert.assertEquals((Object)"SomeLanguage", (Object)grammar.language());
    }

    @Test
    public void shouldAccessReferencingProductions() throws Exception {
        Grammar grammar = Grammar.grammar((String)"language", (Grammar.Option[])new Grammar.Option[0]).production("language", Grammar.nonTerminal((String)"one"), new Grammar.Term[]{Grammar.nonTerminal((String)"two")}).production("one", Grammar.nonTerminal((String)"two"), new Grammar.Term[0]).production("two", Grammar.literal((String)"y"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]);
        Collection references = grammar.production("two").referencedFrom();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("one", "language")), references.stream().map(Production::name).collect(Collectors.toSet()));
    }
}

