/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Rule;
import org.junit.Test;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Production;
import org.opencypher.railroad.AwtShapes;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.RailRoadViewer;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Interactive;
import org.opencypher.tools.Option;
import org.w3c.dom.Document;

public class RailRoadDiagramTest {
    @Rule
    public final Fixture fixture = new Fixture();
    @Rule
    public final Interactive<RailRoadViewer.Context, Map<String, Document>> interactive = new Interactive<RailRoadViewer.Context, Map<String, Document>>(new RailRoadViewer());

    @Test
    public void shouldGenerateLiteral() throws Exception {
        this.generate(Grammar.literal((String)"FOO"));
    }

    @Test
    public void shouldGenerateNonTerminal() throws Exception {
        this.generate(Grammar.grammar((String)"bar", (Grammar.Option[])new Grammar.Option[0]).production("bar", Grammar.nonTerminal((String)"foo"), new Grammar.Term[0]).production("foo", Grammar.literal((String)"FOO"), new Grammar.Term[0]));
    }

    @Test
    public void shouldDrawSequence() throws Exception {
        this.generate(Grammar.sequence((Grammar.Term)Grammar.literal((String)"one"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"two"), Grammar.literal((String)"three")}));
    }

    @Test
    public void shouldDrawAlt() throws Exception {
        this.generate(Grammar.oneOf((Grammar.Term)Grammar.literal((String)"short"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"v"), Grammar.literal((String)"something long")}));
    }

    @Test
    public void shouldDrawLoop() throws Exception {
        this.generate(RailRoadDiagramTest.loop(Grammar.literal((String)"item"), Grammar.literal((String)",")));
    }

    @Test
    public void loopWithAlt() throws Exception {
        this.generate(RailRoadDiagramTest.loop(Grammar.oneOf((Grammar.Term)Grammar.literal((String)"one"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"two"), Grammar.literal((String)"three")}), Grammar.oneOf((Grammar.Term)Grammar.literal((String)","), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)";")})));
    }

    @Test
    public void shouldDrawLoopWithNothing() throws Exception {
        this.generate(Grammar.grammar((String)"loops", (Grammar.Option[])new Grammar.Option[0]).production("loops", Grammar.oneOf((Grammar.Term)Grammar.nonTerminal((String)"oneOrMore"), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"zeroOrMore")}), new Grammar.Term[0]).production("zeroOrMore", Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)"hej"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]).production("oneOrMore", Grammar.oneOrMore((Grammar.Term)Grammar.literal((String)"hej"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]));
    }

    @Test
    public void shouldDrawAltWithNothing() throws Exception {
        this.generate(Grammar.grammar((String)"choices", (Grammar.Option[])new Grammar.Option[0]).production("choices", Grammar.oneOf((Grammar.Term)Grammar.nonTerminal((String)"something-or-nothing"), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"nothing-or-something"), Grammar.nonTerminal((String)"optional-something")}), new Grammar.Term[0]).production("something-or-nothing", Grammar.oneOf((Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[]{Grammar.epsilon()}), new Grammar.Term[0]).production("nothing-or-something", Grammar.oneOf((Grammar.Term)Grammar.epsilon(), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"hello")}), new Grammar.Term[0]).production("optional-something", Grammar.oneOf((Grammar.Term)Grammar.optional((Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]));
    }

    @Test
    public void shouldDrawAltWithLoop() throws Exception {
        this.generate(Grammar.oneOf((Grammar.Term)Grammar.literal((String)"one"), (Grammar.Term[])new Grammar.Term[]{Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)"fish"), (Grammar.Term[])new Grammar.Term[0]), Grammar.literal((String)"two")}));
    }

    @Test
    public void allNodes() throws Exception {
        this.generate(Grammar.grammar((String)"nodes", (Grammar.Option[])new Grammar.Option[0]).production("nodes", Grammar.literal((String)"literal"), new Grammar.Term[]{Grammar.charactersOfSet((String)"ID_Start"), Grammar.caseInsensitive((String)"any case"), Grammar.nonTerminal((String)"nodes")}));
    }

    @Test
    public void drawLoopWithBounds() throws Exception {
        this.generate(Grammar.repeat((int)5, (int)10, (Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]));
    }

    @Test
    public void drawLoopWithLoop() throws Exception {
        this.generate(RailRoadDiagramTest.loop(Grammar.literal((String)"hello"), RailRoadDiagramTest.loop(Grammar.literal((String)"one"), Grammar.literal((String)"two"))));
    }

    @Test
    public void shouldDrawCharset() throws Exception {
        this.generate((Grammar.Term)Grammar.charactersOfSet((String)"ID_Start"));
    }

    @Test
    public void shouldDrawCypher() throws Exception {
        this.generate(this.fixture.grammarResource("/cypher.xml", new Grammar.ParserOption[0]));
    }

    @Test
    public void shouldDrawFoo() throws Exception {
        this.generate(this.fixture.grammarResource("/foo.xml", new Grammar.ParserOption[0]));
    }

    @Test
    public void cypherWhitespace() throws Exception {
        this.showCypher("whitespace");
    }

    private void showCypher(String production) throws Exception {
        if (this.interactive.mode() == Interactive.Mode.METHOD) {
            CountDownLatch latch = new CountDownLatch(1);
            Diagram diagram = Diagram.build((Production)this.fixture.grammarResource("/cypher.xml", new Grammar.ParserOption[0]).production(production), (Diagram.BuilderOptions)((Diagram.BuilderOptions)Option.options(Diagram.BuilderOptions.class, (Option[])new Option[0])));
            ShapeRenderer renderer = new ShapeRenderer(new Option[0]);
            RailRoadViewer.frame(latch, "DOM: " + production, (Document)diagram.convert((Diagram.Renderer)renderer, (Diagram.CanvasProvider)SVGShapes.SVG_DOM)).setVisible(true);
            RailRoadViewer.frame(latch, "AWT: " + production, (AwtShapes)diagram.convert((Diagram.Renderer)renderer, AwtShapes.AWT, awt -> awt)).setVisible(true);
            latch.await();
        }
    }

    private static Grammar.Term loop(Grammar.Term component, Grammar.Term delimiter) {
        return Grammar.sequence((Grammar.Term)component, (Grammar.Term[])new Grammar.Term[]{Grammar.zeroOrMore((Grammar.Term)delimiter, (Grammar.Term[])new Grammar.Term[]{component})});
    }

    private final Map<String, Document> generate(Grammar.Term grammar) throws Exception {
        return this.generate(Grammar.grammar((String)this.fixture.testName(), (Grammar.Option[])new Grammar.Option[0]).production(this.fixture.testName(), grammar, new Grammar.Term[0]));
    }

    private final Map<String, Document> generate(Grammar.Builder grammar) throws Exception {
        return this.generate(grammar.build(new Grammar.Builder.Option[0]));
    }

    private final Map<String, Document> generate(Grammar grammar) throws Exception {
        return this.interactive.test(new RailRoadViewer.Context(grammar, new Option[0]));
    }
}

