/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.opencypher.tools.g4tree.BnfSymbols;

public class BnfSymbolsTest {
    @Test
    public void allBnf() {
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"::="));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"<"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)">"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"{"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"}"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"["));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"]"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"|"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"..."));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"$"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"!!"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"::=$"));
        Assert.assertTrue((boolean)BnfSymbols.allBnfSymbols((String)"[][][}"));
        Assert.assertFalse((boolean)BnfSymbols.allBnfSymbols((String)"("));
        Assert.assertFalse((boolean)BnfSymbols.allBnfSymbols((String)"{("));
        Assert.assertFalse((boolean)BnfSymbols.allBnfSymbols((String)"good[9]"));
    }

    @Test
    public void anyBnf() {
        Assert.assertTrue((boolean)BnfSymbols.anyBnfSymbols((String)"this has $ in it"));
        Assert.assertTrue((boolean)BnfSymbols.anyBnfSymbols((String)"$"));
        Assert.assertTrue((boolean)BnfSymbols.anyBnfSymbols((String)"and this { has more } thane[one"));
        Assert.assertTrue((boolean)BnfSymbols.anyBnfSymbols((String)"::=$"));
        Assert.assertFalse((boolean)BnfSymbols.anyBnfSymbols((String)"but this doesn;t hav any"));
        Assert.assertFalse((boolean)BnfSymbols.anyBnfSymbols((String)"o his \"\u00a3%^&*()_but this doesn;t hav any"));
        Assert.assertFalse((boolean)BnfSymbols.anyBnfSymbols((String)".. .. .. .. "));
    }

    @Test
    public void interleaver() {
        this.testInterleaver("tt", "<", "then", "...", "or");
        this.testInterleaver("", "<", "then", "...", "or", "}", "");
        this.testInterleaver("and", "::=", "", "$", "", "<", "=", ">", "");
        this.testInterleaver("tt", "<", "then", "...", "or");
        this.testInterleaver("tt", "<", "then", "...", "or");
    }

    private void testInterleaver(String ... input) {
        Assert.assertFalse((boolean)BnfSymbols.anyBnfSymbols((String)input[0]));
        Assert.assertFalse((boolean)BnfSymbols.anyBnfSymbols((String)input[input.length - 1]));
        String testString = Arrays.asList(input).stream().collect(Collectors.joining());
        System.out.println(testString);
        BnfSymbols.Interleaver interleaver = BnfSymbols.getInterleave((String)testString);
        ArrayList<String> result = new ArrayList<String>();
        while (interleaver.hasNext()) {
            result.add(interleaver.nextText());
            result.add(interleaver.nextSymbol().getActualCharacters());
        }
        result.add(interleaver.nextText());
        Assert.assertEquals(Arrays.asList(input), result);
    }
}

