/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.v4.Tool;
import org.antlr.v4.tool.ANTLRMessage;
import org.antlr.v4.tool.ANTLRToolListener;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.antlr.v4.tool.ast.RuleAST;
import org.junit.Assert;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.io.Output;

public class Antlr4ToolFacade
implements ANTLRToolListener {
    private final List<ANTLRMessage> errors = new ArrayList<ANTLRMessage>();
    private final Tool tool;
    private final Output.Readable buffer;

    public static void assertGeneratesValidParser(String resource) throws Exception {
        Output.Readable buffer = Output.stringBuilder();
        Tool antlr = new Tool();
        Antlr4ToolFacade facade = new Antlr4ToolFacade(antlr, buffer);
        try {
            Antlr4.write((Grammar)Fixture.grammarResource(Antlr4.class, resource, new Grammar.ParserOption[0]), (Output)buffer);
        }
        catch (Throwable e) {
            try {
                facade.reportFailureIn("generating grammar");
            }
            catch (AssertionError x) {
                throw e;
            }
        }
        antlr.addListener((ANTLRToolListener)facade);
        GrammarRootAST ast = antlr.parse(resource, (CharStream)new ANTLRReaderStream(buffer.reader()));
        if (ast.hasErrors) {
            RuleAST lastGood = Antlr4ToolFacade.lastGoodRule((GrammarAST)ast);
            if (lastGood == null) {
                facade.reportFailureIn("parsing grammar");
            } else {
                facade.reportFailureIn("parsing grammar, after " + lastGood.getRuleName() + " on line " + lastGood.getLine());
            }
        }
        antlr.process(antlr.createGrammar(ast), false);
        if (facade.hasErrors()) {
            facade.reportFailureIn("processing grammar");
        }
    }

    private static RuleAST lastGoodRule(GrammarAST ast) {
        if ((ast = (GrammarAST)ast.getFirstChildWithType(97)) == null) {
            return null;
        }
        RuleAST last = null;
        for (GrammarAST rule : ast.getChildrenAsArray()) {
            if (!(rule instanceof RuleAST)) {
                return last;
            }
            last = (RuleAST)rule;
        }
        return null;
    }

    private Antlr4ToolFacade(Tool tool, Output.Readable buffer) {
        this.tool = tool;
        this.buffer = buffer;
    }

    private void reportFailureIn(String phase) {
        Output.lineNumbers((Output)Output.stdOut()).append((CharSequence)this.buffer);
        for (ANTLRMessage msg : this.errors) {
            System.err.println(this.tool.errMgr.getMessageTemplate(msg).render());
        }
        Assert.fail((String)("Antlr failure in " + phase));
    }

    private boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void info(String msg) {
        System.out.println(msg);
    }

    public void error(ANTLRMessage msg) {
        this.errors.add(msg);
    }

    public void warning(ANTLRMessage msg) {
        this.errors.add(msg);
    }
}

