/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.io;

import java.io.Writer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.opencypher.tools.io.MultiplexedOutput;
import org.opencypher.tools.io.Output;
import org.opencypher.tools.io.OutputWriter;

public class OutputTest {
    @Test
    public void multiplexOfSingleOutputYieldsSameOutput() throws Exception {
        for (Output output : new Output[]{Output.nowhere(), Output.stdOut(), Output.stdErr(), Output.stringBuilder()}) {
            Output multiplexed = Output.multiplex((Output[])new Output[]{output});
            Assert.assertSame((Object)output, (Object)multiplexed);
        }
    }

    @Test
    public void multiplexWithNowhereYieldsSameOutput() throws Exception {
        for (Output output : new Output[]{Output.nowhere(), Output.stdOut(), Output.stdErr(), Output.stringBuilder()}) {
            Output multiplexed = Output.multiplex((Output[])new Output[]{output, Output.nowhere()});
            Assert.assertSame((String)"nowhere() last", (Object)output, (Object)multiplexed);
            multiplexed = Output.multiplex((Output[])new Output[]{Output.nowhere(), output});
            Assert.assertSame((String)"nowhere() first", (Object)output, (Object)multiplexed);
        }
    }

    @Test
    public void multiplexShouldDeduplicateInput() throws Exception {
        Output multiplexed = Output.multiplex((Output[])new Output[]{Output.stdOut(), Output.stdOut()});
        Assert.assertEquals((Object)Output.stdOut(), (Object)multiplexed);
    }

    @Test
    public void multiplexShouldFlattenMultiplexedOutput() throws Exception {
        Output a = Output.stdOut();
        Output.Readable b = Output.stringBuilder();
        Output.Readable c = Output.stringBuilder();
        Output d = Output.stdErr();
        Output one = Output.multiplex((Output[])new Output[]{a, b});
        Output two = Output.multiplex((Output[])new Output[]{c, d});
        Output multiplexed = Output.multiplex((Output[])new Output[]{a, one, two, d});
        Assert.assertThat((Object)multiplexed, (Matcher)Matchers.instanceOf(MultiplexedOutput.class));
        Output[] output = (Output[])((MultiplexedOutput)multiplexed).output;
        Assert.assertEquals((long)4L, (long)output.length);
        Assert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)4));
        Assert.assertThat((Object)output, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Output[]{a, b, c, d}));
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.arrayContaining((Matcher[])new Matcher[]{Matchers.instanceOf(MultiplexedOutput.class)})));
    }

    @Test
    public void shouldUnwrapWrappingWriter() throws Exception {
        Output.Readable output = Output.stringBuilder();
        Writer writer = output.writer();
        Output result = Output.output((Writer)writer);
        Assert.assertSame((Object)output, (Object)result);
        Assert.assertThat((Object)writer, (Matcher)Matchers.instanceOf(OutputWriter.class));
    }
}

