/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.GrammarConverter;
import org.opencypher.tools.antlr.g4.Gee4Lexer;
import org.opencypher.tools.antlr.g4.Gee4Parser;
import org.opencypher.tools.g4processors.FailingErrorListener;
import org.opencypher.tools.g4processors.G4Listener;
import org.opencypher.tools.g4tree.GrammarTop;

public class G4Processor {
    public Grammar processString(String inString) {
        return this.processStream(new ByteArrayInputStream(inString.getBytes()));
    }

    public Grammar processStream(InputStream inStream) {
        try {
            return this.processAntlrStream((CharStream)new ANTLRInputStream(inStream));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read or convert java.io.InputStream", e);
        }
    }

    public Grammar processFile(String fileName) {
        try {
            return this.processAntlrStream((CharStream)new ANTLRFileStream(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find or read " + fileName, e);
        }
    }

    private Grammar processAntlrStream(CharStream inStream) {
        Gee4Lexer lexer = new Gee4Lexer(inStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Gee4Parser parser = new Gee4Parser((TokenStream)tokens);
        lexer.addErrorListener((ANTLRErrorListener)new FailingErrorListener());
        parser.addErrorListener((ANTLRErrorListener)new FailingErrorListener());
        Gee4Parser.WholegrammarContext tree = parser.wholegrammar();
        ParseTreeWalker walker = new ParseTreeWalker();
        G4Listener listener = new G4Listener(tokens);
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        GrammarTop itemTree = listener.getTreeTop();
        GrammarConverter converter = new GrammarConverter(itemTree);
        return converter.convert();
    }
}

