/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Production;
import org.opencypher.tools.grammar.BnfWriter;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.io.Output;

public class Antlr4
extends BnfWriter {
    static String PREFIX;
    private static String prefix;
    private final Map<String, CharacterSet> fragmentRules = new HashMap<String, CharacterSet>();
    private final Set<String> seenKeywords = new HashSet<String>();
    private final Map<String, String> keywordsInProduction = new LinkedHashMap<String, String>();
    private String currentProduction;
    private int nextLexerRule;

    public static void setPrefix(String newPrefix) {
        prefix = newPrefix;
    }

    public static void resetPrefix() {
        prefix = PREFIX;
    }

    public static void write(Grammar grammar, Writer writer) {
        Antlr4.write(grammar, Output.output(writer));
    }

    public static void write(Grammar grammar, OutputStream stream) {
        Antlr4.write(grammar, Output.output(stream));
    }

    public static void write(Grammar grammar, Output output) {
        String header = grammar.header();
        if (header != null) {
            output.println("/**").append(" * ").printLines(header, " * ").println(" */");
        }
        output.append("grammar ").append(grammar.language()).println(";").println();
        try (Antlr4 antlr = new Antlr4(output);){
            grammar.accept(antlr);
        }
    }

    public static void main(String ... args) throws Exception {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        int index = argsList.indexOf("-o");
        String g4OutputFilePath = null;
        if (index >= 0) {
            g4OutputFilePath = (String)argsList.remove(index + 1);
            argsList.remove(index);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Main.execute(Antlr4::write, out, "grammar/cypher.xml");
        if (g4OutputFilePath == null) {
            System.out.print(out.toString(StandardCharsets.UTF_8.name()));
        } else {
            Files.write(Paths.get(g4OutputFilePath, new String[0]), out.toByteArray(), new OpenOption[0]);
            System.out.println("Wrote output grammar to " + g4OutputFilePath);
        }
    }

    private Antlr4(Output output) {
        super(output);
    }

    @Override
    public void close() {
        for (Map.Entry<String, CharacterSet> rule : this.fragmentRules.entrySet()) {
            CharacterSet set = rule.getValue();
            this.output.append("fragment ");
            this.lexerRule(rule.getKey()).append(" : ");
            if (set.name() != null && !set.isControlCharacter()) {
                this.output.append("[\\p{").append(set.name()).append("}]");
            } else if ("ANY".equals(set.name())) {
                set.accept(new AnyCharacterExceptFormatter(this.output));
            } else if (set.hasExclusions()) {
                set.accept(new AnyCharacterExceptFormatter(this.output));
            } else {
                this.output.append('[');
                set.accept(new SetFormatter(this.output));
                this.output.append(']');
            }
            this.output.println(" ;").println();
        }
    }

    @Override
    protected void productionCommentPrefix() {
        this.output.println("/**").append(" * ");
    }

    @Override
    protected void productionCommentLinePrefix() {
        this.output.append(" * ");
    }

    @Override
    protected void productionCommentSuffix() {
        this.output.println(" */");
    }

    @Override
    protected void productionStart(Production p) {
        this.currentProduction = p.name();
        if (p.lexer()) {
            this.lexerRule(this.currentProduction);
        } else {
            this.parserRule(this.currentProduction);
            this.nextLexerRule = 0;
        }
        this.alternativesLinePrefix(this.currentProduction.length());
        this.output.append(":  ");
    }

    @Override
    protected void productionEnd() {
        this.output.println(" ;").println();
        for (Map.Entry<String, String> lexerRule : this.keywordsInProduction.entrySet()) {
            String ruleName = lexerRule.getKey();
            if (this.seenKeywords.contains(ruleName)) continue;
            this.seenKeywords.add(ruleName);
            this.caseInsensitiveProductionStart(ruleName);
            for (char c : lexerRule.getValue().toCharArray()) {
                this.groupWith('(', () -> {
                    this.literal(String.valueOf(c).toUpperCase());
                    this.alternativesSeparator();
                    this.literal(String.valueOf(c).toLowerCase());
                }, ')');
                this.sequenceSeparator();
            }
            this.output.println(" ;").println();
        }
        this.keywordsInProduction.clear();
        this.currentProduction = null;
    }

    private void addFragmentRule(CharacterSet characters) {
        String rule = this.currentProduction + "_" + this.nextLexerRule++;
        this.fragmentRules.put(rule, characters);
        this.lexerRule(rule);
    }

    @Override
    protected void alternativesLinePrefix(int altPrefix) {
        if (altPrefix > 0) {
            this.output.println();
            while (altPrefix-- > 0) {
                this.output.append(' ');
            }
        }
    }

    @Override
    protected void alternativesSeparator() {
        this.output.append(" | ");
    }

    @Override
    protected void sequenceSeparator() {
        this.output.append(" ");
    }

    @Override
    protected void groupPrefix() {
        this.output.append("( ");
    }

    @Override
    protected void groupSuffix() {
        this.output.append(" )");
    }

    @Override
    protected boolean optionalPrefix() {
        return false;
    }

    @Override
    protected void optionalSuffix() {
        this.output.append("?");
    }

    @Override
    protected void repeat(int minTimes, Integer maxTimes, Runnable repeated) {
        if (maxTimes == null) {
            if (minTimes == 0) {
                this.groupWith('(', repeated, ')');
                this.output.append("*");
                return;
            }
            if (minTimes == 1) {
                this.groupWith('(', repeated, ')');
                this.output.append("+");
                return;
            }
        } else {
            if (maxTimes == 1 && minTimes == 0) {
                this.groupWith('(', repeated, ')');
                this.optionalSuffix();
                return;
            }
            if (minTimes == maxTimes) {
                this.groupWith('(', () -> {
                    for (int i = 0; i < minTimes; ++i) {
                        if (i > 0) {
                            this.sequenceSeparator();
                        }
                        repeated.run();
                    }
                }, ')');
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("The Antlr formatter does not support minTimes=%d, maxTimes=%s", minTimes, maxTimes));
    }

    @Override
    protected void characterSet(CharacterSet characters) {
        String setName = characters.name();
        if (setName == null) {
            this.addFragmentRule(characters);
        } else if (setName.equals("EOI")) {
            this.output.append("EOF");
        } else {
            this.fragmentRules.put(setName, characters);
            this.lexerRule(setName);
        }
    }

    @Override
    protected void nonTerminal(NonTerminal nonTerminal) {
        if (nonTerminal.production().lexer()) {
            this.lexerRule(nonTerminal.productionName());
        } else {
            this.parserRule(nonTerminal.productionName());
        }
    }

    private String unspaceString(String original) {
        return original.replaceAll("\\s+", "_");
    }

    private Output parserRule(String name) {
        return this.output.append(this.prefix(this.unspaceString(name)));
    }

    private Output lexerRule(String original) {
        String name = this.unspaceString(original);
        int cp = name.codePointAt(0);
        if (!Character.isUpperCase(cp)) {
            if (name.codePoints().noneMatch(Character::isUpperCase)) {
                return this.output.append(name.toUpperCase());
            }
            return this.output.appendCodePoint(Character.toUpperCase(cp)).append(name, Character.charCount(cp), name.length());
        }
        return this.output.append(name);
    }

    @Override
    protected String prefix(String s) {
        return prefix + s;
    }

    @Override
    protected void literal(String value) {
        this.escapeAndEnclose(value);
    }

    private boolean reserved(String ruleName) {
        return ruleName.equals("SKIP");
    }

    private void inline(String value) {
        this.group(() -> {
            int cp;
            String sep = "";
            int start = 0;
            int end = value.length();
            for (int i = 0; i < end; i += Character.charCount(cp)) {
                cp = value.charAt(i);
                if (!Character.isLowerCase(cp) && !Character.isUpperCase(cp) && !Character.isTitleCase(cp)) continue;
                if (start < i) {
                    this.output.append(sep);
                    sep = " ";
                    this.escapeAndEnclose(value.substring(start, i));
                }
                this.output.append(sep);
                sep = " ";
                start = i + Character.charCount(cp);
                cp = Character.toUpperCase(cp);
                String upper = String.valueOf((char)cp);
                this.escapeAndEnclose(upper);
                this.alternativesSeparator();
                this.escapeAndEnclose(upper.toLowerCase());
            }
            if (start < value.length()) {
                this.output.append(sep);
                this.escapeAndEnclose(value.substring(start));
            }
        });
    }

    @Override
    protected void caseInsensitive(String value) {
        if (value.length() == 1) {
            this.inline(value);
        } else {
            Object lexerRule = value.toUpperCase();
            if (!Character.isLetter(value.codePointAt(0)) || this.reserved((String)lexerRule)) {
                lexerRule = "L_" + (String)lexerRule;
            }
            this.output.append((String)lexerRule);
            this.keywordsInProduction.put((String)lexerRule, value);
        }
    }

    private void escapeAndEnclose(String value) {
        this.output.append("'").escape(value, Antlr4::escapes).append("'");
    }

    @Override
    protected void caseInsensitiveProductionStart(String name) {
        this.currentProduction = name;
        this.lexerRule(this.currentProduction).append(" : ");
        this.nextLexerRule = 0;
    }

    @Override
    protected void epsilon() {
    }

    private static String escapes(int cp) {
        switch (cp) {
            case 13: {
                return "\\r";
            }
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 39: {
                return "\\'";
            }
            case 92: {
                return "\\\\";
            }
        }
        if (cp >= 128) {
            String hex = Integer.toHexString(cp);
            return "\\u" + (hex.length() < 4 ? "00" : "") + Integer.toHexString(cp);
        }
        return null;
    }

    private static void codePoint(Output output, int cp) {
        switch (cp) {
            case 13: {
                output.append("\\r");
                break;
            }
            case 10: {
                output.append("\\n");
                break;
            }
            case 9: {
                output.append("\\t");
                break;
            }
            case 8: {
                output.append("\\b");
                break;
            }
            case 12: {
                output.append("\\f");
                break;
            }
            case 92: {
                output.append("\\\\");
                break;
            }
            case 45: {
                output.append("\\-");
                break;
            }
            case 93: {
                output.append("\\]");
                break;
            }
            default: {
                if (32 <= cp && cp <= 126) {
                    output.appendCodePoint(cp);
                    break;
                }
                output.format("\\u%04X", cp);
            }
        }
    }

    static {
        prefix = PREFIX = "oC_";
    }

    private static class SetFormatter
    implements CharacterSet.DefinitionVisitor<RuntimeException> {
        private final Output output;

        SetFormatter(Output output) {
            this.output = output;
        }

        @Override
        public void visitCodePoint(int cp) {
            if (cp <= 65535) {
                Antlr4.codePoint(this.output, cp);
            }
        }

        @Override
        public void visitRange(int start, int end) {
            if (end <= 65535) {
                Antlr4.codePoint(this.output, start);
                this.output.append('-');
                Antlr4.codePoint(this.output, end);
            } else if (start <= 65535) {
                Antlr4.codePoint(this.output, start);
                this.output.append('-');
                Antlr4.codePoint(this.output, 65535);
            }
        }
    }

    private static class AnyCharacterExceptFormatter
    implements CharacterSet.DefinitionVisitor.NamedSetVisitor<RuntimeException>,
    CharacterSet.ExclusionVisitor<RuntimeException> {
        private final Output output;

        AnyCharacterExceptFormatter(Output output) {
            this.output = output;
        }

        @Override
        public CharacterSet.ExclusionVisitor<RuntimeException> visitSet(String name) {
            this.output.append("~[");
            return this;
        }

        @Override
        public void visitCodePoint(int cp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void excludeCodePoint(int cp) {
            Antlr4.codePoint(this.output, cp);
        }

        @Override
        public void excludeRange(int start, int end) {
            Antlr4.codePoint(this.output, start);
            this.output.append('-');
            Antlr4.codePoint(this.output, end);
        }

        @Override
        public void excludeSet(String name) {
            throw new UnsupportedOperationException("ANY except a named set.");
        }

        @Override
        public void close() {
            this.output.append("]");
        }
    }
}

