/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Production;
import org.opencypher.tools.g4tree.BnfSymbols;
import org.opencypher.tools.grammar.BnfWriter;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.io.HtmlTag;
import org.opencypher.tools.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBNF
extends BnfWriter {
    private static final String DESCRIPTION_LINE_MARKER = "// ";
    private static final String CHARACTER_SET_START = "$";
    private static final String CHARACTER_SET_END = "$";
    private static final String CODEPOINT_LIST_START = "[";
    private static final String CODEPOINT_LIST_END = "]";
    private static final String CHARACTER_SET_EXCEPT = "~";
    public static final String LETTER_SUFFIX = " case insensitive";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SQLBNF.class.getName());
    private final Set<String> seenKeywords = new HashSet<String>();
    private final Map<String, String> keywordsInProduction = new LinkedHashMap<String, String>();
    private boolean markedBnfRule = false;
    private BnfSymbols bnfSymbolFromRuleName;
    private final Set<BnfSymbols> bnfSymbolsNeedingRules = new HashSet<BnfSymbols>();
    private final Set<String> existingRulesWithBnfSymbolNames = new HashSet<String>();

    public static void write(Grammar grammar, Writer writer) {
        SQLBNF.write(grammar, Output.output(writer));
    }

    public static void write(Grammar grammar, OutputStream stream) {
        SQLBNF.write(grammar, Output.output(stream));
    }

    public static void write(Grammar grammar, Output output) {
        String header = grammar.header();
        if (header != null) {
            output.println(DESCRIPTION_LINE_MARKER).append(DESCRIPTION_LINE_MARKER).printLines(header, DESCRIPTION_LINE_MARKER).println(DESCRIPTION_LINE_MARKER).println();
        }
        try (SQLBNF writer = new SQLBNF(output);){
            grammar.accept(writer);
        }
    }

    public static void main(String ... args) throws Exception {
        Main.execute(SQLBNF::write, args);
    }

    public static void append(Grammar.Term term, Output output) {
        term.accept(new SQLBNF(output));
    }

    public static Output string(Output str, Production production) {
        return str.append(production.definition(), SQLBNF::append);
    }

    public static void html(HtmlTag parent, Production production, HtmlLinker linker) {
        try (HtmlTag pre = parent.tag("pre", new HtmlTag.Attribute[0]);
             HtmlTag code = pre.tag("code", new HtmlTag.Attribute[0]);){
            new Html(code, linker).visitProduction(production);
        }
    }

    private SQLBNF(Output output) {
        super(output);
    }

    @Override
    protected void productionCommentPrefix() {
        this.output.append(DESCRIPTION_LINE_MARKER);
    }

    @Override
    protected void productionCommentLinePrefix() {
        this.output.append(DESCRIPTION_LINE_MARKER);
    }

    @Override
    protected void productionCommentSuffix() {
    }

    @Override
    protected void productionStart(Production p) {
        String ruleName = p.name();
        this.output.append("<").append(ruleName).append("> ::=");
        this.alternativesLinePrefix(ruleName.length() + 3);
        this.markedBnfRule = p.bnfsymbols();
        this.bnfSymbolFromRuleName = BnfSymbols.getByName(ruleName);
        LOGGER.debug("matching {} to {}", (Object)ruleName, (Object)this.bnfSymbolFromRuleName);
        if (this.bnfSymbolFromRuleName != null) {
            this.existingRulesWithBnfSymbolNames.add(ruleName);
        }
    }

    @Override
    protected String prefix(String s) {
        return s;
    }

    @Override
    protected void productionEnd() {
        this.output.println().println();
        this.bnfSymbolFromRuleName = null;
        for (Map.Entry<String, String> keywordProduction : this.keywordsInProduction.entrySet()) {
            String ruleName = keywordProduction.getKey();
            if (this.seenKeywords.contains(ruleName)) continue;
            this.seenKeywords.add(ruleName);
            this.caseInsensitiveProductionStart(ruleName);
            String glue = "";
            for (char c : keywordProduction.getValue().toCharArray()) {
                this.addCaseChar(Character.toUpperCase(c));
                this.output.append(glue).append("<").append(String.valueOf(c).toUpperCase()).append(">");
                glue = " ";
            }
            this.output.println().println();
        }
        this.keywordsInProduction.clear();
    }

    @Override
    protected void alternativesLinePrefix(int altPrefix) {
        if (altPrefix > 0) {
            this.output.println();
            while (altPrefix-- > 0) {
                this.output.append(' ');
            }
        }
    }

    @Override
    protected void alternativesSeparator() {
        this.output.append(" | ");
    }

    @Override
    protected void sequenceSeparator() {
        this.output.append(" ");
    }

    @Override
    protected void literal(String value) {
        if (this.markedBnfRule) {
            this.output.append(value);
            return;
        }
        if (value.startsWith("!! ")) {
            this.output.append(value);
            return;
        }
        if (value.equals("//")) {
            this.output.append("\\u002F\\u002F");
            return;
        }
        if (this.bnfSymbolFromRuleName != null) {
            if (value.equals((Object)this.bnfSymbolFromRuleName)) {
                LOGGER.warn("Production name {} for '{}'", (Object)this.bnfSymbolFromRuleName.getBnfName(), (Object)this.bnfSymbolFromRuleName.getActualCharacters());
                this.output.append(value);
                return;
            }
            LOGGER.warn("Production name {} is that of expected bnf definition for '{}'", (Object)this.bnfSymbolFromRuleName.getBnfName(), (Object)(this.bnfSymbolFromRuleName.getActualCharacters() + " but contains " + value));
        }
        String sep = "";
        if (BnfSymbols.anyBnfSymbols(value)) {
            String text;
            BnfSymbols.Interleaver interleaver = BnfSymbols.getInterleave(value);
            while (interleaver.hasNext()) {
                text = interleaver.nextText();
                if (text.length() > 0) {
                    this.output.append(sep).append(text);
                    sep = " ";
                }
                BnfSymbols symbol = interleaver.nextSymbol();
                this.bnfSymbolsNeedingRules.add(symbol);
                this.output.append(sep).append("<").append(symbol.getBnfName()).append(">");
                sep = " ";
            }
            text = interleaver.nextText();
            if (text.length() > 0) {
                this.output.append(sep).append(text);
            }
        } else {
            char[] chars;
            for (char cp : chars = value.toCharArray()) {
                if (' ' < cp && cp <= '~') {
                    this.output.appendCodePoint(cp);
                    continue;
                }
                this.output.format(" \\u%04X ", cp);
            }
        }
    }

    @Override
    protected void caseInsensitive(String value) {
        LOGGER.debug("caseinsens {}", (Object)value);
        String keywordProduction = value.toUpperCase();
        this.output.append("<").append(keywordProduction).append(">");
        if (value.length() == 1) {
            this.addCaseChar(keywordProduction.codePointAt(0));
        } else {
            this.keywordsInProduction.put(keywordProduction, value);
        }
    }

    private void inline(String value) {
        this.group(() -> {
            int cp;
            String sep = "";
            int start = 0;
            int end = value.length();
            for (int i = 0; i < end; i += Character.charCount(cp)) {
                cp = value.charAt(i);
                if (!Character.isLowerCase(cp) && !Character.isUpperCase(cp) && !Character.isTitleCase(cp)) continue;
                if (start < i) {
                    this.output.append(sep);
                    sep = " ";
                    this.enclose(value.substring(start, i));
                }
                this.output.append(sep);
                sep = " ";
                start = i + Character.charCount(cp);
                cp = Character.toUpperCase(cp);
                this.addCaseChar(cp);
                this.appendCaseChar(cp);
            }
            if (start < value.length()) {
                this.output.append(sep);
                this.enclose(value.substring(start));
            }
        });
    }

    void appendCaseChar(int cp) {
        this.output.appendCodePoint(cp);
    }

    private void enclose(String value) {
        this.output.append(value);
    }

    private void encloseGroupElements(String value, char enclose, int sq, char other) {
        int start = 0;
        int end = sq;
        while (end != -1) {
            this.output.append(enclose).append(value.subSequence(start, end)).append(enclose).append(", ");
            char last = enclose;
            enclose = other;
            other = last;
            start = end;
            end = value.indexOf(enclose, end + 1);
        }
        this.output.append(enclose).append(value.subSequence(start, value.length())).append(enclose);
    }

    @Override
    protected void caseInsensitiveProductionStart(String name) {
        this.output.append("<").append(name).append("> ::= ");
    }

    @Override
    protected void epsilon() {
    }

    @Override
    protected void characterSet(CharacterSet characters) {
        this.output.append("$");
        String name = characters.name();
        if (name != null && !name.equals("ANY")) {
            this.output.append(name);
        } else {
            characters.accept(new CharacterSet.DefinitionVisitor.NamedSetVisitor<RuntimeException>(){
                String sep = "[";

                @Override
                public void visitCodePoint(int cp) {
                    SQLBNF.this.output.append(this.sep);
                    this.codePoint(cp);
                    this.sep = "";
                }

                @Override
                public CharacterSet.ExclusionVisitor<RuntimeException> visitSet(String name) {
                    SQLBNF.this.output.append(SQLBNF.CHARACTER_SET_EXCEPT);
                    return new CharacterSet.ExclusionVisitor<RuntimeException>(){
                        String sep = "[";

                        @Override
                        public void excludeCodePoint(int cp) throws RuntimeException {
                            SQLBNF.this.output.append(this.sep);
                            this.codePoint(cp);
                            this.sep = "";
                        }

                        @Override
                        public void excludeSet(String name) {
                            throw new UnsupportedOperationException("can't do exclusion of set name");
                        }

                        @Override
                        public void close() throws RuntimeException {
                        }
                    };
                }

                private void codePoint(int cp) {
                    switch (cp) {
                        case 13: {
                            SQLBNF.this.output.append("\\r");
                            break;
                        }
                        case 10: {
                            SQLBNF.this.output.append("\\n");
                            break;
                        }
                        case 9: {
                            SQLBNF.this.output.append("\\t");
                            break;
                        }
                        case 8: {
                            SQLBNF.this.output.append("\\b");
                            break;
                        }
                        case 12: {
                            SQLBNF.this.output.append("\\f");
                            break;
                        }
                        case 92: {
                            SQLBNF.this.output.append("\\\\");
                            break;
                        }
                        case 45: {
                            SQLBNF.this.output.append("\\-");
                            break;
                        }
                        case 93: {
                            SQLBNF.this.output.append("\\]");
                            break;
                        }
                        case 36: {
                            SQLBNF.this.output.append("\\$");
                            break;
                        }
                        default: {
                            if (32 < cp && cp <= 126) {
                                SQLBNF.this.output.appendCodePoint(cp);
                                break;
                            }
                            SQLBNF.this.output.format("\\u%04X", cp);
                        }
                    }
                }
            });
            this.output.append(CODEPOINT_LIST_END);
        }
        this.output.append("$");
    }

    @Override
    protected void nonTerminal(NonTerminal nonTerminal) {
        this.output.append("<").append(nonTerminal.productionName()).append(">");
    }

    @Override
    protected boolean optionalPrefix() {
        this.output.append("[ ");
        return true;
    }

    @Override
    protected void optionalSuffix() {
        this.output.append(" ]");
    }

    @Override
    protected void repeat(int minTimes, Integer maxTimes, Runnable repeated) {
        if (maxTimes == null) {
            if (minTimes == 0) {
                this.groupWith('[', repeated, ']');
            } else {
                this.groupWith('{', repeated, '}');
            }
            this.output.append(" ...");
        } else {
            int i;
            for (i = 0; i < minTimes; ++i) {
                this.groupWith('{', repeated, '}');
            }
            for (i = minTimes; i < maxTimes; ++i) {
                this.groupWith('[', repeated, ']');
            }
        }
    }

    @Override
    public void close() {
        for (BnfSymbols lit : this.bnfSymbolsNeedingRules) {
            String name = lit.getBnfName();
            if (this.existingRulesWithBnfSymbolNames.contains(name)) continue;
            this.output.append("<").append(name).append("> ::= ").append(lit.getBnfForm());
            this.output.println().println();
        }
        Iterator<BnfSymbols> iterator = this.caseChars.iterator();
        while (iterator.hasNext()) {
            int chr = (Integer)((Object)iterator.next());
            int upper = Character.toUpperCase(chr);
            int lower = Character.toLowerCase(chr);
            int title = Character.toTitleCase(chr);
            this.caseInsensitiveProductionStart(String.valueOf((char)upper));
            this.output.append((char)upper);
            this.alternativesSeparator();
            this.output.append((char)lower);
            if (title != upper) {
                this.alternativesSeparator();
                this.output.append((char)title);
            }
            this.productionEnd();
        }
    }

    @Override
    protected void groupPrefix() {
        this.output.append('{');
    }

    @Override
    protected void groupSuffix() {
        this.output.append('}');
    }

    private static class Html
    extends SQLBNF {
        private final HtmlTag html;
        private final HtmlLinker linker;

        Html(HtmlTag html, HtmlLinker linker) {
            super(html.output());
            this.html = html;
            this.linker = linker;
        }

        @Override
        protected void nonTerminal(NonTerminal nonTerminal) {
            try (HtmlTag ignored = this.link(this.linker.referenceLink(nonTerminal));){
                super.nonTerminal(nonTerminal);
            }
        }

        @Override
        protected void characterSet(CharacterSet characters) {
            try (HtmlTag ignored = this.link(this.linker.charsetLink(characters));){
                super.characterSet(characters);
            }
        }

        @Override
        protected void literal(String value) {
            try (HtmlTag ignored = this.link(this.literalLink(value));){
                super.literal(value);
            }
        }

        @Override
        void appendCaseChar(int cp) {
            int lo = Character.toLowerCase(cp);
            int up = Character.toUpperCase(cp);
            int title = Character.toTitleCase(cp);
            Output.Readable link = Output.stringBuilder();
            link.append('[').format("[\\u%04X]", lo);
            if (up != lo) {
                link.format("[\\u%04X]", up);
            }
            if (title != up && title != lo) {
                link.format("[\\u%04X]", title);
            }
            try (HtmlTag ignored = this.link(this.linker.charsetLink(link.append(']').toString()));){
                super.appendCaseChar(cp);
            }
        }

        private HtmlTag link(String target) {
            return target == null ? null : this.html.tag("a", HtmlTag.attr("href", target));
        }

        private String literalLink(String literal) {
            if (!literal.isEmpty()) {
                int cp = literal.codePointAt(0);
                if (literal.length() == Character.charCount(cp)) {
                    return this.linker.charsetLink(String.format("[\\u%04X]", cp));
                }
            }
            return null;
        }

        @Override
        protected void productionEnd() {
            this.output.println(" ;");
        }
    }

    public static interface HtmlLinker {
        public String referenceLink(NonTerminal var1);

        default public String charsetLink(CharacterSet charset) {
            return this.charsetLink(CharacterSet.Unicode.toSetString(charset));
        }

        public String charsetLink(String var1);
    }
}

