/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.opencypher.tools.io.BufferOutput;
import org.opencypher.tools.io.CharSequenceReader;
import org.opencypher.tools.io.LineNumberingOutput;
import org.opencypher.tools.io.MultiplexedOutput;
import org.opencypher.tools.io.Nowhere;
import org.opencypher.tools.io.OutputWriter;
import org.opencypher.tools.io.StreamOutput;
import org.opencypher.tools.io.StringBufferOutput;
import org.opencypher.tools.io.StringBuilderOutput;
import org.opencypher.tools.io.WriterOutput;

public interface Output
extends Appendable,
Closeable {
    public static Output output(OutputStream stream) {
        return new StreamOutput(stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream));
    }

    public static Output output(Writer writer) {
        if (writer instanceof OutputWriter) {
            return ((OutputWriter)writer).output;
        }
        return new WriterOutput(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public static Readable output(StringBuilder builder) {
        return new StringBuilderOutput(builder);
    }

    public static Readable output(StringBuffer buffer) {
        return new StringBufferOutput(buffer);
    }

    public static Output output(CharBuffer buffer) {
        return new BufferOutput(buffer);
    }

    public static Output output(Path path) {
        try {
            return Output.output(Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open " + path, e);
        }
    }

    public static Readable stringBuilder() {
        return Output.output(new StringBuilder());
    }

    public static Output stringBuilder(int size) {
        return Output.output(new StringBuilder(size));
    }

    public static Output stdOut() {
        return Output.output(System.out);
    }

    public static Output stdErr() {
        return Output.output(System.err);
    }

    public static Readable nowhere() {
        return Nowhere.OUTPUT;
    }

    public static Output lineNumbers(Output output) {
        return new LineNumberingOutput(output);
    }

    public static Output multiplex(Output ... output) {
        if (output == null || output.length == 0) {
            return Output.nowhere();
        }
        if (output.length == 1) {
            return output[0];
        }
        HashSet<Output> flattened = new HashSet<Output>();
        boolean altered = false;
        for (Output item : output) {
            if (item instanceof MultiplexedOutput) {
                Collections.addAll(flattened, (Output[])((MultiplexedOutput)item).output);
                altered = true;
                continue;
            }
            if (item == Nowhere.OUTPUT) {
                altered = true;
                continue;
            }
            if (flattened.add(item)) continue;
            altered = true;
        }
        if (!altered) {
            return new MultiplexedOutput(output);
        }
        if (flattened.size() == 0) {
            return Output.nowhere();
        }
        if (flattened.size() == 1) {
            return (Output)flattened.iterator().next();
        }
        return new MultiplexedOutput(flattened.toArray(new Output[flattened.size()]));
    }

    default public Output and(Output output) {
        return Output.multiplex(this, output);
    }

    public static <T> String string(T value, BiConsumer<T, Output> writer) {
        return Output.stringBuilder().append(value, writer).toString();
    }

    public static String lines(String ... lines) {
        StringBuilder result = new StringBuilder();
        String NL = System.lineSeparator();
        for (String line : lines) {
            result.append(line).append(NL);
        }
        return result.toString();
    }

    default public Output escape(CharSequence str, IntFunction<String> replacement) {
        return this.escape(str, 0, str.length(), replacement);
    }

    default public Output escape(CharSequence str, int start, int end, IntFunction<String> replacement) {
        int cp;
        if (start < 0 || end > str.length()) {
            throw new IllegalArgumentException(String.format("start=%d, end=%d, length=%d", start, end, str.length()));
        }
        for (int i = 0; i < end; i += Character.charCount(cp)) {
            cp = Output.codePointAt(str, i);
            String replaced = replacement.apply(cp);
            if (replaced == null) continue;
            if (i > start) {
                this.append(str, start, i);
            }
            this.append(replaced);
            start = i + Character.charCount(cp);
        }
        if (start < end) {
            this.append(str, start, end);
        }
        return this;
    }

    default public <T> Output append(T value, BiConsumer<T, Output> writer) {
        writer.accept(value, this);
        return this;
    }

    @Override
    public Output append(char var1);

    @Override
    default public Output append(CharSequence str) {
        return this.append(str, 0, str.length());
    }

    @Override
    default public Output append(CharSequence str, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(str.charAt(i));
        }
        return this;
    }

    default public Output append(boolean x) {
        this.append(Boolean.toString(x));
        return this;
    }

    default public Output append(int x) {
        this.append(Integer.toString(x));
        return this;
    }

    default public Output append(long x) {
        this.append(Long.toString(x));
        return this;
    }

    default public Output append(float x) {
        this.append(Float.toString(x));
        return this;
    }

    default public Output append(double x) {
        this.append(Double.toString(x));
        return this;
    }

    default public Output appendCodePoint(int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            this.append((char)codePoint);
        } else if (Character.isValidCodePoint(codePoint)) {
            this.append(Character.highSurrogate(codePoint));
            this.append(Character.lowSurrogate(codePoint));
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    default public Output append(String str) {
        return this.append((CharSequence)str);
    }

    default public Output append(char[] str) {
        return this.append(CharBuffer.wrap(str));
    }

    default public Output append(char[] str, int offset, int len) {
        return this.append(CharBuffer.wrap(str, offset, len));
    }

    default public Output printLines(String text, String separator) {
        int cp;
        boolean emit = false;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            if (emit) {
                this.append(separator);
            }
            cp = text.codePointAt(i);
            this.appendCodePoint(cp);
            emit = cp == 10;
        }
        if (!emit && !text.isEmpty()) {
            this.append(System.lineSeparator());
        }
        return this;
    }

    default public Output println() {
        return this.append(System.lineSeparator());
    }

    default public Output println(boolean x) {
        return this.append(x).println();
    }

    default public Output println(char x) {
        return this.append(x).println();
    }

    default public Output println(int x) {
        return this.append(x).println();
    }

    default public Output println(long x) {
        return this.append(x).println();
    }

    default public Output println(float x) {
        return this.append(x).println();
    }

    default public Output println(double x) {
        return this.append(x).println();
    }

    default public Output println(char[] str) {
        return this.append(str).println();
    }

    default public Output println(String str) {
        return this.append(str).println();
    }

    default public Output format(String format, Object ... args) {
        return this.format(Locale.getDefault(Locale.Category.FORMAT), format, args);
    }

    default public Output format(Locale l, String format, Object ... args) {
        new Formatter(this, l).format(l, format, args);
        return this;
    }

    default public void flush() {
    }

    @Override
    default public void close() {
    }

    default public Writer writer() {
        return new OutputWriter(this);
    }

    public static int codePointAt(CharSequence str, int index) {
        if (str instanceof String) {
            return ((String)str).codePointAt(index);
        }
        if (str instanceof Readable) {
            return ((Readable)str).codePointAt(index);
        }
        if (str instanceof StringBuilder) {
            return ((StringBuilder)str).codePointAt(index);
        }
        if (str instanceof StringBuffer) {
            return ((StringBuffer)str).codePointAt(index);
        }
        return Character.codePointAt(str, index);
    }

    public static void getChars(CharSequence source, int begin, int end, char[] target, int off) {
        if (source instanceof String) {
            ((String)source).getChars(begin, end, target, off);
        } else if (source instanceof StringBuilder) {
            ((StringBuilder)source).getChars(begin, end, target, off);
        } else if (source instanceof StringBuffer) {
            ((StringBuffer)source).getChars(begin, end, target, off);
        } else {
            if (begin < 0) {
                throw new StringIndexOutOfBoundsException(begin);
            }
            if (end > source.length()) {
                throw new StringIndexOutOfBoundsException(end);
            }
            if (begin > end) {
                throw new StringIndexOutOfBoundsException(end - begin);
            }
            int len = end - begin;
            for (int i = 0; i < len; ++i) {
                target[i + off] = source.charAt(begin + i);
            }
        }
    }

    public static interface Readable
    extends Output,
    CharSequence {
        public int codePointAt(int var1);

        default public boolean contentEquals(CharSequence that) {
            if (this == that) {
                return true;
            }
            if (this.length() != that.length()) {
                return false;
            }
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                if (this.charAt(i) == that.charAt(i)) continue;
                return false;
            }
            return true;
        }

        default public Reader reader() {
            return new CharSequenceReader(this, 0, this.length());
        }
    }
}

