/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Node;
import org.opencypher.grammar.BiasedTerms;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Optional;

public final class ChoicesFixture {
    private final Choices choices = new Predictable(() -> {
        State state = this.state();
        this.state = null;
        return state;
    });
    private State state = new State();

    public Choices random() {
        return this.choices;
    }

    public void pick(String literal) {
        this.pick(Grammar.literal((String)literal));
    }

    public void pick(Grammar.Term term) {
        this.state().choices.add(term);
    }

    public void pick(int codePoint) {
        this.state().codepoints.add(codePoint);
    }

    public void includeOptional() {
        this.repeat(1, Repetition.OPTIONAL);
    }

    public void excludeOptional() {
        this.repeat(0, Repetition.OPTIONAL);
    }

    public void repeat(int times, Repetition invocation) {
        this.state().repetitions.put(invocation, times);
    }

    public static Repetition onRepetition(int min, int max) {
        return new Repetition(min, max);
    }

    public static Repetition onRepetition(int min) {
        return new Repetition(min, null);
    }

    private State state() {
        if (this.state == null) {
            throw new IllegalStateException(Choices.class.getSimpleName() + " has already been initialized.");
        }
        return this.state;
    }

    private static class Predictable
    implements Choices {
        private Supplier<State> state;

        Predictable(final Supplier<State> state) {
            this.state = new Supplier<State>(){

                @Override
                public synchronized State get() {
                    if (state != this) {
                        return state.get();
                    }
                    State actual = (State)state.get();
                    state = () -> actual;
                    return actual;
                }
            };
        }

        private int repetitions(Repetition invocation) {
            Integer times = this.state.get().repetitions.get(invocation);
            if (times == null) {
                throw new IllegalStateException();
            }
            return times;
        }

        public Grammar.Term choose(Node location, BiasedTerms alternatives) {
            Grammar.Term chosen = null;
            for (Grammar.Term alternative : alternatives) {
                if (!this.state.get().choices.contains(alternative)) continue;
                if (chosen != null) {
                    throw new IllegalStateException();
                }
                chosen = alternative;
            }
            if (chosen == null) {
                throw new IllegalStateException();
            }
            return chosen;
        }

        public int repetition(Node location, org.opencypher.grammar.Repetition repetition) {
            return this.repetitions(new Repetition(repetition.minTimes(), repetition.limited() ? Integer.valueOf(repetition.maxTimes()) : null));
        }

        public boolean includeOptional(Node location, Optional optional) {
            return this.repetitions(Repetition.OPTIONAL) > 0;
        }

        public int codePoint(Node location, CharacterSet characters) {
            return characters.randomCodePoint(null);
        }
    }

    private static class State {
        final Set<Grammar.Term> choices = new HashSet<Grammar.Term>();
        final Map<Repetition, Integer> repetitions = new HashMap<Repetition, Integer>();
        public Set<Integer> codepoints = new HashSet<Integer>();

        private State() {
        }
    }

    public static final class Repetition {
        static final Repetition OPTIONAL = new Repetition(0, 1);
        private final int min;
        private final Integer max;

        private Repetition(int min, Integer max) {
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Repetition that = (Repetition)o;
            return this.min == that.min && Objects.equals(this.max, that.max);
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }
    }
}

