/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.function.Consumer;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.opencypher.generator.Node;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.tools.Assert;
import org.opencypher.tools.io.Output;

public class NodeWritingTest {
    @Rule
    public final TestName testName = new TestName();

    @Test
    public void shouldWriteLiterals() throws Exception {
        this.assertGenerates("abc", NodeWritingTest.literal("a"), NodeWritingTest.literal("b"), NodeWritingTest.literal("c"));
    }

    @Test
    public void shouldWriteTree() throws Exception {
        this.assertGenerates("a1,b2", NodeWritingTest.child("one", NodeWritingTest.literal("a"), NodeWritingTest.literal("1")), NodeWritingTest.literal(","), NodeWritingTest.child("two", NodeWritingTest.literal("b"), NodeWritingTest.literal("2")));
    }

    @Test
    public void emptyNodesAreNotWritten() throws Exception {
        this.assertGenerates("hello", NodeWritingTest.child("ignored", new Consumer[0]), NodeWritingTest.literal("hello"));
    }

    @Test
    public void shouldWriteReplacement() throws Exception {
        this.assertGenerates("!bar", NodeWritingTest.literal("!"), NodeWritingTest.production((ProductionReplacement<Void>)ProductionReplacement.replace((String)"foo", foo -> foo.write((CharSequence)"bar"))));
    }

    @Test
    public void shouldWriteDefaultValueForReplacement() throws Exception {
        this.assertGenerates("!foo", NodeWritingTest.literal("!"), NodeWritingTest.production((ProductionReplacement<Void>)ProductionReplacement.replace((String)"foo", foo -> foo.generateDefault()), NodeWritingTest.literal("foo")));
    }

    @Test
    public void shouldAllowAccessToSurroundingTreeFromReplacements() throws Exception {
        this.assertGenerates("aalpha", NodeWritingTest.child("alpha", NodeWritingTest.literal("a"), NodeWritingTest.production((ProductionReplacement<Void>)ProductionReplacement.replace((String)"beta", beta -> beta.write((CharSequence)beta.node().parent().name())))));
    }

    @SafeVarargs
    final void assertGenerates(String expected, Consumer<Node.Tree> ... data) {
        Node node = this.node(data);
        Assert.assertEquals(() -> Output.string((Object)node, Node::sExpression), expected, Output.string((Object)node, Node::write));
    }

    @SafeVarargs
    final Node node(Consumer<Node.Tree> ... data) {
        return NodeWritingTest.apply(Node.root((String)this.testName.getMethodName()), data);
    }

    static Consumer<Node.Tree> literal(String literal) {
        return node -> node.literal((CharSequence)literal);
    }

    @SafeVarargs
    static Consumer<Node.Tree> child(String name, Consumer<Node.Tree> ... data) {
        return node -> NodeWritingTest.apply(node.child(name), data);
    }

    static Consumer<Node.Tree> production(ProductionReplacement<Void> replacement) {
        return NodeWritingTest.production(replacement, defaults -> {
            throw new UnsupportedOperationException("No default value for " + replacement.production());
        });
    }

    static Consumer<Node.Tree> production(ProductionReplacement<Void> replacement, Consumer<Node.Tree> defaultValue) {
        return node -> node.production(replacement.production(), replacement, null, defaultValue);
    }

    @SafeVarargs
    static Node apply(Node.Tree node, Consumer<Node.Tree> ... data) {
        for (Consumer<Node.Tree> item : data) {
            item.accept(node);
        }
        return node;
    }
}

