/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Interactive<T, R>
implements TestRule {
    private String className;
    private String methodName;
    private final Test<T, R> test;

    public Interactive(Test<T, R> test) {
        this.test = test;
    }

    public final Statement apply(Statement base, Description description) {
        this.className = description.getClassName();
        this.methodName = description.getMethodName();
        return base;
    }

    public final R test(T test) throws Exception {
        switch (this.mode()) {
            case METHOD: {
                return this.test.singleMethod(this.className, this.methodName, test);
            }
            case CLASS: {
                return this.test.singleClass(this.className, this.methodName, test);
            }
        }
        return this.test.suite(this.className, this.methodName, test);
    }

    public Mode mode() {
        String command = System.getProperty("sun.java.command");
        if (command != null && command.matches("com\\.intellij\\.rt\\.(execution\\.)?junit\\.JUnitStarter .*")) {
            if (command.endsWith(" " + this.className + "," + this.methodName)) {
                return Mode.METHOD;
            }
            if (command.endsWith(" " + this.className)) {
                return Mode.CLASS;
            }
        }
        return Mode.SUITE;
    }

    public static enum Mode {
        SUITE,
        CLASS,
        METHOD;

    }

    public static interface Test<T, R> {
        public R suite(String var1, String var2, T var3) throws Exception;

        default public R singleClass(String className, String methodName, T test) throws Exception {
            return this.suite(className, methodName, test);
        }

        default public R singleMethod(String className, String methodName, T test) throws Exception {
            return this.singleClass(className, methodName, test);
        }
    }
}

