/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.io.Output;

public class ISO14977Test {
    @Test
    public void shouldGenerateCypher() throws Exception {
        Output.Readable output = Output.stringBuilder();
        try {
            ISO14977.write((Grammar)Fixture.grammarResource(ISO14977.class, "/cypher.xml", new Grammar.ParserOption[0]), (Output)output);
        }
        catch (Throwable e) {
            Output.lineNumbers((Output)Output.stdOut()).append((CharSequence)output);
            throw e;
        }
    }

    @Test
    public void shouldRenderLiteral() throws Exception {
        ISO14977Test.verify(this.production("foo", Grammar.literal((String)"FOO"), new Grammar.Term[0]), "foo = 'FOO' ;");
    }

    @Test
    public void shouldRenderCaseInsensitiveLiteral() throws Exception {
        ISO14977Test.verify(this.production("foo", Grammar.caseInsensitive((String)"LIteR@L"), new Grammar.Term[0]), "foo = L,I,T,E,R,'@',L ;", "", "E = 'E' | 'e' ;", "", "I = 'I' | 'i' ;", "", "L = 'L' | 'l' ;", "", "R = 'R' | 'r' ;", "", "T = 'T' | 't' ;");
    }

    @Test
    public void shouldRenderLiteralContainingMultipleQuotes() throws Exception {
        ISO14977Test.verify(this.production("literals", Grammar.literal((String)"'\"\"'"), new Grammar.Term[0]), "literals = \"'\", '\"\"', \"'\" ;");
        ISO14977Test.verify(this.production("literals", Grammar.oneOf((Grammar.Term)Grammar.literal((String)"'\"\"'"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"\"''\"")}), new Grammar.Term[0]), "literals = (\"'\", '\"\"', \"'\")", "         | ('\"', \"''\", '\"')", "         ;");
    }

    @Test
    public void shouldRenderAlternativesOfProduction() throws Exception {
        ISO14977Test.verify(this.production("one", Grammar.literal((String)"A"), Grammar.literal((String)"B")), "one = 'A'", "    | 'B'", "    ;");
    }

    @Test
    public void shouldRenderSequenceWithAlternatives() throws Exception {
        ISO14977Test.verify(this.production("something", Grammar.sequence((Grammar.Term)Grammar.literal((String)"A"), (Grammar.Term[])new Grammar.Term[]{Grammar.oneOf((Grammar.Term)Grammar.literal((String)"B"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"C")}), Grammar.literal((String)"D")}), new Grammar.Term[0]), "something = 'A', ('B' | 'C'), 'D' ;");
    }

    @Test
    public void shouldRenderAlternativeSequences() throws Exception {
        ISO14977Test.verify(this.production("alts", Grammar.sequence((Grammar.Term)Grammar.literal((String)"A"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"B")}), Grammar.sequence((Grammar.Term)Grammar.literal((String)"C"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"D")})), "alts = ('A', 'B')", "     | ('C', 'D')", "     ;");
    }

    @Test
    public void shouldRenderRepetitionWithExactCount() throws Exception {
        ISO14977Test.verify(this.production("repeat", Grammar.repeat((int)6, (Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "repeat = 6 * 'hello' ;");
    }

    @Test
    public void shouldRenderRepetitionWithMinAndMax() throws Exception {
        ISO14977Test.verify(this.production("repeat", Grammar.repeat((int)5, (int)10, (Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "repeat = 5 * 'hello', 5 * [ 'hello' ] ;");
    }

    @Test
    public void shouldRenderRepetitionWithMin() throws Exception {
        ISO14977Test.verify(this.production("repeat", Grammar.atLeast((int)3, (Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "repeat = 3 * 'hello', { 'hello' } ;");
    }

    @Test
    public void shouldRenderRepetitionWithMax() throws Exception {
        ISO14977Test.verify(this.production("repeat", Grammar.repeat((int)0, (int)7, (Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "repeat = 7 * [ 'hello' ] ;");
    }

    @Test
    public void shouldRenderOneOrMore() throws Exception {
        ISO14977Test.verify(this.production("repeat", Grammar.oneOrMore((Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "repeat = { 'hello' }- ;");
    }

    @Test
    public void shouldRenderZeroOrMore() throws Exception {
        ISO14977Test.verify(this.production("repeat", Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)"hello"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "repeat = { 'hello' } ;");
    }

    @Test
    public void shouldRenderAlternativeRepetitions() throws Exception {
        ISO14977Test.verify(this.production("stuff", Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)"foo"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"bar")}), Grammar.repeat((int)5, (Grammar.Term)Grammar.literal((String)"abc"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"xyz")})), "stuff = { 'foo', 'bar' }", "      | 5 * ('abc', 'xyz')", "      ;");
    }

    @Test
    public void shouldRenderOptional() throws Exception {
        ISO14977Test.verify(this.production("opt", Grammar.optional((Grammar.Term)Grammar.literal((String)"foo"), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]), "opt = ['foo'] ;");
    }

    @Test
    public void shouldRenderRecursiveDefinition() throws Exception {
        ISO14977Test.verify(this.production("rec", Grammar.sequence((Grammar.Term)Grammar.literal((String)"A"), (Grammar.Term[])new Grammar.Term[]{Grammar.optional((Grammar.Term)Grammar.nonTerminal((String)"rec"), (Grammar.Term[])new Grammar.Term[0]), Grammar.literal((String)"B")}), new Grammar.Term[0]), "rec = 'A', [rec], 'B' ;");
    }

    Grammar.Builder production(String name, Grammar.Term first, Grammar.Term ... alternatives) {
        return Grammar.grammar((String)name, (Grammar.Option[])new Grammar.Option[0]).production(name, first, alternatives);
    }

    static void verify(Grammar.Builder grammar, String ... lines) {
        StringWriter writer = new StringWriter();
        ISO14977.write((Grammar)grammar.build(new Grammar.Builder.Option[0]), (Writer)writer);
        Assert.assertEquals((Object)Output.lines((String[])lines).trim(), (Object)writer.toString().trim());
    }
}

