/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Random;
import org.opencypher.grammar.CodePointSet;
import org.opencypher.tools.io.Output;

public interface CharacterSet {
    public static final String ANY = "ANY";
    public static final String EOI = "EOI";

    public String name();

    public <EX extends Exception> void accept(DefinitionVisitor<EX> var1) throws EX;

    public int randomCodePoint(Random var1);

    public boolean contains(int var1);

    public boolean hasExclusions();

    public boolean isControlCharacter();

    public static String controlCharName(int cp) {
        if (cp < Unicode.CONTROL_CHAR_NAMES.length) {
            return Unicode.CONTROL_CHAR_NAMES[cp];
        }
        if (cp == 127) {
            return Unicode.DEL.name();
        }
        return null;
    }

    public static String escapeCodePoint(int cp) {
        return String.format(cp > 65535 ? "\\U%08X" : "\\u%04X", cp);
    }

    public static enum Unicode {
        ANY(CodePointSet.ANY),
        NUL(CodePointSet.single(0)),
        SOH(CodePointSet.single(1)),
        STX(CodePointSet.single(2)),
        ETX(CodePointSet.single(3)),
        EOT(CodePointSet.single(4)),
        ENQ(CodePointSet.single(5)),
        ACK(CodePointSet.single(6)),
        BEL(CodePointSet.single(7)),
        BS(CodePointSet.single(8)),
        TAB(CodePointSet.single(9)),
        LF(CodePointSet.single(10)),
        VT(CodePointSet.single(11)),
        FF(CodePointSet.single(12)),
        CR(CodePointSet.single(13)),
        SO(CodePointSet.single(14)),
        SI(CodePointSet.single(15)),
        DLE(CodePointSet.single(16)),
        DC1(CodePointSet.single(17)),
        DC2(CodePointSet.single(18)),
        DC3(CodePointSet.single(19)),
        DC4(CodePointSet.single(20)),
        NAK(CodePointSet.single(21)),
        SYN(CodePointSet.single(22)),
        ETB(CodePointSet.single(23)),
        CAN(CodePointSet.single(24)),
        EM(CodePointSet.single(25)),
        SUB(CodePointSet.single(26)),
        ESC(CodePointSet.single(27)),
        FS(CodePointSet.single(28)),
        GS(CodePointSet.single(29)),
        RS(CodePointSet.single(30)),
        US(CodePointSet.single(31)),
        SPACE(CodePointSet.single(32)),
        DEL(CodePointSet.single(127)),
        Cc(CodePointSet.generalCategory((byte)15)),
        Cf(CodePointSet.generalCategory((byte)16)),
        Cn(CodePointSet.generalCategory((byte)0)),
        Co(CodePointSet.generalCategory((byte)18)),
        Cs(CodePointSet.generalCategory((byte)19)),
        Ll(CodePointSet.generalCategory((byte)2)),
        Lm(CodePointSet.generalCategory((byte)4)),
        Lo(CodePointSet.generalCategory((byte)5)),
        Lt(CodePointSet.generalCategory((byte)3)),
        Lu(CodePointSet.generalCategory((byte)1)),
        Mc(CodePointSet.generalCategory((byte)8)),
        Me(CodePointSet.generalCategory((byte)7)),
        Mn(CodePointSet.generalCategory((byte)6)),
        Nd(CodePointSet.generalCategory((byte)9)),
        Nl(CodePointSet.generalCategory((byte)10)),
        No(CodePointSet.generalCategory((byte)11)),
        Pc(CodePointSet.generalCategory((byte)23)),
        Pd(CodePointSet.generalCategory((byte)20)),
        Pe(CodePointSet.generalCategory((byte)22)),
        Pf(CodePointSet.generalCategory((byte)30)),
        Pi(CodePointSet.generalCategory((byte)29)),
        Po(CodePointSet.generalCategory((byte)24)),
        Ps(CodePointSet.generalCategory((byte)21)),
        Sc(CodePointSet.generalCategory((byte)26)),
        Sk(CodePointSet.generalCategory((byte)27)),
        Sm(CodePointSet.generalCategory((byte)25)),
        So(CodePointSet.generalCategory((byte)28)),
        Zl(CodePointSet.generalCategory((byte)13)),
        Zp(CodePointSet.generalCategory((byte)14)),
        Zs(CodePointSet.generalCategory((byte)12)),
        White_Space(CodePointSet.codePoints(9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288)),
        Pattern_White_Space(CodePointSet.codePoints(9, 10, 11, 12, 13, 32, 133, 8206, 8207, 8232, 8233)),
        Pattern_Syntax(CodePointSet.union(CodePointSet.range(33, 47), CodePointSet.range(58, 64), CodePointSet.range(91, 94), CodePointSet.codePoints(96), CodePointSet.range(123, 126), CodePointSet.range(161, 167), CodePointSet.codePoints(169, 171, 172, 174, 176, 177, 182, 187, 191, 215, 247), CodePointSet.range(8208, 8231), CodePointSet.range(8240, 8254), CodePointSet.range(8257, 8275), CodePointSet.range(8277, 8286), CodePointSet.range(8592, 9311), CodePointSet.range(9472, 10101), CodePointSet.range(10132, 11263), CodePointSet.range(11776, 11903), CodePointSet.codePoints(12289, 12290, 12291), CodePointSet.range(12296, 12320), CodePointSet.codePoints(12336, 64830, 64831, 65093, 65094))),
        Other_ID_Start(CodePointSet.codePoints(8472, 8494, 12443, 12444)),
        Other_ID_Continue(CodePointSet.codePoints(183, 903, 4969, 4970, 4971, 4972, 4973, 4974, 4975, 4976, 4977, 6618)),
        ID_Start(CodePointSet.union(Unicode.Ll.set, Unicode.Lm.set, Unicode.Lo.set, Unicode.Lt.set, Unicode.Lu.set, Unicode.Nl.set, Unicode.Other_ID_Start.set).except(Unicode.Pattern_Syntax.set).except(Unicode.Pattern_White_Space.set)),
        ID_Continue(CodePointSet.union(Unicode.ID_Start.set, Unicode.Mn.set, Unicode.Mc.set, Unicode.Nd.set, Unicode.Pc.set, Unicode.Other_ID_Continue.set).except(Unicode.Pattern_Syntax.set).except(Unicode.Pattern_White_Space.set));

        final CodePointSet set;
        private static final String[] CONTROL_CHAR_NAMES;

        private Unicode(CodePointSet set) {
            this.set = set;
            set.name = this.name();
        }

        public static Unicode getGeneralCategory(int cp) {
            return Unicode.fromCharacterType(Character.getType(cp));
        }

        public static Unicode fromCharacterType(int type) {
            switch (type) {
                case 0: {
                    return Cn;
                }
                case 1: {
                    return Lu;
                }
                case 2: {
                    return Ll;
                }
                case 3: {
                    return Lt;
                }
                case 4: {
                    return Lm;
                }
                case 5: {
                    return Lo;
                }
                case 6: {
                    return Mn;
                }
                case 7: {
                    return Me;
                }
                case 8: {
                    return Mc;
                }
                case 9: {
                    return Nd;
                }
                case 10: {
                    return Nl;
                }
                case 11: {
                    return No;
                }
                case 12: {
                    return Zs;
                }
                case 13: {
                    return Zl;
                }
                case 14: {
                    return Zp;
                }
                case 15: {
                    return Cc;
                }
                case 16: {
                    return Cf;
                }
                case 18: {
                    return Co;
                }
                case 19: {
                    return Cs;
                }
                case 20: {
                    return Pd;
                }
                case 21: {
                    return Ps;
                }
                case 22: {
                    return Pe;
                }
                case 23: {
                    return Pc;
                }
                case 24: {
                    return Po;
                }
                case 25: {
                    return Sm;
                }
                case 26: {
                    return Sc;
                }
                case 27: {
                    return Sk;
                }
                case 28: {
                    return So;
                }
                case 29: {
                    return Pi;
                }
                case 30: {
                    return Pf;
                }
            }
            throw new IllegalArgumentException("Unknown character type: " + type);
        }

        public static String toSetString(CharacterSet characters) {
            final Output.Readable result = Output.stringBuilder();
            characters.accept(new DefinitionVisitor.NamedSetVisitor<RuntimeException>(){

                @Override
                public ExclusionVisitor<RuntimeException> visitSet(final String base) {
                    return new ExclusionVisitor<RuntimeException>(){
                        boolean inSet;

                        @Override
                        public void excludeRange(int start, int end) {
                            if (end - start == 1) {
                                this.excludeCodePoint(start);
                                this.excludeCodePoint(end);
                            } else {
                                this.init(true);
                                this.append(start);
                                result.append('-');
                                this.append(end);
                            }
                        }

                        @Override
                        public void excludeCodePoint(int cp) {
                            this.init(true);
                            this.append(cp);
                        }

                        @Override
                        public void excludeSet(String name) {
                            this.init(false);
                            result.append('-');
                            this.namedSet(name);
                        }

                        void init(boolean openSet) {
                            if (result.length() == 0) {
                                result.append('[');
                                this.namedSet(base);
                            }
                            if (openSet) {
                                if (!this.inSet) {
                                    result.append("-[");
                                    this.inSet = true;
                                }
                            } else if (this.inSet) {
                                result.append(']');
                                this.inSet = false;
                            }
                        }

                        @Override
                        public void close() {
                            if (result.length() == 0) {
                                this.namedSet(base);
                            } else if (this.inSet) {
                                result.append(']');
                            }
                        }
                    };
                }

                @Override
                public void visitRange(int start, int end) {
                    if (end - start == 1) {
                        this.visitCodePoint(start);
                        this.visitCodePoint(end);
                    } else {
                        this.init();
                        this.append(start);
                        result.append('-');
                        this.append(end);
                    }
                }

                @Override
                public void visitCodePoint(int cp) {
                    this.init();
                    this.append(cp);
                }

                void init() {
                    if (result.length() == 0) {
                        result.append('[');
                    }
                }

                void append(int cp) {
                    result.append(CharacterSet.escapeCodePoint(cp));
                }

                void namedSet(String name) {
                    try {
                        Unicode.valueOf((String)name).set.setName(result);
                    }
                    catch (Exception ignored) {
                        result.append("[:").append(name).append(":");
                    }
                }
            });
            return result.append(']').toString();
        }

        public boolean isSingleCharacter() {
            return this.set.isSingleCharacter();
        }

        static {
            CONTROL_CHAR_NAMES = new String[]{NUL.name(), SOH.name(), STX.name(), ETX.name(), EOT.name(), ENQ.name(), ACK.name(), BEL.name(), BS.name(), TAB.name(), LF.name(), VT.name(), FF.name(), CR.name(), SO.name(), SI.name(), DLE.name(), DC1.name(), DC2.name(), DC3.name(), DC4.name(), NAK.name(), SYN.name(), ETB.name(), CAN.name(), EM.name(), SUB.name(), ESC.name(), FS.name(), GS.name(), RS.name(), US.name()};
        }
    }

    public static interface ExclusionVisitor<EX extends Exception>
    extends AutoCloseable {
        public void excludeCodePoint(int var1) throws EX;

        default public void excludeRange(int start, int end) throws EX {
            for (int cp = start; cp <= end; ++cp) {
                this.excludeCodePoint(cp);
            }
        }

        public void excludeSet(String var1) throws EX;

        @Override
        default public void close() throws EX {
        }
    }

    public static interface DefinitionVisitor<EX extends Exception> {
        default public void visitRange(int start, int end) throws EX {
            for (int cp = start; cp <= end; ++cp) {
                this.visitCodePoint(cp);
            }
        }

        public void visitCodePoint(int var1) throws EX;

        public static interface NamedSetVisitor<EX extends Exception>
        extends DefinitionVisitor<EX> {
            public ExclusionVisitor<EX> visitSet(String var1) throws EX;
        }
    }
}

