/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.g4processors.Normaliser;
import org.opencypher.tools.g4tree.BnfSymbolLiteral;
import org.opencypher.tools.g4tree.BnfSymbols;
import org.opencypher.tools.g4tree.CharacterLiteral;
import org.opencypher.tools.g4tree.ElementWithCardinality;
import org.opencypher.tools.g4tree.ExclusionCharacterSet;
import org.opencypher.tools.g4tree.FreeTextItem;
import org.opencypher.tools.g4tree.GrammarItem;
import org.opencypher.tools.g4tree.GrammarTop;
import org.opencypher.tools.g4tree.InAlternative;
import org.opencypher.tools.g4tree.InAlternatives;
import org.opencypher.tools.g4tree.InLiteral;
import org.opencypher.tools.g4tree.ListedCharacterSet;
import org.opencypher.tools.g4tree.NamedCharacterSet;
import org.opencypher.tools.g4tree.Rule;
import org.opencypher.tools.g4tree.RuleId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrammarConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GrammarConverter.class.getName());
    private final Normaliser normaliser = new Normaliser();
    private final Map<String, Rule> ruleMap;
    private final Set<String> unknownRules = new HashSet<String>();
    private final GrammarTop grammarTop;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("\\s*character\\s*set\\s+'(\\w+)'\\s*");

    public GrammarConverter(GrammarTop grammarTop) {
        this.grammarTop = grammarTop;
        LOGGER.debug("originally \n{}", (Object)grammarTop.getStructure(""));
        this.ruleMap = this.normaliser.normalise(grammarTop);
        LOGGER.debug("normalised \n{}", (Object)grammarTop.getStructure(""));
    }

    public Grammar convert() {
        String language = this.grammarTop.getName();
        Grammar.Builder builder = Grammar.grammar(language, new Grammar.Option[0]);
        String headerText = this.grammarTop.getHeader();
        if (headerText != null) {
            builder.addHeader(headerText.toCharArray(), 0, headerText.length());
        }
        List<Rule> rules = this.grammarTop.getRuleList().getRules();
        for (Rule rule : rules) {
            String ruleName = rule.getRuleName();
            if (rule.getRuleType().keep()) {
                GrammarItem rhs = rule.getRhs();
                Grammar.Term term = this.convertItem(rhs);
                builder.production(ruleName, rule.getDescription(), term, new Grammar.Term[0]);
                if (rhs.getType() != GrammarItem.ItemType.BNF_LITERAL) continue;
                builder.markAsBnfSymbols(ruleName);
                continue;
            }
            LOGGER.debug("suppressing {}", (Object)rule.getStructure(""));
        }
        for (String ruleName : this.unknownRules) {
            String description = "this rule was missing in the input grammar";
            builder.production(ruleName, description, Grammar.literal(ruleName.replaceAll(" ", "_")), new Grammar.Term[0]);
        }
        return builder.build(new Grammar.Builder.Option[0]);
    }

    private Grammar.Term convertItem(GrammarItem item) {
        switch (item.getType()) {
            case ALTERNATIVE: {
                return this.convertAlternative((InAlternative)item);
            }
            case LITERAL: {
                return this.convertLiteral((InLiteral)item);
            }
            case ALTERNATIVES: {
                return this.convertAlternatives((InAlternatives)item);
            }
            case REFERENCE: {
                return this.convertReference((RuleId)item);
            }
            case CARDINALITY: {
                return this.convertWithCardinality((ElementWithCardinality)item);
            }
            case BNF_LITERAL: {
                return this.convertSpecial((BnfSymbolLiteral)item);
            }
            case TEXT: {
                return this.convertText((FreeTextItem)item);
            }
            case NAMEDCHARSET: {
                return this.convertCharSet((NamedCharacterSet)item);
            }
            case LISTEDCHARSET: {
                return this.convertCharSet((ListedCharacterSet)item);
            }
            case EXCLUSIONCHARSET: {
                return this.convertCharSet((ExclusionCharacterSet)item);
            }
            case EOI: {
                return this.convertEOI();
            }
        }
        LOGGER.warn("Don't know how to handle {} that is a {}", (Object)item.getType(), (Object)item.getClass().getSimpleName());
        return Grammar.literal("* itemtype = " + item.getType() + "*");
    }

    private Grammar.Term convertCharSet(NamedCharacterSet item) {
        return Grammar.charactersOfSet(item.getName());
    }

    private Grammar.Term convertCharSet(ListedCharacterSet item) {
        String characters = item.getCharacters();
        LOGGER.debug("We have charset {}.", (Object)characters);
        if (characters.contains("\\u")) {
            LOGGER.warn("We have unicode escapes in {}", (Object)characters);
        }
        return Grammar.charactersOfSet("[" + characters + "]");
    }

    private Grammar.Term convertCharSet(ExclusionCharacterSet item) {
        char[] exclusions = item.getCharacters().toCharArray();
        ArrayList<Integer> cps = new ArrayList<Integer>();
        char lastOne = '\u0000';
        try {
            for (int i = 0; i < exclusions.length; ++i) {
                char ch = exclusions[i];
                if (ch == '\\') {
                    ch = exclusions[++i];
                } else if (ch == '-') {
                    char next;
                    if ((next = exclusions[++i]) == '\\') {
                        next = exclusions[++i];
                    }
                    for (int cp2 = lastOne + '\u0001'; cp2 < next; ++cp2) {
                        cps.add(cp2);
                    }
                    ch = next;
                }
                lastOne = ch;
                cps.add(Integer.valueOf(lastOne));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Bad character set with exceptions : '" + item.getCharacters() + "'");
        }
        return Grammar.charactersOfSet("ANY").except(cps.stream().mapToInt(cp -> cp).toArray());
    }

    private Grammar.Term convertEOI() {
        return Grammar.charactersOfSet("EOI");
    }

    private Grammar.Term convertText(FreeTextItem item) {
        LOGGER.debug("free text {}.", (Object)item.getContent());
        return Grammar.literal("!! " + item.getContent());
    }

    private Grammar.Term convertWithCardinality(ElementWithCardinality item) {
        Grammar.Term child = this.convertItem(item.extractContent());
        if (item.getMin() == 0) {
            if (item.isUnbounded()) {
                return Grammar.zeroOrMore(child, new Grammar.Term[0]);
            }
            return Grammar.optional(child, new Grammar.Term[0]);
        }
        if (item.isUnbounded()) {
            return Grammar.oneOrMore(child, new Grammar.Term[0]);
        }
        return Grammar.sequence(child, new Grammar.Term[0]);
    }

    private Grammar.Term convertAlternative(InAlternative item) {
        List children = item.getChildren();
        if (children.size() == 0) {
            LOGGER.debug("no child items from {}", (Object)item);
            return Grammar.epsilon();
        }
        ArrayList<Grammar.Term> terms = new ArrayList<Grammar.Term>();
        boolean inLiterals = false;
        StringBuilder pending = new StringBuilder();
        block4: for (GrammarItem grammarItem : children) {
            switch (grammarItem.getType()) {
                case CHARACTER_LITERAL: {
                    pending.append(((CharacterLiteral)grammarItem).getValue());
                    inLiterals = true;
                    continue block4;
                }
                case BNF_LITERAL: {
                    pending.append(((BnfSymbolLiteral)grammarItem).getCharacters());
                    inLiterals = true;
                }
            }
            if (inLiterals) {
                terms.add(this.convertItem(new InLiteral(pending.toString())));
                pending = new StringBuilder();
                inLiterals = false;
            }
            terms.add(this.convertItem(grammarItem));
        }
        if (inLiterals) {
            terms.add(this.convertItem(new InLiteral(pending.toString())));
        }
        return Grammar.sequence(this.first(terms), this.getRest(terms));
    }

    private Grammar.Term convertLiteral(InLiteral lit) {
        String value = lit.getValue();
        String[] words = value.split("\\s+");
        if (words.length == 0) {
            return Grammar.literal(value);
        }
        List<Grammar.Term> lits = Stream.of(words).map(w -> Grammar.literal(w)).collect(Collectors.toList());
        return Grammar.sequence((Grammar.Term)lits.get(0), this.getRest(lits));
    }

    private Grammar.Term convertSpecial(BnfSymbolLiteral item) {
        String value = item.getCharacters();
        return Grammar.literal(value);
    }

    private Grammar.Term convertAlternatives(InAlternatives alt) {
        List children = alt.getChildren();
        List<Grammar.Term> terms = children.stream().map(g -> this.convertItem((GrammarItem)g)).collect(Collectors.toList());
        return Grammar.oneOf(this.first(terms), this.getRest(terms));
    }

    private Grammar.Term convertReference(RuleId ref) {
        String ruleName = ref.getName();
        Rule referencedRule = this.ruleMap.get(ruleName);
        if (referencedRule != null) {
            LOGGER.debug("ref to {} which is a {}", (Object)ruleName, (Object)referencedRule.getRuleType());
            switch (referencedRule.getRuleType()) {
                case NORMAL: {
                    return Grammar.nonTerminal(ruleName);
                }
                case KEYWORD: 
                case KEYWORD_LITERAL: {
                    return Grammar.caseInsensitive(ruleName);
                }
                case BNF: {
                    BnfSymbols bnfSymbol = BnfSymbols.getByName(ruleName);
                    return Grammar.literal(bnfSymbol.getActualCharacters());
                }
                case LETTER: {
                    return Grammar.caseInsensitive(ruleName);
                }
                case FRAGMENT: {
                    List<GrammarItem> children = referencedRule.getChildren();
                    LOGGER.debug("consider fragment {} = {}", (Object)ruleName, children);
                    List<Grammar.Term> terms = children.stream().map(g -> this.convertItem((GrammarItem)g)).collect(Collectors.toList());
                    LOGGER.debug("fragment reference becomes {}", terms);
                    if (terms.size() == 1) {
                        return (Grammar.Term)terms.get(0);
                    }
                    return Grammar.sequence(this.first(terms), this.getRest(terms));
                }
            }
        } else {
            LOGGER.warn("Reference to unknown rule {}", (Object)ruleName);
            this.unknownRules.add(ruleName);
            return Grammar.nonTerminal(ruleName);
        }
        LOGGER.warn("No special handling for rulereference {}, type {}", (Object)ruleName, (Object)referencedRule.getRuleType());
        return Grammar.nonTerminal(ruleName);
    }

    protected Grammar.Term first(List<Grammar.Term> list) {
        return list.get(0);
    }

    protected Grammar.Term[] getRest(List<Grammar.Term> list) {
        if (list.size() <= 1) {
            return null;
        }
        List<Grammar.Term> subList = list.subList(1, list.size());
        return subList.toArray(new Grammar.Term[list.size() - 1]);
    }
}

