/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.ScopeRule;
import org.opencypher.grammar.TermTransformation;

public interface Production {
    public String name();

    public String description();

    public Grammar.Term definition();

    public <Scope> Scope scope(Scope var1, ScopeRule.Transformation<Scope> var2);

    public <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> var1, P var2) throws EX;

    public boolean skip();

    public boolean inline();

    public boolean legacy();

    public boolean lexer();

    public boolean bnfsymbols();

    public Collection<NonTerminal> references();

    default public Collection<Production> referencedFrom() {
        return this.references().stream().flatMap(nonTerminal -> {
            Production site = nonTerminal.declaringProduction();
            if (nonTerminal.skip() || site.skip()) {
                return Stream.empty();
            }
            if (site.inline()) {
                return site.referencedFrom().stream();
            }
            return Stream.concat(Stream.of(site), site.references().stream().filter(NonTerminal::inline).map(NonTerminal::declaringProduction));
        }).collect(Collectors.toSet());
    }
}

