/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.awt.Font;
import java.util.Locale;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.railroad.TextGlyphs;
import org.opencypher.tools.io.Output;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SVGShapes
implements ShapeRenderer.Shapes<XMLStreamException> {
    public static final DOMFactory SVG_DOM = new DOMFactory();
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static final String SVG = "svg";
    private static final String G = "g";
    private static final String LINE = "line";
    private static final String RECT = "rect";
    private static final String PATH = "path";
    private static final String TEXT = "text";
    private static final String CIRCLE = "circle";
    private final XMLStreamWriter writer;
    private final Result result;
    private final double width;
    private final double height;

    public static Diagram.CanvasProvider<SVGShapes, XMLStreamException> svgFile(Function<String, Output> output) {
        return (name, width, height) -> new SVGShapes(new StreamResult(((Output)output.apply(name)).writer()), width, height);
    }

    private SVGShapes(Result result, double width, double height) throws XMLStreamException {
        this.result = result;
        this.width = width;
        this.height = height;
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.writer = factory.createXMLStreamWriter(result);
    }

    @Override
    public void begin() throws XMLStreamException {
        this.writer.setDefaultNamespace(SVG_NAMESPACE);
        this.writer.writeStartDocument();
        this.startTag(SVG);
        this.writer.writeNamespace(SVG, SVG_NAMESPACE);
        this.writer.setPrefix(SVG, SVG_NAMESPACE);
        this.writer.writeNamespace("xml", XML_NAMESPACE);
        this.writer.setPrefix("xml", XML_NAMESPACE);
        this.writer.writeNamespace("xlink", XLINK_NAMESPACE);
        this.writer.setPrefix("xlink", XLINK_NAMESPACE);
        this.attribute("width", SVGShapes.format("%.3f", this.width));
        this.attribute("height", SVGShapes.format("%.3f", this.height));
        this.attribute("style", "stroke:black;");
        this.startTag(G);
    }

    @Override
    public void roundRect(ShapeRenderer.Shapes.Style style, double x, double y, double width, double height, double diameter) throws XMLStreamException {
        this.startTag(RECT);
        this.attribute("x", SVGShapes.format("%.3f", x));
        this.attribute("y", SVGShapes.format("%.3f", y));
        this.attribute("width", SVGShapes.format("%.3f", width));
        this.attribute("height", SVGShapes.format("%.3f", height));
        this.attribute("rx", SVGShapes.format("%.3f", diameter / 2.0));
        this.attribute("ry", SVGShapes.format("%.3f", diameter / 2.0));
        this.writeStyle(style);
        this.endTag();
    }

    @Override
    public void rect(ShapeRenderer.Shapes.Style style, double x, double y, double width, double height) throws XMLStreamException {
        this.startTag(RECT);
        this.attribute("x", SVGShapes.format("%.3f", x));
        this.attribute("y", SVGShapes.format("%.3f", y));
        this.attribute("width", SVGShapes.format("%.3f", width));
        this.attribute("height", SVGShapes.format("%.3f", height));
        this.writeStyle(style);
        this.endTag();
    }

    @Override
    public void arc(ShapeRenderer.Shapes.Style style, double cx, double cy, double radius, double start, double extent) throws XMLStreamException {
        if (radius == 0.0) {
            return;
        }
        if (extent >= 360.0 || extent <= -360.0) {
            this.startTag(CIRCLE);
            this.attribute("r", SVGShapes.format("%.3f", radius));
            this.attribute("cx", SVGShapes.format("%.3f", cx));
            this.attribute("cy", SVGShapes.format("%.3f", cy));
            this.writeStyle(style);
            this.endTag();
        } else {
            boolean sweep;
            boolean large;
            double s = Math.toRadians(-start);
            double e = Math.toRadians(-start - extent);
            double sx = cx + Math.cos(s) * radius;
            double sy = cy + Math.sin(s) * radius;
            double ex = cx + Math.cos(e) * radius;
            double ey = cy + Math.sin(e) * radius;
            if (extent > 0.0) {
                large = extent > 180.0;
                sweep = false;
            } else {
                large = extent < -180.0;
                sweep = true;
            }
            try (SVGPath path = this.path(style);){
                path.moveTo(sx, sy);
                path.arc(radius, radius, 0.0, large, sweep, ex, ey);
            }
        }
    }

    @Override
    public void line(ShapeRenderer.Shapes.Style style, double x1, double y1, double x2, double y2) throws XMLStreamException {
        this.startTag(LINE);
        this.attribute("x1", SVGShapes.format("%.3f", x1));
        this.attribute("y1", SVGShapes.format("%.3f", y1));
        this.attribute("x2", SVGShapes.format("%.3f", x2));
        this.attribute("y2", SVGShapes.format("%.3f", y2));
        this.endTag();
    }

    @Override
    public void text(TextGlyphs text, double x, double y) throws XMLStreamException {
        this.startTag(TEXT);
        this.attribute("x", SVGShapes.format("%.3f", Float.valueOf(text.offsetX(x))));
        this.attribute("y", SVGShapes.format("%.3f", Float.valueOf(text.offsetY(y))));
        this.writeStyle(text.getFont());
        this.writer.writeAttribute("xml", XML_NAMESPACE, "space", "preserve");
        this.writer.writeCharacters(text.text());
        this.endTag();
    }

    public SVGPath path(ShapeRenderer.Shapes.Style style) {
        return new SVGPath(style);
    }

    @Override
    public void end() throws XMLStreamException {
        this.endTag();
        this.endTag();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    @Override
    public ShapeRenderer.Shapes.Group<XMLStreamException> group(String link) throws XMLStreamException {
        if (link != null) {
            this.startTag("a");
            this.writer.writeAttribute("xlink", XLINK_NAMESPACE, "href", link);
            this.attribute("target", "_parent");
        } else {
            this.startTag(G);
        }
        return new ShapeRenderer.Shapes.Group<XMLStreamException>(){

            @Override
            public void roundRect(ShapeRenderer.Shapes.Style style, double x, double y, double width, double height, double diameter) throws XMLStreamException {
                SVGShapes.this.roundRect(style, x, y, width, height, diameter);
            }

            @Override
            public void rect(ShapeRenderer.Shapes.Style style, double x, double y, double width, double height) throws XMLStreamException {
                SVGShapes.this.rect(style, x, y, width, height);
            }

            @Override
            public void arc(ShapeRenderer.Shapes.Style style, double cx, double cy, double radius, double start, double extent) throws XMLStreamException {
                SVGShapes.this.arc(style, cx, cy, radius, start, extent);
            }

            @Override
            public void text(TextGlyphs text, double x, double y) throws XMLStreamException {
                SVGShapes.this.text(text, x, y);
            }

            @Override
            public ShapeRenderer.Shapes.Path<XMLStreamException> path(ShapeRenderer.Shapes.Style style) {
                return new SVGPath(style);
            }

            @Override
            public void close() throws XMLStreamException {
                SVGShapes.this.endTag();
            }
        };
    }

    private void writeStyle(Font font) throws XMLStreamException {
        StringBuilder style = new StringBuilder();
        style.append("font-family:").append(font.getName()).append(';');
        style.append(" font-size:").append(font.getSize()).append("px;");
        if (font.isBold()) {
            style.append(" font-weight:bold;");
        } else {
            style.append(" font-weight:normal;");
        }
        if (font.isItalic()) {
            style.append(" font-style:italic;");
        } else {
            style.append(" font-style:normal;");
        }
        style.append(" stroke:none;");
        this.attribute("style", style.toString());
    }

    private void writeStyle(ShapeRenderer.Shapes.Style style) throws XMLStreamException {
        if (style.fill) {
            this.attribute("style", "stroke:none;");
        } else {
            this.attribute("style", "fill:none;");
        }
    }

    private void startTag(String tag) throws XMLStreamException {
        this.writer.writeStartElement(SVG, tag, SVG_NAMESPACE);
    }

    private void attribute(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name, value);
    }

    private void endTag() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    private class SVGPath
    implements ShapeRenderer.Shapes.Path<XMLStreamException> {
        private static final String ARC = "A";
        private static final String CLOSE = "Z";
        private static final String CUBIC_TO = "C";
        private static final String MOVE = "M";
        private static final String LINE_TO = "L";
        private static final String VERTICAL_LINE_TO = "V";
        private static final String HORIZONTAL_LINE_TO = "H";
        private static final String QUAD_TO = "Q";
        private static final String SMOOTH_QUAD_TO = "T";
        private final ShapeRenderer.Shapes.Style style;
        private final StringBuilder path = new StringBuilder();
        double x;
        double y;

        SVGPath(ShapeRenderer.Shapes.Style style) {
            this.style = style;
        }

        @Override
        public void arc(double rx, double ry, double rotation, boolean largeArc, boolean sweep, double x, double y) {
            this.append(ARC);
            this.point(rx, ry);
            this.path.append(' ').append(rotation).append(' ').append(largeArc ? (char)'1' : '0').append(' ').append(sweep ? (char)'1' : '0');
            this.point(x, y);
        }

        @Override
        public void closePath() {
            this.append(CLOSE);
        }

        @Override
        public void moveTo(double x, double y) {
            this.append(MOVE);
            this.point(x, y);
        }

        @Override
        public void lineTo(double x, double y) {
            this.append(LINE_TO);
            this.point(x, y);
        }

        @Override
        public void quadTo(double x1, double y1, double x2, double y2) {
            this.append(QUAD_TO);
            this.point(x1, y1);
            this.point(x2, y2);
        }

        @Override
        public void cubicTo(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.append(CUBIC_TO);
            this.point(x1, y1);
            this.point(x2, y2);
            this.point(x3, y3);
        }

        @Override
        public void close() throws XMLStreamException {
            SVGShapes.this.startTag(SVGShapes.PATH);
            SVGShapes.this.writeStyle(this.style);
            SVGShapes.this.attribute("d", this.path.toString());
            SVGShapes.this.endTag();
        }

        private void append(String command) {
            if (this.path.length() != 0) {
                this.path.append(' ');
            }
            this.path.append(command);
        }

        private void point(double x, double y) {
            this.x = x;
            this.y = y;
            this.path.append(' ');
            this.path.append(x);
            this.path.append(' ');
            this.path.append(y);
        }
    }

    public static final class DOMFactory
    implements Diagram.CanvasProvider<SVGShapes, XMLStreamException>,
    Function<SVGShapes, Document> {
        @Override
        public final Document apply(SVGShapes svg) {
            Node node = ((DOMResult)svg.result).getNode();
            if (node instanceof Document) {
                return (Document)node;
            }
            return node.getOwnerDocument();
        }

        @Override
        public final SVGShapes newCanvas(String name, double width, double height) throws XMLStreamException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                return new SVGShapes(new DOMResult(builder.newDocument()), width, height);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

