/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4tree;

import java.util.Collections;
import java.util.List;
import org.opencypher.tools.g4tree.Element;
import org.opencypher.tools.g4tree.GrammarItem;

public abstract class ElementWithCardinality
implements Element {
    private GrammarItem content;

    public ElementWithCardinality(GrammarItem content) {
        this.content = content;
    }

    @Override
    public GrammarItem.ItemType getType() {
        return GrammarItem.ItemType.CARDINALITY;
    }

    @Override
    public List<GrammarItem> getChildren() {
        return Collections.singletonList(this.content);
    }

    public abstract int getMin();

    public abstract boolean isUnbounded();

    @Override
    public boolean isPlural() {
        return this.content.isPlural();
    }

    @Override
    public boolean isKeywordPart() {
        return this.content.isKeywordPart();
    }

    public String toString() {
        return "[" + this.content.getStructure(" ") + "]";
    }

    protected String getContentStructure(String indent) {
        return this.content.getStructure(indent);
    }

    public GrammarItem extractContent() {
        return this.content;
    }

    @Override
    public GrammarItem reachThrough() {
        return this;
    }
}

