/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opencypher.grammar.Grammar;
import org.opencypher.railroad.Diagram;
import org.opencypher.test.ParameterTest;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.io.Output;

public class DiagramTest
extends ParameterTest<Expectation> {
    @Test
    public static Expectation shouldText() throws Exception {
        return DiagramTest.givenProduction("foo", Grammar.literal((String)"FOO"), new Grammar.Term[0]).expectDiagram("foo", Diagram.text((String)"FOO"));
    }

    @Test
    public static Expectation shouldProduceAnyCase() throws Exception {
        return DiagramTest.givenProduction("bar", Grammar.caseInsensitive((String)"BAR"), new Grammar.Term[0]).expectDiagram("bar", Diagram.anyCase((String)"BAR"));
    }

    @Test
    public static Expectation shouldExpandAnyCase() throws Exception {
        return DiagramTest.givenProduction("baz", Grammar.caseInsensitive((String)"BAZ"), new Grammar.Term[0]).withExpandAnyCase(true).expectDiagram("baz", Diagram.line((Diagram.Figure[])new Diagram.Figure[]{Diagram.branch((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"B"), Diagram.text((String)"b")}), Diagram.branch((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"A"), Diagram.text((String)"a")}), Diagram.branch((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"Z"), Diagram.text((String)"z")})}));
    }

    @Test
    public static Expectation shouldProduceLoopWithSeparator() throws Exception {
        return DiagramTest.given(Grammar.grammar((String)"list", (Grammar.Option[])new Grammar.Option[0]).production("list", Grammar.sequence((Grammar.Term)Grammar.nonTerminal((String)"item"), (Grammar.Term[])new Grammar.Term[]{Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)","), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"item")})}), new Grammar.Term[0]).production("item", Grammar.literal((String)"not interesting"), new Grammar.Term[0])).expectDiagram("list", Diagram.loop((Diagram.Figure)Diagram.reference((String)"item"), (Diagram.Figure)Diagram.text((String)","), (int)0, null));
    }

    @Test
    public static Expectation shouldEliminateRedundantNothing() throws Exception {
        return DiagramTest.givenProduction("bar", Grammar.sequence((Grammar.Term)Grammar.sequence((Grammar.Term)Grammar.oneOf((Grammar.Term)Grammar.sequence((Grammar.Term)Grammar.literal((String)"BAR"), (Grammar.Term[])new Grammar.Term[]{Grammar.epsilon()}), (Grammar.Term[])new Grammar.Term[0]), (Grammar.Term[])new Grammar.Term[]{Grammar.oneOf((Grammar.Term)Grammar.epsilon(), (Grammar.Term[])new Grammar.Term[]{Grammar.epsilon()})}), (Grammar.Term[])new Grammar.Term[0]), new Grammar.Term[0]).expectDiagram("bar", Diagram.text((String)"BAR"));
    }

    @Test
    public static Expectation shouldCombineAlternativeLines() throws Exception {
        return DiagramTest.givenProduction("alts", Grammar.oneOf((Grammar.Term)Grammar.sequence((Grammar.Term)Grammar.literal((String)"kill"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"all"), Grammar.literal((String)"animals")}), (Grammar.Term[])new Grammar.Term[]{Grammar.sequence((Grammar.Term)Grammar.literal((String)"kill"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"no"), Grammar.literal((String)"animals")})}), new Grammar.Term[0]).expectDiagram("alts", Diagram.line((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"kill"), Diagram.branch((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"all"), Diagram.text((String)"no")}), Diagram.text((String)"animals")}));
    }

    @Test
    public static Expectation shouldCombineAlternatives() throws Exception {
        return DiagramTest.givenProduction("alts", Grammar.oneOf((Grammar.Term)Grammar.literal((String)"FOO"), (Grammar.Term[])new Grammar.Term[]{Grammar.sequence((Grammar.Term)Grammar.literal((String)"FOO"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"BAR")})}), new Grammar.Term[0]).expectDiagram("alts", Diagram.line((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"FOO"), Diagram.branch((Diagram.Figure[])new Diagram.Figure[]{Diagram.nothing(), Diagram.text((String)"BAR")})}));
    }

    @Test
    public static Expectation shouldCombineLoopWithPrefix() throws Exception {
        return DiagramTest.givenProduction("loop", Grammar.sequence((Grammar.Term)Grammar.literal((String)"a"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"b"), Grammar.zeroOrMore((Grammar.Term)Grammar.literal((String)","), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"a"), Grammar.literal((String)"b")})}), new Grammar.Term[0]).expectDiagram("loop", Diagram.loop((Diagram.Figure)Diagram.line((Diagram.Figure[])new Diagram.Figure[]{Diagram.text((String)"a"), Diagram.text((String)"b")}), (Diagram.Figure)Diagram.text((String)","), (int)0, null));
    }

    @Override
    protected void run(Expectation expected) {
        List diagrams = Diagram.build((Grammar)expected.given.grammar, (Diagram.BuilderOptions)expected.given);
        Diagram actual = null;
        for (Diagram diagram : diagrams) {
            if (!diagram.name().equals(expected.given.grammar.language())) continue;
            actual = diagram;
            break;
        }
        Assert.assertEquals((Object)expected.diagram, actual);
    }

    private static Given given(Grammar.Builder grammar) {
        return new Given(grammar.build(new Grammar.Builder.Option[0]));
    }

    private static Given givenProduction(String name, Grammar.Term first, Grammar.Term ... alternatives) {
        return new Given(Grammar.grammar((String)name, (Grammar.Option[])new Grammar.Option[0]).production(name, first, alternatives).build(new Grammar.Builder.Option[0]));
    }

    static class Expectation {
        final Given given;
        final Diagram diagram;

        Expectation(Given given, Diagram diagram) {
            this.given = given;
            this.diagram = diagram;
        }

        public String toString() {
            return ((Output)this.given.grammar.transform(this.given.grammar.language(), ISO14977::string, (Object)Output.stringBuilder())).toString();
        }
    }

    private static class Given
    implements Diagram.BuilderOptions {
        private final Grammar grammar;
        private boolean expandAnyCase;

        Given(Grammar grammar) {
            this.grammar = grammar;
        }

        Expectation expectDiagram(String name, Diagram.Figure figure) {
            return new Expectation(this, Diagram.diagram((String)name, (Diagram.Figure)figure));
        }

        Given withExpandAnyCase(boolean expandAnyCase) {
            this.expandAnyCase = expandAnyCase;
            return this;
        }

        public boolean expandAnyCase() {
            return this.expandAnyCase;
        }
    }
}

