/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

@RunWith(value=Runner.class)
public abstract class ParameterTest<PARAMETER> {
    protected abstract void run(PARAMETER var1) throws Throwable;

    private static class Invoker<P>
    extends Statement {
        private final ParameterTest<P> test;
        private final P parameter;

        Invoker(ParameterTest<P> test, P parameter) {
            this.test = test;
            this.parameter = parameter;
        }

        public void evaluate() throws Throwable {
            this.test.run(this.parameter);
        }
    }

    private static class Single
    extends ParentRunner<Object> {
        private final Object parameter;
        private final FrameworkMethod method;
        private final Description description;

        private Single(Class<?> testClass, FrameworkMethod method) throws Throwable {
            super(testClass);
            this.method = method;
            this.parameter = method.invokeExplosively(null, new Object[0]);
            this.description = Description.createTestDescription(testClass, (String)method.getName(), (Annotation[])method.getAnnotations());
        }

        protected String getName() {
            return "[" + this.parameter + "]";
        }

        protected List<Object> getChildren() {
            return Collections.singletonList(this.parameter);
        }

        protected Description describeChild(Object child) {
            return this.description;
        }

        protected void runChild(Object child, RunNotifier notifier) {
            if (this.method.getAnnotation(Ignore.class) != null) {
                notifier.fireTestIgnored(this.description);
            } else {
                this.runLeaf(this.statement(), this.description, notifier);
            }
        }

        private Statement statement() {
            ParameterTest test;
            try {
                test = (ParameterTest)this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                return new Fail(e.getTargetException());
            }
            catch (Throwable e) {
                return new Fail(e);
            }
            Statement statement = new Invoker(test, this.parameter);
            statement = this.possiblyExpectingExceptions(this.method, statement);
            statement = this.withBefores(test, statement);
            statement = this.withAfters(test, statement);
            statement = this.withTestRules(this.method, this.getTestRules(test), statement);
            return statement;
        }

        private Statement withBefores(Object target, Statement statement) {
            List befores = this.getTestClass().getAnnotatedMethods(Before.class);
            return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
        }

        private Statement withAfters(Object target, Statement statement) {
            List afters = this.getTestClass().getAnnotatedMethods(After.class);
            return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
        }

        private List<TestRule> getTestRules(Object target) {
            List result = this.getTestClass().getAnnotatedMethodValues(target, Rule.class, TestRule.class);
            result.addAll(this.getTestClass().getAnnotatedFieldValues(target, Rule.class, TestRule.class));
            return result;
        }

        private Statement withTestRules(FrameworkMethod method, List<TestRule> testRules, Statement statement) {
            return testRules.isEmpty() ? statement : new RunRules(statement, testRules, this.describeChild(method));
        }

        private Statement possiblyExpectingExceptions(FrameworkMethod method, Statement next) {
            Test annotation = (Test)method.getAnnotation(Test.class);
            return Single.getExpectedException(annotation) != null ? new ExpectException(next, Single.getExpectedException(annotation)) : next;
        }

        private static Class<? extends Throwable> getExpectedException(Test annotation) {
            if (annotation == null || annotation.expected() == Test.None.class) {
                return null;
            }
            return annotation.expected();
        }
    }

    public static class Runner
    extends Suite {
        private List<org.junit.runner.Runner> runners;

        public Runner(Class<?> klass) throws Throwable {
            super(klass, Collections.emptyList());
            List parameters = this.getTestClass().getAnnotatedMethods(Test.class);
            ArrayList<IllegalStateException> errors = null;
            for (FrameworkMethod parameter : parameters) {
                if (parameter.isPublic() && parameter.isStatic()) continue;
                if (errors == null) {
                    errors = new ArrayList<IllegalStateException>();
                }
                errors.add(new IllegalStateException("@Test method " + parameter.getName() + " should be public and static"));
            }
            if (errors != null) {
                throw new InitializationError(errors);
            }
            this.runners = this.createRunners(parameters);
        }

        private List<org.junit.runner.Runner> createRunners(List<FrameworkMethod> parameters) throws Throwable {
            ArrayList<org.junit.runner.Runner> runners = new ArrayList<org.junit.runner.Runner>(parameters.size());
            for (FrameworkMethod parameter : parameters) {
                runners.add((org.junit.runner.Runner)new Single(this.getTestClass().getJavaClass(), parameter));
            }
            return runners;
        }

        protected List<org.junit.runner.Runner> getChildren() {
            return this.runners;
        }
    }
}

