/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.g4processors.BNFProcessor;
import org.opencypher.tools.g4processors.G4Processor;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.grammar.Xml;
import org.opencypher.tools.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class G4ProcessorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)G4ProcessorTest.class.getName());
    private static final Pattern XMLANG_PATTERN = Pattern.compile("name=(?:'|\")(\\w+)(?:'|\\\")");

    @Before
    public void initialize() {
        Antlr4.setPrefix((String)"");
    }

    @After
    public void cleanup() {
        Antlr4.resetPrefix();
    }

    @Test
    public void oneProduction() {
        this.roundTripBNFG4("<alpha> ::= ALPHA");
    }

    @Test
    public void twoProductions() {
        this.roundTripBNFG4("<alpha> ::= ALPHA <beta>", "", "<beta> ::= BETA");
    }

    @Test
    public void twoLiterals() {
        this.roundTripBNFG4("<alphabeta> ::= ALPHA BETA");
    }

    @Test
    public void alternatives() {
        this.roundTripBNFG4("<choice> ::= ALPHA | BETA");
    }

    @Test
    public void alternativesAgain() {
        this.roundTripBNFG4("<choice> ::= ALPHA ", "     | BETA");
    }

    @Test
    public void reference() {
        this.roundTripBNFG4("<one> ::=  <beta>", "", "<beta> ::= BETA");
    }

    @Test
    public void repeatGroup() {
        this.roundTripBNFG4("<some> ::=  { ALPHA <beta> } ...", "", "<beta> ::= BETA");
    }

    @Test
    public void repeatOptionalGroup() {
        this.roundTripBNFG4("<some> ::=  [ ALPHA <beta> ] ...", "", "<beta> ::= BETA");
    }

    @Test
    public void optional() {
        this.roundTripBNFG4("<perhaps> ::=  [ <beta> ]", "", "<beta> ::= BETA");
    }

    @Test
    public void verticalBar() {
        this.roundTripBNFG4("<verticalBar> ::= |");
    }

    @Test
    public void keyword() {
        this.roundTripBNFG4("<something> ::= <STOP>", "", "<STOP> ::= <S> <T> <O> <P>", "", "<O> ::= O | o", "", "<P> ::= P | p", "", "<S> ::= S | s", "", "<T> ::= T | t");
    }

    @Test
    public void unicode() {
        this.roundTripBNFG4("<whitespace> ::= SPACE | TAB | LF | 0x1680 | 0x180e | 0x2000 | 0x2001");
    }

    @Test
    public void bnfProduction() {
        this.roundTripBNFG4("<prodassign> ::= ::=");
    }

    @Test
    public void bnfSymbolsProduction() {
        this.roundTripBNFG4("<notequal> ::= <>");
    }

    @Test
    public void commaProduction() {
        this.roundTripBNFG4("<comma> ::= ,");
    }

    @Test
    public void punctuation() {
        this.roundTripBNFG4("<puncs> ::= +.-");
    }

    @Test
    public void commasProduction() {
        this.roundTripBNFG4("<list> ::= ONE <comma> TWO <comma> THREE", "", "<comma> ::= ,");
    }

    @Test
    public void charsetG4() {
        this.roundTripG4("grammar four;", "", "four : FOUR_0 ;", "", "fragment FOUR_0 : [abcd] ;");
    }

    @Test
    public void charsetList() {
        this.roundTripG4(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"[abcd]"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetSimpleName() {
        this.roundTripG4(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"TAB"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void negCharset() {
        this.roundTripG4(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"ANY").except(new int[]{97, 98, 99}), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetSpecialName() {
        this.roundTripG4(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"ID_Start"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetExceptBackslash() {
        this.roundTripG4(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"ANY").except(new int[]{34, 92}), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetChoiceBNF() {
        this.roundTripBNFG4("<anychars> ::= $ID_Start$ | $Pc$");
    }

    @Test
    public void unionFromXml() {
        String production = "  <production name=\"Union\">\n    <alt>\n      <seq>\n        <literal value=\"UNION\" case-sensitive=\"false\"/>\n        <literal value=\"ALL\" case-sensitive=\"false\"/>\n      </seq>\n        <literal value=\"UNION\" case-sensitive=\"false\"/>\n    </alt>\n  </production>";
        Grammar prodGrammar = this.xmlin(production);
        this.roundTripG4(prodGrammar);
    }

    @Test
    public void shouldRecycleFewRules() throws Exception {
        Grammar grammarFromXml = Fixture.grammarResource(G4Processor.class, "/FewRules.xml", new Grammar.ParserOption[0]);
        String firstG4 = this.makeAntlr4(grammarFromXml);
        LOGGER.debug("Generated G4\n{}", (Object)firstG4);
        G4Processor g4processor = new G4Processor();
        Grammar grammarFromG4 = g4processor.processString(firstG4);
        String intermediateG4 = this.makeAntlr4(grammarFromG4);
        LOGGER.debug("Regenerated G4\n{}", (Object)intermediateG4);
        Grammar grammarFromSecondGenG4 = g4processor.processString(intermediateG4);
        String finalG4 = this.makeAntlr4(grammarFromG4);
        Assert.assertEquals((Object)intermediateG4, (Object)finalG4);
    }

    @Test
    public void shouldRecycleCypher() throws Exception {
        Grammar grammarFromXml = Fixture.grammarResource(G4Processor.class, "/cypher.xml", new Grammar.ParserOption[0]);
        String firstG4 = this.makeAntlr4(grammarFromXml);
        LOGGER.debug("Generated G4\n{}", (Object)firstG4);
        G4Processor g4processor = new G4Processor();
        Grammar grammarFromG4 = g4processor.processString(firstG4);
        String intermediateG4 = this.makeAntlr4(grammarFromG4);
        LOGGER.debug("Regenerated G4\n{}", (Object)intermediateG4);
        Grammar grammarFromSecondGenG4 = g4processor.processString(intermediateG4);
        String finalG4 = this.makeAntlr4(grammarFromG4);
        Assert.assertEquals((Object)intermediateG4, (Object)finalG4);
    }

    private void roundTripBNFG4(String ... bnf) {
        String inG4 = Output.lines((String[])bnf).trim();
        BNFProcessor bnfProcessor = new BNFProcessor();
        Grammar bnfGrammar = bnfProcessor.processString(inG4);
        this.roundTripG4(bnfGrammar);
    }

    private void roundTripG4(Grammar testGrammar) {
        String firstG4 = this.makeAntlr4(testGrammar);
        LOGGER.debug("generated G4\n{}", (Object)firstG4);
        G4Processor processor = new G4Processor();
        Grammar grammar = processor.processString(firstG4);
        String outputG4 = this.makeAntlr4(grammar);
        LOGGER.debug("second g4\n{}", (Object)outputG4);
        Assert.assertEquals((Object)this.unPretty(firstG4), (Object)this.unPretty(outputG4));
    }

    private void roundTripG4(String ... inputG4) {
        String inG4 = Output.lines((String[])inputG4).trim();
        G4Processor processor = new G4Processor();
        LOGGER.debug("in {}", (Object)inG4);
        Grammar grammar = processor.processString(Output.lines((String[])inputG4));
        String outputG4 = this.makeAntlr4(grammar);
        LOGGER.debug("out {}", (Object)outputG4);
        Assert.assertEquals((Object)this.unPretty(inG4), (Object)this.unPretty(outputG4));
    }

    private String xmlout(Grammar testGrammar) {
        Output.Readable out = Output.stringBuilder();
        try {
            Xml.write((Grammar)testGrammar, (Output)out);
            return out.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed to create xml", e);
        }
    }

    private Grammar xmlin(String productions) {
        Matcher m = XMLANG_PATTERN.matcher(productions);
        if (m.find()) {
            String language = m.group(1);
            StringBuilder xb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<grammar language=\"").append(language).append("\" xmlns=\"http://opencypher.org/grammar\">\n").append(productions).append("\n</grammar>");
            String xmlString = xb.toString();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes(Charset.forName("UTF-8")));
            try {
                return Grammar.parseXML((InputStream)inputStream, (Grammar.ParserOption[])new Grammar.ParserOption[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse xml\n" + xmlString, e);
            }
        }
        throw new IllegalArgumentException("Cannot find first production name in " + productions);
    }

    private String makeAntlr4(Grammar grammar) {
        StringWriter writer = new StringWriter();
        Antlr4.write((Grammar)grammar, (Writer)writer);
        String outputG4 = writer.toString().trim();
        return outputG4;
    }

    private String unPretty(String original) {
        String nl = System.lineSeparator();
        return original.replaceAll(nl + nl, "#!#").replaceAll("\\s+", " ").replaceAll("#!#", nl + nl);
    }
}

