/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opencypher.grammar.ProductionNode;

class Dependencies {
    private Map<String, Set<ProductionNode>> missingProductions;
    private final Map<String, Set<ProductionNode>> dependencies = new LinkedHashMap<String, Set<ProductionNode>>();

    Dependencies() {
    }

    public void missingProduction(String name, ProductionNode origin) {
        if (this.missingProductions == null) {
            this.missingProductions = new LinkedHashMap<String, Set<ProductionNode>>();
        }
        Dependencies.update(this.missingProductions, name, origin);
    }

    public void usedFrom(String name, ProductionNode origin) {
        Dependencies.update(this.dependencies, name, origin);
    }

    private static void update(Map<String, Set<ProductionNode>> productions, String name, ProductionNode origin) {
        Set<ProductionNode> origins = productions.get(name);
        if (origins == null) {
            origins = Collections.newSetFromMap(new LinkedHashMap());
            productions.put(name, origins);
        }
        origins.add(origin);
    }

    public void reportMissingProductions() {
        if (this.missingProductions != null && !this.missingProductions.isEmpty()) {
            StringBuilder message = new StringBuilder().append("Productions used in non-terminals have not been defined:");
            for (Map.Entry<String, Set<ProductionNode>> entry : this.missingProductions.entrySet()) {
                message.append("\n  '").append(entry.getKey()).append("'");
                String sep = " used from: ";
                for (ProductionNode origin : entry.getValue()) {
                    message.append(sep);
                    if (origin.name == null) {
                        message.append("The root of the '").append(origin.vocabulary).append("' grammar");
                    } else {
                        message.append('\'').append(origin.name).append("' in '").append(origin.vocabulary).append('\'');
                    }
                    sep = ", ";
                }
            }
            throw new IllegalArgumentException(message.toString());
        }
    }

    public void invalidCharacterSet(String name, ProductionNode origin) {
        throw new IllegalArgumentException("Invalid character set: '" + name + "', a production exists with that name.");
    }
}

