/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.AlternativesNode;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.CharacterSetNode;
import org.opencypher.grammar.Container;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.LiteralNode;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.NonTerminalNode;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.OptionalNode;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.grammar.ProtoGrammar;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.RepetitionNode;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.SequenceNode;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Element;
import org.opencypher.tools.xml.XmlFile;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.SAXException;

@Element(uri="http://opencypher.org/grammar/annotation", name="GrammarAnnotation")
class GrammarAnnotation
extends ProtoGrammar {
    static final XmlParser<GrammarAnnotation> XML = XmlParser.xmlParser(GrammarAnnotation.class);
    private ProtoGrammar grammar;
    private String name;

    GrammarAnnotation() {
    }

    @Attribute
    void grammar(XmlFile grammar) throws ParserConfigurationException, SAXException, IOException {
        this.grammar = GrammarAnnotation.parse(grammar);
        if (this.name != null) {
            this.grammar.setName(this.name);
        }
    }

    @Attribute(optional=true)
    void name(String name) {
        if (this.grammar != null) {
            this.grammar.setName(name);
        } else {
            this.name = name;
        }
    }

    @Override
    String language() {
        return this.grammar.language();
    }

    @Override
    ProductionNode production(String name) {
        return this.grammar.production(name);
    }

    @Override
    void setName(String name) {
        this.grammar.setName(name);
    }

    @Override
    Grammar resolve(Grammar.Resolver resolver, Set<ProtoGrammar.ResolutionOption> options) {
        return this.grammar.resolve(resolver, options);
    }

    @Override
    @Child(value={SkipProduction.class, InlineProduction.class, SkipReference.class, InlineReference.class, NonTerminalTitle.class, Replace.class, Remove.class, Recursively.class, MarkAndSweep.class})
    void apply(ProtoGrammar.Patch patch) {
        this.grammar.apply(patch);
    }

    @Override
    @Child
    void add(ProductionNode production) {
        this.grammar.add(production);
    }

    static abstract class TransitivePatch
    extends ProtoGrammar.Patch {
        TransitivePatch() {
        }

        final Set<String> applyTransitive(String start, ProtoGrammar.Mutator mutator) {
            String production;
            LinkedList<String> queue = new LinkedList<String>();
            queue.add(start);
            Transformation transformation = new Transformation();
            while (null != (production = (String)queue.poll())) {
                if (transformation.done(production)) continue;
                transformation.transform(mutator, production, queue);
            }
            return transformation.done;
        }

        abstract void applyTo(ProductionNode var1);

        private final class Transformation
        implements ProductionTransformation<Queue<String>, ProductionNode, RuntimeException>,
        TermTransformation<Queue<String>, Void, RuntimeException> {
            final Set<String> done = new HashSet<String>();

            private Transformation() {
            }

            boolean done(String production) {
                return this.done.contains(production);
            }

            void transform(ProtoGrammar.Mutator mutator, String production, Queue<String> queue) {
                mutator.replaceProduction(production, this, queue);
            }

            @Override
            public ProductionNode transformProduction(Queue<String> queue, Production production) throws RuntimeException {
                ProductionNode node = (ProductionNode)production;
                this.done.add(node.name);
                TransitivePatch.this.applyTo(node);
                production.definition().transform(this, queue);
                return node;
            }

            @Override
            public Void transformNonTerminal(Queue<String> queue, NonTerminal nonTerminal) throws RuntimeException {
                String name = ((NonTerminalNode)nonTerminal).ref;
                if (!this.done(name)) {
                    queue.add(name);
                }
                return null;
            }

            @Override
            public Void transformAlternatives(Queue<String> queue, Alternatives alternatives) throws RuntimeException {
                for (Grammar.Term term : alternatives) {
                    term.transform(this, queue);
                }
                return null;
            }

            @Override
            public Void transformSequence(Queue<String> queue, Sequence sequence) throws RuntimeException {
                for (Grammar.Term term : sequence) {
                    term.transform(this, queue);
                }
                return null;
            }

            @Override
            public Void transformOptional(Queue<String> queue, Optional optional) throws RuntimeException {
                optional.term().transform(this, queue);
                return null;
            }

            @Override
            public Void transformRepetition(Queue<String> queue, Repetition repetition) throws RuntimeException {
                repetition.term().transform(this, queue);
                return null;
            }

            @Override
            public Void transformLiteral(Queue<String> param, Literal literal) throws RuntimeException {
                return null;
            }

            @Override
            public Void transformCharacters(Queue<String> queue, CharacterSet characters) throws RuntimeException {
                return null;
            }

            @Override
            public Void transformEpsilon(Queue<String> queue) throws RuntimeException {
                return null;
            }
        }
    }

    static abstract class SingleProductionPatch
    extends ProtoGrammar.Patch
    implements ProductionTransformation<Void, ProductionNode, RuntimeException>,
    TermTransformation<Void, Node, RuntimeException> {
        @Attribute
        String production;

        SingleProductionPatch() {
        }

        @Override
        void apply(ProtoGrammar.Mutator mutator) {
            mutator.replaceProduction(this.production, this, null);
        }

        @Override
        public final ProductionNode transformProduction(Void param, Production production) throws RuntimeException {
            if (production instanceof ProductionNode) {
                ProductionNode node = (ProductionNode)production;
                return this.production(node);
            }
            throw new IllegalStateException("Cannot handle productions of type " + production.getClass());
        }

        ProductionNode production(ProductionNode production) {
            Node definition = production.transform(this, null);
            if (definition != production.definition) {
                return production.replace(definition);
            }
            return production;
        }

        @Override
        public final Node transformAlternatives(Void param, Alternatives alternatives) throws RuntimeException {
            if (alternatives instanceof AlternativesNode) {
                AlternativesNode node = (AlternativesNode)alternatives;
                return this.alternatives(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + alternatives.getClass());
        }

        Node alternatives(AlternativesNode alternatives) {
            List<Node> terms = this.transformCollection(alternatives);
            if (terms != null) {
                AlternativesNode replacement = new AlternativesNode();
                replacement.nodes.addAll(terms);
                return replacement;
            }
            return alternatives;
        }

        @Override
        public final Node transformSequence(Void param, Sequence sequence) throws RuntimeException {
            if (sequence instanceof SequenceNode) {
                SequenceNode node = (SequenceNode)sequence;
                return this.sequence(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + sequence.getClass());
        }

        Node sequence(SequenceNode sequence) {
            List<Node> terms = this.transformCollection(sequence);
            if (terms != null) {
                SequenceNode replacement = new SequenceNode();
                replacement.nodes.addAll(terms);
                return replacement;
            }
            return sequence;
        }

        private List<Node> transformCollection(Container container) {
            ArrayList<Node> terms = null;
            int term = 0;
            for (Grammar.Term contents : container) {
                Node replacement = contents.transform(this, null);
                if (replacement != contents && terms == null) {
                    terms = new ArrayList<Node>(container.terms());
                    for (int i = 0; i < term; ++i) {
                        terms.add(container.nodes.get(i));
                    }
                }
                if (terms != null) {
                    if (replacement == null) continue;
                    terms.add(replacement);
                    continue;
                }
                ++term;
            }
            return terms;
        }

        @Override
        public final Node transformLiteral(Void param, Literal literal) throws RuntimeException {
            if (literal instanceof LiteralNode) {
                LiteralNode node = (LiteralNode)literal;
                return this.literal(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + literal.getClass());
        }

        Node literal(LiteralNode literal) {
            return literal;
        }

        @Override
        public final Node transformNonTerminal(Void param, NonTerminal nonTerminal) throws RuntimeException {
            if (nonTerminal instanceof NonTerminalNode) {
                NonTerminalNode node = (NonTerminalNode)nonTerminal;
                return this.nonTerminal(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + nonTerminal.getClass());
        }

        Node nonTerminal(NonTerminalNode nonTerminal) {
            return nonTerminal;
        }

        @Override
        public final Node transformOptional(Void param, Optional optional) throws RuntimeException {
            if (optional instanceof OptionalNode) {
                OptionalNode node = (OptionalNode)optional;
                return this.optional(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + optional.getClass());
        }

        Node optional(OptionalNode optional) {
            return optional.replaceTerm(optional.term().transform(this, null));
        }

        @Override
        public final Node transformRepetition(Void param, Repetition repetition) throws RuntimeException {
            if (repetition instanceof RepetitionNode) {
                RepetitionNode node = (RepetitionNode)repetition;
                return this.repetition(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + repetition.getClass());
        }

        Node repetition(RepetitionNode repetition) {
            return repetition.replaceTerm(repetition.term().transform(this, null));
        }

        @Override
        public final Node transformEpsilon(Void param) throws RuntimeException {
            return this.epsilon();
        }

        Node epsilon() {
            return Node.epsilon();
        }

        @Override
        public final Node transformCharacters(Void param, CharacterSet characters) throws RuntimeException {
            if (characters instanceof CharacterSetNode) {
                CharacterSetNode node = (CharacterSetNode)characters;
                return this.characterSet(node);
            }
            throw new IllegalStateException("Cannot handle nodes of of type " + characters.getClass());
        }

        Node characterSet(CharacterSetNode characterSet) {
            return characterSet;
        }
    }

    @Element(uri="http://opencypher.org/railroad", name="nonTerminalTitle")
    static class NonTerminalTitle
    extends SingleProductionPatch {
        @Attribute
        String ref;
        @Attribute
        String title;

        NonTerminalTitle() {
        }

        @Override
        Node nonTerminal(NonTerminalNode nonTerminal) {
            if (this.ref.equals(nonTerminal.ref)) {
                nonTerminal.title = this.title;
            }
            return nonTerminal;
        }
    }

    @Element(uri="http://opencypher.org/railroad", name="inlineNonTerminal")
    static class InlineReference
    extends SingleProductionPatch {
        @Attribute
        String ref;

        InlineReference() {
        }

        @Override
        Node nonTerminal(NonTerminalNode nonTerminal) {
            if (this.ref.equals(nonTerminal.ref)) {
                nonTerminal.inline = true;
            }
            return nonTerminal;
        }
    }

    @Element(uri="http://opencypher.org/railroad", name="skipNonTerminal")
    static class SkipReference
    extends SingleProductionPatch {
        @Attribute
        String ref;

        SkipReference() {
        }

        @Override
        Node nonTerminal(NonTerminalNode nonTerminal) {
            if (this.ref.equals(nonTerminal.ref)) {
                nonTerminal.skip = true;
            }
            return nonTerminal;
        }
    }

    @Element(uri="http://opencypher.org/railroad", name="inline")
    static class InlineProduction
    extends SingleProductionPatch {
        InlineProduction() {
        }

        @Override
        ProductionNode production(ProductionNode production) {
            production.inline = true;
            return production;
        }
    }

    @Element(uri="http://opencypher.org/railroad", name="skip")
    static class SkipProduction
    extends SingleProductionPatch {
        SkipProduction() {
        }

        @Override
        ProductionNode production(ProductionNode production) {
            production.skip = true;
            return production;
        }
    }

    @Element(uri="http://opencypher.org/grammar/annotation", name="mark-and-sweep")
    static class MarkAndSweep
    extends TransitivePatch {
        @Attribute
        String root;

        MarkAndSweep() {
        }

        @Override
        void apply(ProtoGrammar.Mutator mutator) {
            Set<String> mark = this.applyTransitive(this.root, mutator);
            for (String production : mutator.productions()) {
                if (mark.contains(production)) continue;
                mutator.removeProduction(production);
            }
        }

        @Override
        void applyTo(ProductionNode production) {
        }
    }

    @Element(uri="http://opencypher.org/grammar/annotation", name="recursively")
    static class Recursively
    extends TransitivePatch {
        @Attribute
        String from;
        @Attribute(uri="http://opencypher.org/opencypher", optional=true)
        Boolean lexer;
        @Attribute(uri="http://opencypher.org/railroad", optional=true)
        Boolean skip;
        @Attribute(uri="http://opencypher.org/railroad", optional=true)
        Boolean inline;

        Recursively() {
        }

        @Override
        void apply(ProtoGrammar.Mutator mutator) {
            this.applyTransitive(this.from, mutator);
        }

        @Override
        void applyTo(ProductionNode production) {
            if (this.lexer != null) {
                production.lexer = this.lexer;
            }
            if (this.skip != null) {
                production.skip = this.skip;
            }
            if (this.inline != null) {
                production.inline = this.inline;
            }
        }
    }

    @Element(uri="http://opencypher.org/grammar/annotation", name="remove")
    static class Remove
    extends ProtoGrammar.Patch {
        @Attribute
        String production;

        Remove() {
        }

        @Override
        void apply(ProtoGrammar.Mutator mutator) {
            mutator.removeProduction(this.production);
        }
    }

    @Element(uri="http://opencypher.org/grammar/annotation", name="replace")
    static class Replace
    extends ProtoGrammar.Patch {
        final List<ProductionNode> productions = new ArrayList<ProductionNode>();
        final ProtoGrammar grammar;

        Replace(GrammarAnnotation parent) {
            this.grammar = parent.grammar;
        }

        @Override
        void apply(ProtoGrammar.Mutator mutator) {
            for (ProductionNode production : this.productions) {
                mutator.replaceProduction(production.name, (replacement, current) -> replacement, production);
            }
        }

        @Child
        void add(ProductionNode production) {
            this.productions.add(production);
        }
    }
}

