/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opencypher.tools.g4tree.BnfSymbols;
import org.opencypher.tools.g4tree.GrammarItem;
import org.opencypher.tools.g4tree.GrammarTop;
import org.opencypher.tools.g4tree.InLiteral;
import org.opencypher.tools.g4tree.Rule;
import org.opencypher.tools.g4tree.RuleId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Normaliser {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Normaliser.class.getName());

    public Map<String, Rule> normalise(GrammarTop top) {
        List<Rule> rules = top.getRuleList().getRules();
        this.markLetterRules(rules);
        this.markBnfRules(rules);
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        for (Rule rule : rules) {
            if (ruleMap.put(rule.getRuleName(), rule) == null) continue;
            LOGGER.warn("duplicate rule {}", (Object)rule.getRuleName());
        }
        this.markKeywordLiteralRulesSeparateAlphabet(rules, ruleMap);
        this.markKeywordRules(rules, ruleMap);
        this.markKeywordRulesAlternativesOfCase(rules, ruleMap);
        return ruleMap;
    }

    private void markKeywordRules(List<Rule> rules, Map<String, Rule> ruleMap) {
        for (Rule rule : rules) {
            String refName;
            GrammarItem ref;
            List<GrammarItem> refs;
            List<GrammarItem> alts;
            GrammarItem rhs;
            String ruleName = rule.getRuleName();
            if (!ruleName.matches("[a-z]+") || (rhs = rule.getRhs()).getType() != GrammarItem.ItemType.ALTERNATIVES || (alts = rhs.getChildren()).size() != 1 || (refs = alts.get(0).getChildren()).size() != 1 || (ref = refs.get(0)).getType() != GrammarItem.ItemType.REFERENCE || !(refName = ((RuleId)ref).getName()).equals(ruleName.toUpperCase()) || !ruleMap.containsKey(refName) || ruleMap.get(refName).getRuleType() != Rule.RuleType.KEYWORD_LITERAL) continue;
            LOGGER.debug("Rule {} is a keyword rule", (Object)ruleName);
            rule.setRuleType(Rule.RuleType.KEYWORD);
        }
    }

    private void markKeywordLiteralRulesSeparateAlphabet(List<Rule> rules, Map<String, Rule> ruleMap) {
        for (Rule rule : rules) {
            List letters;
            List<GrammarItem> refs;
            List<GrammarItem> alts;
            GrammarItem rhs;
            String ruleName = rule.getRuleName();
            if (!ruleName.matches("[A-Z]+") || (rhs = rule.getRhs()).getType() != GrammarItem.ItemType.ALTERNATIVES || (alts = rhs.getChildren()).size() != 1 || (refs = alts.get(0).getChildren()).size() != ruleName.length() || !refs.stream().allMatch(r -> r.getType() == GrammarItem.ItemType.REFERENCE && this.ruleNameIsInsensitiveLetter(((RuleId)r).getName())) || !(letters = refs.stream().map(r -> ((RuleId)r).getName()).collect(Collectors.toList())).stream().allMatch(l -> ruleMap.containsKey(l) && ((Rule)ruleMap.get(l)).getRuleType() == Rule.RuleType.LETTER) || !ruleName.equals(letters.stream().collect(Collectors.joining("")))) continue;
            LOGGER.debug("Rule {} is a keyword literal rule", (Object)ruleName);
            rule.setRuleType(Rule.RuleType.KEYWORD_LITERAL);
        }
    }

    private boolean ruleNameIsInsensitiveLetter(String ruleName) {
        return ruleName.length() == 1 || ruleName.substring(1).equals(" case insensitive");
    }

    private void markKeywordRulesAlternativesOfCase(List<Rule> rules, Map<String, Rule> ruleMap) {
        for (Rule rule : rules) {
            List<GrammarItem> groups;
            List<GrammarItem> topAlts;
            String ruleName = rule.getRuleName();
            if (!ruleName.matches("[A-Z]+")) continue;
            LOGGER.debug("rule \n{}", (Object)rule.getStructure(""));
            GrammarItem rhs = rule.getRhs();
            if (rhs.getType() != GrammarItem.ItemType.ALTERNATIVES || (topAlts = rhs.getChildren()).size() != 1 || (groups = topAlts.get(0).getChildren()).size() != ruleName.length()) continue;
            String[] letters = ruleName.split("");
            int i = 0;
            boolean goodSoFar = true;
            for (GrammarItem group : groups) {
                List<GrammarItem> groupContent = group.getChildren();
                if (groupContent.size() != 1) continue;
                List<GrammarItem> alts = groupContent.get(0).getChildren();
                if (alts.size() == 2) {
                    boolean lower = false;
                    boolean upper = false;
                    for (GrammarItem alt : alts) {
                        String letter;
                        if (alt.getType() != GrammarItem.ItemType.ALTERNATIVE || alt.getChildren().size() != 1 || alt.getChildren().get(0).getType() != GrammarItem.ItemType.LITERAL || (letter = ((InLiteral)alt.getChildren().get(0)).getValue()).length() != 1) continue;
                        if (letter.equals(letters[i])) {
                            upper = true;
                            continue;
                        }
                        if (!letter.toUpperCase().equals(letters[i])) continue;
                        lower = true;
                    }
                    goodSoFar = goodSoFar & upper & lower;
                }
                ++i;
            }
            if (!goodSoFar) continue;
            rule.setRuleType(Rule.RuleType.KEYWORD);
        }
    }

    private void markLetterRules(List<Rule> rules) {
        for (Rule rule : rules) {
            List<GrammarItem> alts;
            GrammarItem rhs;
            String ruleName = rule.getRuleName();
            if (!ruleName.matches("[A-Z]") || (rhs = rule.getRhs()).getType() != GrammarItem.ItemType.ALTERNATIVES || (alts = rhs.getChildren()).size() != 2 || !alts.stream().allMatch(a -> a.getChildren().size() == 1 && a.getChildren().stream().allMatch(c -> c.getType() == GrammarItem.ItemType.LITERAL && ((InLiteral)c).getValue().equalsIgnoreCase(ruleName)))) continue;
            LOGGER.debug("Rule {} is a letter rule", (Object)ruleName);
            rule.setRuleType(Rule.RuleType.LETTER);
        }
    }

    private void markBnfRules(List<Rule> rules) {
        for (Rule rule : rules) {
            String ruleName = rule.getRuleName();
            BnfSymbols bnfSymbolFromRuleName = BnfSymbols.getByName(ruleName);
            LOGGER.debug("rule {} gave {}", (Object)ruleName, (Object)bnfSymbolFromRuleName);
            if (bnfSymbolFromRuleName == null) continue;
            rule.setRuleType(Rule.RuleType.BNF);
            LOGGER.debug("BNF rule {}", (Object)rule.getStructure(""));
        }
    }
}

