/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4tree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opencypher.tools.g4tree.GrammarItem;

abstract class GrammarItemList
implements GrammarItem {
    private final List<GrammarItem> items = new ArrayList<GrammarItem>();

    GrammarItemList() {
    }

    @Override
    public List<GrammarItem> getChildren() {
        return this.items;
    }

    public int size() {
        return this.items.size();
    }

    public void addItem(GrammarItem grammarItem) {
        this.items.add(grammarItem);
    }

    protected GrammarItem getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public boolean isPlural() {
        if (this.items.size() > 1) {
            return true;
        }
        if (this.items.size() == 1) {
            return this.items.get(0).isPlural();
        }
        return false;
    }

    public String toString() {
        return this.items.stream().map(it -> it.getStructure(" ")).collect(Collectors.joining(", "));
    }

    public String getContentStructure(String indent) {
        return this.items.stream().map(it -> it.getStructure(indent + "   ")).collect(Collectors.joining("\n"));
    }

    @Override
    public GrammarItem reachThrough() {
        if (this.items.size() != 1) {
            return this;
        }
        return this.items.get(0).reachThrough();
    }

    @Override
    public boolean isKeywordPart() {
        for (GrammarItem grammarItem : this.items) {
            if (grammarItem.isKeywordPart()) continue;
            return false;
        }
        return true;
    }
}

