/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Option;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.grammar.Parser;
import org.opencypher.tools.grammar.Tool;
import org.opencypher.tools.io.Output;

class ParseTrees
extends Tool {
    private final Options options = this.options(Options.class, new Option[0]);

    public static void main(String ... args) throws Exception {
        ParseTrees.main(ParseTrees::new, ParseTrees::generate, args);
    }

    ParseTrees(Path workingDir, Map<?, ?> properties) {
        super(workingDir, properties);
    }

    public void generate(Grammar grammar, Output output) throws IOException {
        Parser parser = this.options.parserGenerator().generateParser(grammar, this.rootProductionRule(grammar), output);
        Path sources = this.options.sources();
        if (sources != null) {
            Path destination = this.outputDir();
            if (Files.isDirectory(sources, new LinkOption[0])) {
                Files.walk(sources, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> this.generate(parser, (Path)path, destination, output));
            } else if (Files.isRegularFile(sources, new LinkOption[0])) {
                this.generate(parser, sources, destination, output);
            } else {
                output.format("ParseTree Source does not exist: %s,%n", sources);
            }
        } else {
            output.println("No 'source' specified for ParseTree.");
        }
    }

    private String rootProductionRule(Grammar grammar) {
        String root = this.options.rootProduction();
        if (root == null) {
            String language = grammar.language();
            if (grammar.hasProduction(language)) {
                return language;
            }
            throw new IllegalStateException("No root production rule specified for " + language);
        }
        return root;
    }

    private void generate(Parser parser, Path source, Path destination, Output log) {
        String filename = source.getFileName().toString();
        int dot = filename.lastIndexOf(46);
        switch (dot < 0 ? "" : filename.substring(dot).toLowerCase()) {
            case ".cypher": {
                try {
                    Parser.ParseTree parseTree = parser.parse(Files.readString(source));
                }
                catch (IOException e) {
                    log.format("IOException in reading '%s': %s%n", source, e.getMessage());
                }
                break;
            }
            default: {
                log.format("Cannot determine type of file: %s%n", source);
            }
        }
    }

    @Override
    protected <T> T transform(Class<T> type, String value) {
        if (type == Parser.Generator.class) {
            return type.cast(Parser.generator(value));
        }
        return super.transform(type, value);
    }

    static interface Options {
        default public Path sources() {
            return null;
        }

        default public Parser.Generator parserGenerator() {
            return Antlr4::generateParser;
        }

        default public String rootProduction() {
            return null;
        }
    }
}

