/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.grammar.TermVisitor;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Option;
import org.opencypher.tools.grammar.HtmlLinker;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.grammar.RailRoadDiagrams;
import org.opencypher.tools.grammar.Recursive;
import org.opencypher.tools.grammar.Tool;
import org.opencypher.tools.io.HtmlTag;
import org.opencypher.tools.io.Output;

public final class RailRoadDiagramPages
extends Tool
implements ShapeRenderer.Linker,
HtmlLinker {
    private final Options options = this.options(Options.class, new Option[0]);
    private final ProductionDetailsLinker detailsLinker;
    private final BnfFlavour bnfFlavour = this.options.bnfFlavour();
    private static final TermTransformation<Void, Production, RuntimeException> SIMPLE_DEFINITION = new TermTransformation<Void, Production, RuntimeException>(){

        @Override
        public Production transformNonTerminal(Void param, NonTerminal nonTerminal) throws RuntimeException {
            return nonTerminal.production();
        }

        @Override
        public Production transformOptional(Void param, Optional optional) throws RuntimeException {
            return optional.term().transform(this, param);
        }

        @Override
        public Production transformRepetition(Void param, Repetition repetition) throws RuntimeException {
            return repetition.term().transform(this, param);
        }

        @Override
        public Production transformAlternatives(Void param, Alternatives alternatives) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformSequence(Void param, Sequence sequence) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformLiteral(Void param, Literal literal) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformEpsilon(Void param) throws RuntimeException {
            return null;
        }

        @Override
        public Production transformCharacters(Void param, CharacterSet characters) throws RuntimeException {
            return null;
        }
    };

    public static void main(String ... args) throws Exception {
        RailRoadDiagramPages.main(RailRoadDiagramPages::new, RailRoadDiagramPages::generate, args);
    }

    public static void generate(Grammar grammar, Path workingDir, Output output, Map<String, ?> properties) throws IOException, XMLStreamException {
        new RailRoadDiagramPages(workingDir, properties).generate(grammar, output);
    }

    private RailRoadDiagramPages(Path workingDir, Map<?, ?> properties) {
        super(workingDir, properties);
        this.detailsLinker = this.options.productionDetailsLink();
    }

    @Override
    protected <T> T transform(Class<T> type, String value) {
        if (type == BnfFlavour.class) {
            return type.cast(BnfFlavour.fromString(value));
        }
        if (type == ProductionDetailsLinker.class) {
            return type.cast(ProductionDetailsLinker.fromString(value));
        }
        return super.transform(type, value);
    }

    private void generate(Grammar grammar, Output output) throws IOException, XMLStreamException {
        int diagrams;
        Path outputDir;
        block41: {
            outputDir = this.outputDir();
            ShapeRenderer renderer = RailRoadDiagrams.renderer(this);
            Diagram.CanvasProvider<SVGShapes, XMLStreamException> canvas = RailRoadDiagrams.canvas(output, outputDir);
            diagrams = 0;
            for (Diagram diagram : Diagram.build(grammar, (Diagram.BuilderOptions)this.options)) {
                grammar.transform(diagram.name(), (param, production) -> {
                    this.writeHtml((Path)param, production);
                    return null;
                }, outputDir);
                diagram.render(renderer, canvas);
                ++diagrams;
            }
            try (Output backlinks = Output.output(outputDir.resolve("backlinks.js"));){
                backlinks.println("var backlinks = {");
                grammar.accept(production -> {
                    backlinks.append("  ").append('\"').append(production.name()).append('\"').append(": {\"link\":\"").append(this.referenceLink(production.name())).append("\", \"bnf\":\"").append(production, this.bnfFlavour::bnf).append("\", \"references\": [");
                    for (Production source : production.referencedFrom()) {
                        backlinks.append('\"').append(source.name()).append("\", ");
                    }
                    backlinks.println("]},");
                });
                backlinks.println("};");
            }
            try (HtmlTag.Html html = HtmlTag.html(outputDir.resolve("index.html"));){
                html.head(HtmlTag.head("title", grammar.language(), new HtmlTag.Attribute[0]), HtmlTag.meta("charset", "UTF-8"));
                try (HtmlTag body = html.body();){
                    List<Recursive> recursives;
                    if (grammar.hasProduction(grammar.language())) {
                        body.textTag("h2", "Root production", new HtmlTag.Attribute[0]);
                        body.a(this.referenceLink(grammar.language()), grammar.language());
                    }
                    body.textTag("h2", "Productions without references", new HtmlTag.Attribute[0]);
                    this.listProductions(body, grammar, production -> production.referencedFrom().isEmpty());
                    if (grammar.any(Production::isEmpty)) {
                        body.textTag("h2", "Empty productions", new HtmlTag.Attribute[0]);
                        this.listProductions(body, grammar, Production::isEmpty);
                    }
                    if ((recursives = Recursive.findLeftRecursive(grammar)).isEmpty()) break block41;
                    body.textTag("h2", "Left recursive productions", new HtmlTag.Attribute[0]);
                    try (HtmlTag ul = body.tag("ul", new HtmlTag.Attribute[0]);){
                        for (Recursive recursive : recursives) {
                            HtmlTag li = ul.tag("li", new HtmlTag.Attribute[0]);
                            try {
                                li.a(this.referenceLink(recursive.production.name()), recursive.production.name());
                                HtmlTag nul = li.tag("ul", new HtmlTag.Attribute[0]);
                                try {
                                    recursive.accept((root, left, trace) -> {
                                        try (HtmlTag nli = nul.tag("li", new HtmlTag.Attribute[0]);){
                                            if (left) {
                                                nli.text("left recursive ");
                                            }
                                            nli.text("through: ");
                                            for (Production production : trace) {
                                                nli.a(this.referenceLink(production.name()), production.name());
                                                nli.text(" -> ");
                                            }
                                            nli.a(this.referenceLink(root.name()), root.name());
                                        }
                                    });
                                }
                                finally {
                                    if (nul == null) continue;
                                    nul.close();
                                }
                            }
                            finally {
                                if (li == null) continue;
                                li.close();
                            }
                        }
                    }
                }
            }
        }
        try {
            this.copyResource(outputDir, "explore-backlinks.js");
            this.copyResource(outputDir, "explore-backlinks.css");
        }
        catch (NullPointerException | URISyntaxException e) {
            throw new IOException("Failed to copy 'explore-backlinks.js'", e);
        }
        output.append("Rendered ").append(diagrams).println(" diagrams.");
    }

    private void listProductions(HtmlTag body, Grammar grammar, Predicate<Production> predicate) {
        try (HtmlTag ul = body.tag("ul", new HtmlTag.Attribute[0]);){
            grammar.accept(production -> {
                if (predicate.test(production)) {
                    try (HtmlTag li = ul.tag("li", new HtmlTag.Attribute[0]);){
                        String description;
                        li.a(this.referenceLink(production.name()), production.name());
                        if (production.lexer()) {
                            li.text(" (Lexer rule)");
                        }
                        if ((description = production.description()) != null) {
                            li.text(" - ").text(description);
                        }
                    }
                }
            });
        }
    }

    private void copyResource(Path outputDir, String name) throws IOException, URISyntaxException {
        Files.copy(Path.of(this.getClass().getResource("/" + name).toURI()), outputDir.resolve(name), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public String referenceLink(NonTerminal reference) {
        if (reference.inline()) {
            return "#" + reference.productionName();
        }
        Production production = reference.production();
        while (this.options.shouldSkip(production)) {
            production = production.transform(SIMPLE_DEFINITION, null);
        }
        return production == null ? null : this.referenceLink(production.name());
    }

    @Override
    public String referenceLink(String reference) {
        return this.filename(reference) + ".html";
    }

    @Override
    public String charsetLink(String charset) {
        return RailRoadDiagrams.unicodesetLink(charset);
    }

    private void writeHtml(Path dir, Production production) {
        block35: {
            String svg = this.filename(production.name()) + ".svg";
            try (HtmlTag.Html html = HtmlTag.html(dir.resolve(this.filename(production.name()) + ".html"));){
                html.head(HtmlTag.head("title", production.name(), new HtmlTag.Attribute[0]), HtmlTag.meta("charset", "UTF-8"), HtmlTag.head("script", null, HtmlTag.attr("src", "backlinks.js")), HtmlTag.head("script", null, HtmlTag.attr("src", "explore-backlinks.js")), HtmlTag.head("link", null, HtmlTag.attr("rel", "stylesheet"), HtmlTag.attr("type", "text/css"), HtmlTag.attr("media", "screen"), HtmlTag.attr("href", "explore-backlinks.css")));
                try (final HtmlTag body = html.body();){
                    String detailsLink = null;
                    if (this.detailsLinker != null && null != (detailsLink = this.detailsLinker.productionDetailsLink(production.name()))) {
                        try (HtmlTag h1 = body.tag("h1", new HtmlTag.Attribute[0]);){
                            h1.a(detailsLink, production.name());
                        }
                    } else {
                        body.textTag("h1", production.name(), new HtmlTag.Attribute[0]);
                    }
                    if (production.lexer()) {
                        body.p("Lexer rule");
                    }
                    body.tag("object", HtmlTag.attr("data", svg), HtmlTag.attr("type", "image/svg+xml")).close();
                    String description = production.description();
                    if (description != null) {
                        body.p(description);
                    }
                    body.textTag("h2", "EBNF", new HtmlTag.Attribute[0]);
                    this.bnf(body, production);
                    for (NonTerminal nonTerminal : production.references()) {
                        Production site = nonTerminal.declaringProduction();
                        if (!site.skip()) continue;
                        this.bnf(body, production);
                    }
                    production.definition().accept(new InlinedProductions(){

                        @Override
                        void inline(Production production) {
                            body.tag("a", HtmlTag.attr("name", production.name())).close();
                            RailRoadDiagramPages.this.bnf(body, production);
                        }
                    });
                    Collection<Production> references = production.referencedFrom();
                    if (references.isEmpty()) break block35;
                    body.textTag("h2", "Referenced from", new HtmlTag.Attribute[0]);
                    try (HtmlTag ul = body.tag("ul", HtmlTag.attr("class", "backlinks"));){
                        for (Production reference : references) {
                            HtmlTag li = ul.tag("li", HtmlTag.attr("class", "backlink"), HtmlTag.attr("backlink", reference.name()));
                            try {
                                String name = reference.name();
                                li.a(this.referenceLink(name), name);
                            }
                            finally {
                                if (li == null) continue;
                                li.close();
                            }
                        }
                    }
                }
            }
        }
    }

    private String filename(String productionName) {
        return productionName.replace('/', ' ');
    }

    private void bnf(HtmlTag body, Production production) {
        this.bnfFlavour.bnf(body, production, this);
    }

    private static abstract class InlinedProductions
    implements TermVisitor<RuntimeException>,
    Consumer<Grammar.Term> {
        private final Set<String> inlined = new HashSet<String>();

        private InlinedProductions() {
        }

        abstract void inline(Production var1);

        @Override
        public void accept(Grammar.Term term) {
            term.accept(this);
        }

        @Override
        public void visitNonTerminal(NonTerminal nonTerminal) {
            if (nonTerminal.inline() && this.inlined.add(nonTerminal.productionName())) {
                this.inline(nonTerminal.production());
                nonTerminal.productionDefinition().accept(this);
            }
        }

        @Override
        public void visitAlternatives(Alternatives alternatives) {
            alternatives.forEach(this);
        }

        @Override
        public void visitSequence(Sequence sequence) {
            sequence.forEach(this);
        }

        @Override
        public void visitOptional(Optional optional) {
            optional.term().accept(this);
        }

        @Override
        public void visitRepetition(Repetition repetition) {
            repetition.term().accept(this);
        }

        @Override
        public void visitLiteral(Literal literal) {
        }

        @Override
        public void visitEpsilon() {
        }

        @Override
        public void visitCharacters(CharacterSet characters) {
        }
    }

    public static interface ProductionDetailsLinker {
        public String productionDetailsLink(String var1);

        public static ProductionDetailsLinker fromString(String template) {
            MessageFormat format = new MessageFormat(template);
            return input -> format.format(new Object[]{input});
        }
    }

    public static interface BnfFlavour {
        public void bnf(HtmlTag var1, Production var2, HtmlLinker var3);

        public void bnf(Production var1, Output var2);

        public static BnfFlavour fromString(String value) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    static interface Options
    extends Diagram.BuilderOptions {
        default public ProductionDetailsLinker productionDetailsLink() {
            return null;
        }

        default public BnfFlavour bnfFlavour() {
            return new BnfFlavour(){

                @Override
                public void bnf(HtmlTag parent, Production production, HtmlLinker linker) {
                    ISO14977.html(parent, production, linker);
                }

                @Override
                public void bnf(Production production, final Output output) {
                    ISO14977.string(new Output(){

                        @Override
                        public Output append(char x) {
                            if (x == '\"') {
                                output.append("\\\"");
                            } else {
                                output.append(x);
                            }
                            return this;
                        }
                    }, production);
                }
            };
        }
    }
}

