/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.util.BitSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opencypher.tools.xml.AttributeHandler;
import org.opencypher.tools.xml.CharactersHandler;
import org.opencypher.tools.xml.Resolver;
import org.opencypher.tools.xml.Structure;

class NodeBuilder {
    final String uri;
    final String name;
    private final AttributeHandler[] attributes;
    private final CharactersHandler characters;
    private final CharactersHandler comments;
    private final CharactersHandler headers;
    private final NodeBuilder[] children;
    private final Function<Object, Object> factory;
    private final BiConsumer<Object, Object> handler;

    public static NodeBuilder tree(Class<?> root) {
        return Structure.tree(root).factory(null, (parent, child) -> {});
    }

    public static NodeBuilder choice(NodeBuilder ... rootBuilders) {
        if (rootBuilders.length == 1) {
            return rootBuilders[0];
        }
        int size = rootBuilders.length;
        for (NodeBuilder builder : rootBuilders) {
            if (builder.uri != null) continue;
            size = size - 1 + builder.children.length;
        }
        if (size != rootBuilders.length) {
            NodeBuilder[] builders = new NodeBuilder[size];
            int j = 0;
            for (int i = 0; i < rootBuilders.length; ++i) {
                NodeBuilder builder;
                builder = rootBuilders[i];
                if (builder.uri == null) {
                    for (int k = 0; k < builder.children.length; ++k) {
                        builders[j++] = builder.children[k];
                    }
                    continue;
                }
                builders[j++] = builder;
            }
        }
        return new NodeBuilder(rootBuilders);
    }

    NodeBuilder(String uri, String name, AttributeHandler[] attributes, CharactersHandler characters, CharactersHandler comments, CharactersHandler headers, NodeBuilder[] children, Function<Object, Object> factory, BiConsumer<Object, Object> handler) {
        this.uri = uri;
        this.name = name;
        this.attributes = attributes;
        this.characters = characters;
        this.comments = comments;
        this.headers = headers;
        this.children = children;
        this.factory = factory;
        this.handler = handler;
    }

    private NodeBuilder(NodeBuilder[] builders) {
        this.name = null;
        this.uri = null;
        this.attributes = null;
        this.characters = null;
        this.comments = null;
        this.headers = null;
        this.children = builders;
        this.factory = null;
        this.handler = null;
    }

    public String toString() {
        return String.format("Element{uri='%s', name='%s'}", this.uri, this.name);
    }

    public Object create(Object parent) {
        return this.factory.apply(parent);
    }

    public void child(Object parent, Object child) {
        this.handler.accept(parent, child);
    }

    public boolean attribute(BitSet remaining, Object target, Resolver resolver, String uri, String name, String type, String value) {
        for (int i = 0; i < this.attributes.length; ++i) {
            AttributeHandler attribute = this.attributes[i];
            if (!attribute.matches(uri, name)) continue;
            attribute.apply(target, resolver, value);
            remaining.clear(i);
            return true;
        }
        return false;
    }

    public void characters(Object target, char[] buffer, int start, int length) {
        this.characters.characters(target, buffer, start, length);
    }

    public void comment(Object target, char[] buffer, int start, int length) {
        this.comments.characters(target, buffer, start, length);
    }

    public void header(Object target, char[] buffer) {
        this.headers.characters(target, buffer, 0, buffer.length);
    }

    public NodeBuilder child(String uri, String name) {
        for (NodeBuilder child : this.children) {
            if (!child.matches(uri, name)) continue;
            return child;
        }
        if (this.name == null) {
            throw new IllegalArgumentException("No such root: '" + name + "' in namespace " + uri);
        }
        throw new IllegalArgumentException("No such child: '" + name + "' in namespace " + uri + " of '" + this.name + "' in namespace " + this.uri);
    }

    public boolean matches(String uri, String name) {
        return this.uri.equalsIgnoreCase(uri) && this.name.equalsIgnoreCase(name);
    }

    public BitSet requiredAttributes() {
        BitSet required = new BitSet(this.attributes.length);
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].optional) continue;
            required.set(i);
        }
        return required;
    }

    public void verifyRequiredAttributes(BitSet required) {
        if (required.cardinality() != 0) {
            throw new IllegalArgumentException(required.stream().mapToObj(i -> this.attributes[i].name).collect(Collectors.joining(", ", "Missing required attributes: ", "")));
        }
    }
}

