/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opencypher.grammar.CodePointSet;

@RunWith(value=Enclosed.class)
public class CodePointSetTest {
    private static Object[] parses(String input, final CodePointSet ... expected) {
        return new Object[]{new ParsingTest(input){

            @Override
            void parsing() {
                CodePointSetTest.assertParses(this.input, expected);
            }
        }};
    }

    private static Object[] fails(String input, final Matcher<String> message) {
        return new Object[]{new ParsingTest(input){

            @Override
            void parsing() {
                CodePointSetTest.assertParsingFails(this.input, (Matcher<String>)message);
            }
        }};
    }

    static void assertParses(String input, CodePointSet ... expected) {
        Assert.assertEquals((Object)CodePointSet.union((CodePointSet[])expected), (Object)CodePointSet.parse((String)input));
    }

    static void assertParsingFails(String input, Matcher<String> message) {
        try {
            CodePointSet.parse((String)input);
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), message);
        }
    }

    static abstract class ParsingTest {
        final String input;

        ParsingTest(String input) {
            this.input = input;
        }

        abstract void parsing();

        public String toString() {
            switch (this.getClass().getEnclosingMethod().getName()) {
                case "parses": {
                    return "should parse \"" + this.input + "\"";
                }
                case "fails": {
                    return "should fail to parse \"" + this.input + "\"";
                }
            }
            return "\"" + this.input + "\"";
        }
    }

    @RunWith(value=Parameterized.class)
    public static class Parser {
        private final ParsingTest test;

        public Parser(ParsingTest test) {
            this.test = test;
        }

        @Test
        public void parse() throws Exception {
            this.test.parsing();
        }

        @Parameterized.Parameters(name="{0}")
        public static List<Object[]> tests() {
            return Arrays.asList(CodePointSetTest.parses("[a]", CodePointSet.single((int)97)), CodePointSetTest.parses("[a-z]", new CodePointSet[]{CodePointSet.range((int)97, (int)122)}), CodePointSetTest.parses("[a-z0-9]", new CodePointSet[]{CodePointSet.range((int)97, (int)122), CodePointSet.range((int)48, (int)57)}), CodePointSetTest.parses("[aoueiy]", CodePointSet.codePoints((int[])new int[]{97, 111, 117, 101, 105, 121})), CodePointSetTest.parses("[\\a]", CodePointSet.single((int)7)), CodePointSetTest.parses("[\\b]", CodePointSet.single((int)8)), CodePointSetTest.parses("[\\e]", CodePointSet.single((int)27)), CodePointSetTest.parses("[\\f]", CodePointSet.single((int)12)), CodePointSetTest.parses("[\\n]", CodePointSet.single((int)10)), CodePointSetTest.parses("[\\r]", CodePointSet.single((int)13)), CodePointSetTest.parses("[\\t]", CodePointSet.single((int)9)), CodePointSetTest.parses("[\\v]", CodePointSet.single((int)11)), CodePointSetTest.fails("[a-]", (Matcher<String>)Matchers.containsString((String)"cannot end in '-' or '\\'")), CodePointSetTest.fails("[a--b]", (Matcher<String>)Matchers.containsString((String)"'-' may not follow '-'")), CodePointSetTest.fails("[-z]", (Matcher<String>)Matchers.containsString((String)"'-' must be preceded by single char")), CodePointSetTest.fails("[\\]", (Matcher<String>)Matchers.containsString((String)"cannot end in '-' or '\\'")), CodePointSetTest.fails("[\\x]", (Matcher<String>)Matchers.containsString((String)"Invalid escape character")), CodePointSetTest.fails("a-z", (Matcher<String>)Matchers.containsString((String)"must be enclosed in '[...]")), CodePointSetTest.fails("[a-z", (Matcher<String>)Matchers.containsString((String)"must be enclosed in '[...]")), CodePointSetTest.fails("a-z]", (Matcher<String>)Matchers.containsString((String)"must be enclosed in '[...]")));
        }
    }
}

