/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.util.Arrays;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.FigureBuilder;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Option;
import org.opencypher.tools.io.Output;

@RunWith(value=Parameterized.class)
public class SVGShapesLocaleTest {
    private Locale locale;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({Locale.GERMANY}, {Locale.US}, {Locale.JAPAN}, {Locale.CHINA});
    }

    public SVGShapesLocaleTest(Locale locale) {
        this.locale = locale;
    }

    @Before
    @After
    public void swapLocale() {
        Locale dl = Locale.getDefault();
        Locale.setDefault(this.locale);
        this.locale = dl;
    }

    @Test
    public void shouldRenderCorrectSvgRegardlessOfLocale() throws Exception {
        Diagram diagram = Diagram.diagram((String)"", (Diagram.Figure)FigureBuilder.line((Diagram.Figure[])new Diagram.Figure[]{FigureBuilder.text((String)"GRAPHS"), FigureBuilder.branch((Diagram.Figure[])new Diagram.Figure[]{FigureBuilder.nothing(), FigureBuilder.text((String)"ARE")}), FigureBuilder.text((String)"EVERYWHERE")}));
        Output.Readable output = Output.stringBuilder();
        ShapeRenderer renderer = new ShapeRenderer(new Option[0]);
        Diagram.CanvasProvider canvas = SVGShapes.svgFile(name -> output);
        diagram.render((Diagram.Renderer)renderer, canvas);
        MatcherAssert.assertThat((Object)output.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)",")));
    }
}

