/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.util.Objects;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.ComparisonFailure;
import org.opencypher.tools.NamedFunction;

public class Assert {
    public static <T, A> Matcher<T> with(final NamedFunction<T, A> attribute, final Matcher<A> matcher) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                return matcher.matches(attribute.apply(item));
            }

            public void describeTo(Description description) {
                description.appendText(attribute.name()).appendText(" that is ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static void assertEquals(Supplier<String> message, Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            if (expected instanceof String && actual instanceof String) {
                String cleanMessage = message.get();
                if (cleanMessage == null) {
                    cleanMessage = "";
                }
                throw new ComparisonFailure(cleanMessage, (String)expected, (String)actual);
            }
            org.junit.Assert.fail((String)Assert.format(message.get(), expected, actual));
        }
    }

    private static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        Object formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return (String)formatted + "expected: " + Assert.formatClassAndValue(expected, expectedString) + " but was: " + Assert.formatClassAndValue(actual, actualString);
        }
        return (String)formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }
}

