/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import org.antlr.v4.Tool;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerInterpreter;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.junit.Assert;
import org.junit.Test;
import org.opencypher.tools.grammar.Antlr4TestUtils;

public class Antlr4ParserTest {
    @Test
    public void shouldReportInvalidCypher() throws FileNotFoundException, URISyntaxException {
        List<String> queries = this.getQueries("/cypher-error.txt");
        Stream<Pair> results = queries.stream().map(query -> {
            SyntaxError lexerListener = new SyntaxError();
            SyntaxError parserListener = new SyntaxError();
            Antlr4TestUtils.parseLegacyWithListeners(query, lexerListener, parserListener);
            return new Pair((Object)parserListener.errorFound, query);
        });
        results.forEach(r -> {
            if (!((Boolean)r.a).booleanValue()) {
                Assert.fail((String)("Expected query to raise syntax error, but it did not: " + (String)r.b));
            }
        });
    }

    @Test
    public void shouldParseValidCypher() throws FileNotFoundException, URISyntaxException {
        this.getQueries("/cypher.txt").forEach(Antlr4TestUtils::parse);
    }

    @Test
    public void shouldParseLegacyCypher() throws FileNotFoundException, URISyntaxException {
        this.getQueries("/cypher-legacy.txt").forEach(Antlr4TestUtils::parseLegacy);
    }

    public void investigateTokenStream() throws IOException {
        String query = "CREATE (a)";
        Tool tool = new Tool();
        GrammarRootAST ast = tool.parseGrammarFromString(new String(Files.readAllBytes(Paths.get("../../grammar/generated/Cypher.g4", new String[0]))));
        Grammar g = tool.createGrammar(ast);
        tool.process(g, false);
        LexerInterpreter lexer = g.createLexerInterpreter((CharStream)CharStreams.fromString((String)query));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
    }

    private List<String> getQueries(String queryFile) throws FileNotFoundException, URISyntaxException {
        URL resource = this.getClass().getResource(queryFile);
        assert (resource != null);
        Scanner scanner = new Scanner(Paths.get(resource.toURI()).toFile(), StandardCharsets.UTF_8.name());
        scanner.useDelimiter("\u00a7\n(//.*\n)*");
        ArrayList<String> queries = new ArrayList<String>();
        while (scanner.hasNext()) {
            String next = scanner.next();
            queries.add(next);
        }
        return queries;
    }

    private static class SyntaxError
    implements ANTLRErrorListener {
        boolean errorFound = false;

        private SyntaxError() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object o, int i, int i1, String s, RecognitionException e) {
            this.errorFound = true;
        }

        public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
        }

        public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
        }

        public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
        }
    }
}

