/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.function.Function;
import org.opencypher.generator.Choices;
import org.opencypher.generator.Node;
import org.opencypher.generator.TracingChoices;
import org.opencypher.grammar.BiasedTerms;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Repetition;
import org.opencypher.tools.Functions;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.io.LineInput;
import org.opencypher.tools.io.Output;

public class InteractiveChoices
implements Choices {
    private final Interface repl;

    public InteractiveChoices(LineInput input, Output output, Choices defaultChoices) {
        this.repl = new Interface(Functions.requireNonNull(LineInput.class, input), Functions.requireNonNull(Output.class, output), defaultChoices);
    }

    @Override
    public Grammar.Term choose(Node location, BiasedTerms alternatives) {
        return this.repl.eval(location, alternatives, Choices::choose, InteractiveChoices::alternatives, in -> alternatives.term(Integer.parseUnsignedInt(in)));
    }

    @Override
    public int repetition(Node location, Repetition repetition) {
        return this.repl.eval(location, repetition, Choices::repetition, InteractiveChoices::repetition, InteractiveChoices.parseInt(repetition));
    }

    @Override
    public boolean includeOptional(Node location, Optional optional) {
        return this.repl.eval(location, optional, Choices::includeOptional, InteractiveChoices::optional, InteractiveChoices::parseYesNo);
    }

    @Override
    public int codePoint(Node location, CharacterSet characters) {
        return this.repl.eval(location, characters, Choices::codePoint, InteractiveChoices::character, InteractiveChoices.parseChar(characters));
    }

    private static void alternatives(Output output, BiasedTerms alternatives, Grammar.Term def) {
        output.println(", chose one of:");
        int terms = alternatives.terms();
        for (int i = 0; i < terms; ++i) {
            output.append(i).append(". ");
            Grammar.Term term = alternatives.term(i);
            ISO14977.append(term, output);
            output.append(term == def ? " [default]" : "");
            output.println();
        }
        output.append("Chose an alternative [0-").append(alternatives.terms() - 1).append("]: ");
    }

    private static void repetition(Output output, Repetition repetition, Integer def) {
        output.append(", how many times should ");
        ISO14977.append(repetition.term(), output);
        output.append(" be repeated? ");
        if (repetition.limited()) {
            output.append('[').append(repetition.minTimes()).append(repetition.maxTimes()).append(']');
        } else {
            output.append("[min ").append(repetition.minTimes()).append(']');
        }
        if (def != null) {
            output.append(" [default=").append(def).append(']');
        }
        output.append(": ");
    }

    private static void optional(Output output, Optional optional, Boolean def) {
        output.append(", should optional ");
        ISO14977.append(optional.term(), output);
        output.append(" be included? ");
        if (def == null) {
            output.append("[yn]: ");
        } else if (def.booleanValue()) {
            output.append("[Yn]: ");
        } else {
            output.append("[yN]: ");
        }
    }

    private static void character(Output output, CharacterSet characters, Integer def) {
        output.append(", emit character");
        if (def != null) {
            output.append(" [default: 0x").append(Integer.toHexString(def)).append("]");
        }
        output.append(": ");
    }

    private static Function<String, Integer> parseChar(CharacterSet characters) {
        return in -> {
            int cp = in.length() >= 1 && Character.charCount(in.codePointAt(0)) == in.length() ? in.codePointAt(0) : (in.startsWith("0x") ? Integer.parseInt(in.substring(2), 16) : Integer.parseUnsignedInt(in));
            return characters.contains(cp) ? Integer.valueOf(cp) : null;
        };
    }

    private static Function<String, Integer> parseInt(Repetition repetition) {
        return in -> {
            int result = Integer.parseUnsignedInt(in);
            return result < repetition.minTimes() || repetition.limited() && result > repetition.maxTimes() ? null : Integer.valueOf(result);
        };
    }

    private static Boolean parseYesNo(String in) {
        switch (in.toLowerCase()) {
            case "y": 
            case "yes": {
                return true;
            }
            case "n": 
            case "no": {
                return false;
            }
        }
        return null;
    }

    private static class Interface {
        private final LineInput input;
        private final Output output;
        private final Choices defaultChoices;

        private Interface(LineInput input, Output output, Choices defaultChoices) {
            this.input = input;
            this.output = output;
            this.defaultChoices = defaultChoices;
        }

        <S, T> T eval(Node loc, S in, Default<S, T> def, Body<S, T> body, Function<String, T> parse) {
            T defaultChoice = this.defaultChoices == null ? null : (T)def.of(this.defaultChoices, loc, in);
            while (true) {
                this.output.append("At ");
                TracingChoices.location(this.output, loc);
                body.write(this.output, in, defaultChoice);
                this.output.flush();
                String line = this.input.read().trim();
                if (line.isEmpty()) {
                    if (defaultChoice != null) {
                        return defaultChoice;
                    }
                    this.output.append("Invalid input, no default choices available.");
                } else {
                    try {
                        T result = parse.apply(line);
                        if (result != null) {
                            return result;
                        }
                        this.output.append("Invalid input.");
                    }
                    catch (Exception e) {
                        this.output.append("Invalid input: ").append(e.getMessage());
                    }
                }
                this.output.println();
            }
        }
    }

    private static interface Body<S, T> {
        public void write(Output var1, S var2, T var3);
    }

    private static interface Default<S, T> {
        public T of(Choices var1, Node var2, S var3);
    }
}

