/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencypher.grammar.AlternativesNode;
import org.opencypher.grammar.CharacterSetNode;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.LiteralNode;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminalNode;
import org.opencypher.grammar.OptionalNode;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProductionResolver;
import org.opencypher.grammar.RepetitionNode;
import org.opencypher.grammar.SequenceNode;
import org.opencypher.grammar.Terms;
import org.opencypher.tools.xml.Child;

abstract class Container
extends Node
implements Terms {
    final List<Node> nodes = new ArrayList<Node>();

    Container() {
    }

    @Child(value={AlternativesNode.class, SequenceNode.class, LiteralNode.class, CharacterSetNode.class, NonTerminalNode.class, OptionalNode.class, RepetitionNode.class})
    final void add(Node node) {
        this.nodes.add(node.replaceWithVerified());
    }

    @Override
    public Iterator<Grammar.Term> iterator() {
        final Iterator<Node> iterator = this.nodes.iterator();
        return new Iterator<Grammar.Term>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Grammar.Term next() {
                return (Grammar.Term)iterator.next();
            }
        };
    }

    @Override
    public int terms() {
        return this.nodes.size();
    }

    @Override
    public Grammar.Term term(int offset) {
        return this.nodes.get(offset);
    }

    @Override
    final boolean resolve(ProductionNode origin, ProductionResolver resolver) {
        ArrayList<Node> nodes = new ArrayList<Node>(this.nodes);
        nodes.stream().filter(node -> !node.resolve(origin, resolver)).forEach(this.nodes::remove);
        return !nodes.isEmpty();
    }

    @Child
    final void literal(char[] buffer, int start, int length) {
        LiteralNode.fromCharacters(buffer, start, length, this::add);
    }

    final Node addAll(Iterable<? extends Grammar.Term> terms) {
        for (Grammar.Term term : terms) {
            term.addTo(this);
        }
        return this;
    }

    final Node addAll(Grammar.Term first, Grammar.Term ... more) {
        first.addTo(this);
        if (more != null) {
            for (Grammar.Term term : more) {
                term.addTo(this);
            }
        }
        return this;
    }

    @Override
    public final int hashCode() {
        int hash = this.attributeHash();
        for (Node node : this.nodes) {
            hash = hash * 31 + node.hashCode();
        }
        return hash;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Container that = (Container)obj;
        return this.attributeEquals(that) && this.nodes.equals(that.nodes);
    }

    @Override
    public final String toString() {
        StringBuilder result = new StringBuilder().append(this.getClass().getSimpleName());
        result.setLength(result.length() - 4);
        this.attributeString(result);
        result.append('[');
        String sep = "";
        for (Node child : this.nodes) {
            result.append(sep).append(child);
            sep = ", ";
        }
        return result.append(']').toString();
    }

    int attributeHash() {
        return 0;
    }

    boolean attributeEquals(Container that) {
        return true;
    }

    void attributeString(StringBuilder result) {
    }
}

