/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.CharacterSetNode;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.SequenceNode;
import org.opencypher.grammar.TermTransformation;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Element;

@Element(uri="http://opencypher.org/grammar", name="literal")
final class LiteralNode
extends Node
implements Literal {
    @Attribute
    String value;
    @Attribute(optional=true, name="case-sensitive")
    boolean caseSensitive = true;

    LiteralNode() {
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int codePointAt(int index) {
        return this.value.codePointAt(index);
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.substring(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    @Override
    public <EX extends Exception> void accept(Literal.Visitor<EX> visitor) throws EX {
        if (this.caseSensitive) {
            visitor.visitLiteral(this.value);
        } else {
            char cp;
            int start = 0;
            int end = this.value.length();
            for (int i = 0; i < end; i += Character.charCount(cp)) {
                cp = this.value.charAt(i);
                if (!Character.isLowerCase((int)cp) && !Character.isUpperCase((int)cp) && !Character.isTitleCase((int)cp)) continue;
                if (start < i) {
                    visitor.visitLiteral(this.value.substring(start, i));
                }
                start = i + Character.charCount(cp);
                visitor.visitAnyCase(cp);
            }
            if (start < this.value.length()) {
                visitor.visitLiteral(this.value.substring(start));
            }
        }
    }

    static void fromCharacters(char[] buffer, int start, int length, Consumer<? super LiteralNode> add) {
        int pos;
        int step;
        int end = start + length;
        for (pos = start; pos < end; pos += step) {
            int cp = Character.codePointAt(buffer, pos);
            step = Character.charCount(cp);
            if (!Character.isWhitespace(cp)) continue;
            if (start != pos) {
                LiteralNode.textLiteral(add, new String(buffer, start, pos - start));
            }
            start = pos + step;
        }
        if (start != pos) {
            LiteralNode.textLiteral(add, new String(buffer, start, pos - start));
        }
    }

    private static void textLiteral(Consumer<? super LiteralNode> add, String literal) {
        add.accept(LiteralNode.literal(literal, false));
    }

    @Override
    Node replaceWithVerified() {
        int cp;
        if (this.value.length() == 1) {
            String control = CharacterSet.controlCharName(this.value.charAt(0));
            if (control != null) {
                return CharacterSetNode.charSet(control);
            }
            return this;
        }
        SequenceNode seq = null;
        int start = 0;
        for (int i = 0; i < this.value.length(); i += Character.charCount(cp)) {
            cp = this.value.codePointAt(i);
            String control = CharacterSet.controlCharName(cp);
            if (control == null) continue;
            if (seq == null) {
                seq = new SequenceNode();
            }
            if (start < i) {
                seq.add(LiteralNode.literal(this.value.substring(start, i), this.caseSensitive));
            }
            seq.add(CharacterSetNode.charSet(control));
            start = i + 1;
        }
        if (seq != null) {
            if (start < this.value.length()) {
                seq.add(LiteralNode.literal(this.value.substring(start), this.caseSensitive));
            }
            return seq;
        }
        return this;
    }

    private static LiteralNode literal(String value, boolean caseSensitive) {
        LiteralNode literal = new LiteralNode();
        literal.value = value;
        literal.caseSensitive = caseSensitive;
        return literal;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != LiteralNode.class) {
            return false;
        }
        LiteralNode that = (LiteralNode)obj;
        return Objects.equals(this.value, that.value) && this.caseSensitive == that.caseSensitive;
    }

    @Override
    public <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> transformation, P param) throws EX {
        return transformation.transformLiteral(param, this);
    }
}

