/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Map;
import java.util.Set;
import org.opencypher.grammar.Dependencies;
import org.opencypher.grammar.ForeignReference;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProtoGrammar;

class ProductionResolver {
    private final Grammar.Resolver resolver;
    private final Map<String, ProductionNode> productions;
    private final Dependencies dependencies;
    private final Set<String> unused;
    private final Set<ProtoGrammar.ResolutionOption> options;
    private final Set<String> legacyProductions;
    private int nonTerminalIndex;

    public ProductionResolver(Grammar.Resolver resolver, Map<String, ProductionNode> productions, Dependencies dependencies, Set<String> unused, Set<ProtoGrammar.ResolutionOption> options, Set<String> legacyProductions) {
        this.resolver = resolver;
        this.productions = productions;
        this.dependencies = dependencies;
        this.unused = unused;
        this.options = options;
        this.legacyProductions = legacyProductions;
    }

    public ProductionNode resolveProduction(ProductionNode origin, String name) {
        ProductionNode production = this.productions.get(name.toLowerCase());
        if (production == null && !this.options.contains((Object)ProtoGrammar.ResolutionOption.INCLUDE_LEGACY) && !this.legacyProductions.contains(name.toLowerCase())) {
            this.dependencies.missingProduction(name, origin);
        } else if (production != null && production.name.equals(name)) {
            this.unused.remove(name);
            this.dependencies.usedFrom(name, origin);
        } else {
            production = null;
        }
        return production;
    }

    public int nextNonTerminalIndex() {
        return this.nonTerminalIndex++;
    }

    public Grammar.Unresolved.Production resolve(ForeignReference reference) {
        return this.resolver.resolve(reference);
    }
}

