/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opencypher.grammar.AlternativesNode;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.LiteralNode;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminalNode;
import org.opencypher.grammar.OptionalNode;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProtoGrammar;
import org.opencypher.grammar.SequenceNode;
import org.opencypher.grammar.WG3Reference;
import org.opencypher.tools.grammar.RailRoadDiagramPages;
import org.opencypher.tools.grammar.SQLBNF;
import org.opencypher.tools.io.Output;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Element;
import org.opencypher.tools.xml.LocationAware;
import org.opencypher.tools.xml.XmlParser;

@Element(uri="", name="grammar")
class WG3Grammar
extends ProtoGrammar
implements LocationAware {
    static final String XML_NAMESPACE = "";
    static final XmlParser<WG3Grammar> XML = XmlParser.xmlParser(WG3Grammar.class);
    Grammar.Builder grammar;

    WG3Grammar() {
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            WG3Grammar.run(Path.of(arg, new String[0]));
        }
    }

    private static void run(Path inputFile) throws Exception {
        Grammar grammar = XML.parse(inputFile, new XmlParser.Option[0]).resolve(ProtoGrammar.NO_RESOLVER, ProtoGrammar.ResolutionOption.ALLOW_ROOTLESS);
        SQLBNF.write(grammar, Output.stdOut());
        HashMap<String, Path> properties = new HashMap<String, Path>();
        properties.put("RailRoadDiagramPages.outputDir", inputFile.resolveSibling("railroads"));
        Files.list(inputFile.toAbsolutePath().getParent()).filter(path -> path.toString().toUpperCase().endsWith("GQL.PDF")).max(Comparator.comparing(path -> path.getFileName().toString())).ifPresent(path -> properties.put("RailRoadDiagramPages.productionDetailsLink", (Path)((Object)("../" + path.getFileName().toString() + "#''BNF_{0}''"))));
        RailRoadDiagramPages.generate(grammar, inputFile.getParent(), Output.stdOut(), properties);
    }

    @Override
    public void location(String path, int lineNumber, int columnNumber) {
        int end = path.lastIndexOf(46);
        String language = path.substring(path.lastIndexOf(47) + 1, end < 0 ? path.length() : end);
        this.grammar = Grammar.grammar(language, new Grammar.Option[0]);
    }

    @Child
    void add(BnfDef def) {
        def.addTo(this.grammar);
    }

    @Override
    String language() {
        return this.grammar.language();
    }

    @Override
    ProductionNode production(String name) {
        return this.grammar.production(name);
    }

    @Override
    void setName(String name) {
        this.grammar.setName(name);
    }

    @Override
    Grammar resolve(Grammar.Resolver resolver, Set<ProtoGrammar.ResolutionOption> options) {
        options.add(ProtoGrammar.ResolutionOption.ALLOW_ROOTLESS);
        return this.grammar.resolve(resolver, (Set)options);
    }

    @Override
    void add(ProductionNode production) {
        this.grammar.add(production);
    }

    @Override
    void apply(ProtoGrammar.Patch patch) {
        this.grammar.apply(patch);
    }

    @Element(uri="", name="ellipsis")
    static class Ellipsis {
        Ellipsis() {
        }
    }

    @Element(uri="", name="allAltsFrom")
    static class AllAltsReference {
        @Attribute
        String part;
        @Attribute(optional=true)
        String standard;

        AllAltsReference() {
        }
    }

    @Element(uri="", name="seeTheRules")
    static class SeeTheRules {
        SeeTheRules() {
        }
    }

    @Element(uri="", name="terminalsymbol")
    static class TerminalSymbol
    extends Literal {
        TerminalSymbol() {
        }

        @Override
        void annotate(LiteralNode literal) {
            literal.caseSensitive = true;
        }
    }

    @Element(uri="", name="sjkw")
    static class JsonKeyword
    extends Literal {
        JsonKeyword() {
        }
    }

    @Element(uri="", name="kw")
    static class Keyword
    extends Literal {
        Keyword() {
        }
    }

    static abstract class Literal
    implements Term {
        private Node literal;

        Literal() {
        }

        @Child
        final void literal(char[] buffer, int start, int length) {
            LiteralNode.fromCharacters(buffer, start, length, this::add);
        }

        private void add(LiteralNode literal) {
            this.annotate(literal);
            if (this.literal != null) {
                SequenceNode seq;
                if (this.literal instanceof SequenceNode) {
                    seq = (SequenceNode)this.literal;
                } else {
                    seq = new SequenceNode();
                    seq.add(this.literal);
                    this.literal = seq;
                }
                seq.add(literal);
            } else {
                this.literal = literal;
            }
        }

        void annotate(LiteralNode literal) {
        }

        @Override
        public Grammar.Term term() {
            if (this.literal == null) {
                throw new IllegalStateException("No keyword!");
            }
            return this.literal;
        }
    }

    @Element(uri="", name="opt")
    static class Opt
    extends Body
    implements Term {
        Opt() {
        }

        @Override
        public Grammar.Term term() {
            OptionalNode opt = new OptionalNode();
            opt.add((Node)super.term());
            return opt;
        }
    }

    @Element(uri="", name="mono")
    static class Monospaced
    extends Body
    implements Term {
        Monospaced() {
        }
    }

    @Element(uri="", name="group")
    static class Group
    extends Body
    implements Term {
        Group() {
        }
    }

    @Element(uri="", name="alt")
    static class Alt
    extends Body
    implements Term {
        AllAltsReference allAltsFrom;

        Alt() {
        }

        @Child
        void allAltsFrom(AllAltsReference reference) {
            this.allAltsFrom = reference;
        }
    }

    @Element(uri="", name="BNF")
    static class BNF
    implements Term {
        @Attribute
        String name;
        @Attribute(optional=true)
        String part;
        @Attribute(optional=true)
        String standard;

        BNF() {
        }

        @Override
        public Grammar.Term term() {
            NonTerminalNode nonTerminal = new NonTerminalNode();
            nonTerminal.ref = this.name;
            if (this.standard != null || this.part != null) {
                nonTerminal.externalReference(new WG3Reference(this.standard, this.part, this.name));
            }
            return nonTerminal;
        }
    }

    @Element(uri="", name="rhs")
    static class Rhs
    extends Body {
        boolean seeTheRules;

        Rhs() {
        }

        @Child
        void seeTheRules(SeeTheRules seeTheRules) {
            this.seeTheRules = true;
        }
    }

    static interface Term {
        public Grammar.Term term();
    }

    static abstract class Body {
        final List<Grammar.Term> terms = new ArrayList<Grammar.Term>();
        private State state = State.INITIAL;

        Body() {
        }

        @Child
        final void literal(char[] buffer, int start, int length) {
            LiteralNode.fromCharacters(buffer, start, length, this::text);
        }

        private void text(LiteralNode literal) {
            this.state.seq(this.terms, literal, this.getClass());
        }

        @Child
        void alt(Alt term) {
            this.state = this.state.alt(this.terms, term.term(), this.getClass());
        }

        @Child(value={BNF.class, Group.class, Monospaced.class, Opt.class, Keyword.class, JsonKeyword.class, TerminalSymbol.class})
        void seq(Term term) {
            this.state = this.state.seq(this.terms, term.term(), this.getClass());
        }

        @Child
        void ellipsis(Ellipsis ellipsis) {
            if (this.state == State.ALT) {
                throw new IllegalStateException("Cannot add <ellipsis> to alt group.");
            }
            int last = this.terms.size() - 1;
            this.terms.set(last, Grammar.oneOrMore(this.terms.get(last), new Grammar.Term[0]));
        }

        public Grammar.Term term() {
            if (this.terms.size() == 1) {
                return this.terms.get(0);
            }
            return this.state.term(this.terms, this.getClass());
        }

        static enum State {
            INITIAL{

                @Override
                Grammar.Term term(List<Grammar.Term> terms, Class<? extends Body> type) {
                    return Grammar.epsilon();
                }
            }
            ,
            ALT{

                @Override
                State seq(List<Grammar.Term> terms, Grammar.Term term, Class<? extends Body> type) {
                    throw new IllegalStateException("Cannot add <" + term.getClass().getSimpleName().toLowerCase() + "> to alt group in <" + type.getSimpleName().toLowerCase() + ">.");
                }

                @Override
                Grammar.Term term(List<Grammar.Term> terms, Class<? extends Body> type) {
                    return new AlternativesNode().addAll(terms);
                }
            }
            ,
            SEQ{

                @Override
                State alt(List<Grammar.Term> terms, Grammar.Term term, Class<? extends Body> type) {
                    throw new IllegalStateException("Cannot add <alt> to sequential group in <" + type.getSimpleName().toLowerCase() + ">.");
                }

                @Override
                Grammar.Term term(List<Grammar.Term> terms, Class<? extends Body> aClass) {
                    return new SequenceNode().addAll(terms);
                }
            };


            State alt(List<Grammar.Term> terms, Grammar.Term term, Class<? extends Body> aClass) {
                terms.add(term);
                return ALT;
            }

            State seq(List<Grammar.Term> terms, Grammar.Term term, Class<? extends Body> aClass) {
                terms.add(term);
                return SEQ;
            }

            abstract Grammar.Term term(List<Grammar.Term> var1, Class<? extends Body> var2);
        }
    }

    @Element(uri="", name="BNFDef")
    static class BnfDef {
        @Attribute(name="name")
        String name;
        boolean predicative;
        private Rhs def;

        BnfDef() {
        }

        @Attribute(optional=true)
        void predicative(String predicative) {
            this.predicative = "yes".equalsIgnoreCase(predicative);
        }

        @Child
        void setDef(Rhs def) {
            if (this.def != null) {
                throw new IllegalStateException("Body of '" + this.name + "' already defined.");
            }
            this.def = def;
        }

        void addTo(Grammar.Builder grammar) {
            if (this.def == null) {
                throw new IllegalStateException("Body of '" + this.name + "' not defined.");
            }
            if (this.def.seeTheRules) {
                grammar.production(this.name, "SEE THE RULES", this.def.term(), new Grammar.Term[0]);
            } else {
                grammar.production(this.name, this.def.term(), new Grammar.Term[0]);
            }
        }
    }
}

