/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.v4.Tool;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerInterpreter;
import org.antlr.v4.runtime.ParserInterpreter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.tool.ANTLRMessage;
import org.antlr.v4.tool.ANTLRToolListener;
import org.antlr.v4.tool.ErrorManager;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Production;
import org.opencypher.tools.grammar.BnfWriter;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.grammar.Parser;
import org.opencypher.tools.grammar.ProductionMappingListener;
import org.opencypher.tools.io.Output;

public class Antlr4
extends BnfWriter {
    static String PREFIX;
    private static String prefix;
    private final Map<String, CharacterSet> fragmentRules = new HashMap<String, CharacterSet>();
    private final Set<String> seenKeywords = new HashSet<String>();
    private final Map<String, String> keywordsInProduction = new LinkedHashMap<String, String>();
    private final ProductionMappingListener mappingListener;
    private String currentProduction;
    private int nextLexerRule;

    public static void setPrefix(String newPrefix) {
        prefix = newPrefix;
    }

    public static void resetPrefix() {
        prefix = PREFIX;
    }

    public static void write(Grammar grammar, Writer writer) {
        Antlr4.write(grammar, Output.output(writer));
    }

    public static void write(Grammar grammar, OutputStream stream) {
        Antlr4.write(grammar, Output.output(stream));
    }

    public static void write(Grammar grammar, Path path, OutputStream stream) {
        Antlr4.write(grammar, stream);
    }

    public static void write(Grammar grammar, Output output) {
        try (Antlr4 antlr = new Antlr4(ProductionMappingListener.NONE, output);){
            antlr.write(grammar);
        }
    }

    private void write(Grammar grammar) {
        String header = grammar.header();
        if (header != null) {
            this.output.println("/**").append(" * ").printLines(header, " * ").println(" */");
        }
        this.output.append("grammar ").append(Antlr4.unspaceString(grammar.language())).println(";").println();
        grammar.accept(this);
    }

    public static void main(String ... args) throws Exception {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        int index = argsList.indexOf("-o");
        String g4OutputFilePath = null;
        if (index >= 0) {
            g4OutputFilePath = (String)argsList.remove(index + 1);
            argsList.remove(index);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Main.execute((grammar, workingDir, stream) -> Antlr4.write(grammar, stream), out, "grammar/cypher.xml");
        if (g4OutputFilePath == null) {
            System.out.print(out.toString(StandardCharsets.UTF_8.name()));
        } else {
            Files.write(Paths.get(g4OutputFilePath, new String[0]), out.toByteArray(), new OpenOption[0]);
            System.out.println("Wrote output grammar to " + g4OutputFilePath);
        }
    }

    public static Parser generateParser(Grammar grammar, String root, Output output) {
        return ParserGenerator.generateParser(grammar, root, output);
    }

    private static String ruleName(String rule) {
        return prefix + Antlr4.unspaceString(rule);
    }

    private Antlr4(ProductionMappingListener mappingListener, Output output) {
        super(output);
        this.mappingListener = mappingListener;
    }

    @Override
    public void close() {
        for (Map.Entry<String, CharacterSet> rule : this.fragmentRules.entrySet()) {
            CharacterSet set = rule.getValue();
            this.output.append("fragment ");
            this.lexerRule(rule.getKey());
            this.output.append(" : ");
            if (set.name() != null && !set.isControlCharacter()) {
                this.output.append("[\\p{").append(set.name()).append("}]");
            } else if ("ANY".equals(set.name())) {
                set.accept(new AnyCharacterExceptFormatter(this.output));
            } else if (set.hasExclusions()) {
                set.accept(new AnyCharacterExceptFormatter(this.output));
            } else {
                this.output.append('[');
                set.accept(new SetFormatter(this.output));
                this.output.append(']');
            }
            this.output.println(" ;").println();
        }
    }

    @Override
    protected void productionCommentPrefix() {
        this.output.println("/**").append(" * ");
    }

    @Override
    protected void productionCommentLinePrefix() {
        this.output.append(" * ");
    }

    @Override
    protected void productionCommentSuffix() {
        this.output.println(" */");
    }

    @Override
    protected void productionStart(Production p) {
        String name;
        this.currentProduction = p.name();
        if (p.lexer()) {
            name = this.lexerRule(this.currentProduction);
        } else {
            name = this.parserRule(this.currentProduction);
            this.nextLexerRule = 0;
        }
        this.mappingListener.map(name, p);
        this.alternativesLinePrefix(this.currentProduction.length());
        this.output.append(":  ");
    }

    @Override
    protected void productionEnd() {
        this.output.println(" ;").println();
        for (Map.Entry<String, String> lexerRule : this.keywordsInProduction.entrySet()) {
            String ruleName = lexerRule.getKey();
            if (this.seenKeywords.contains(ruleName)) continue;
            this.seenKeywords.add(ruleName);
            this.caseInsensitiveProductionStart(ruleName);
            this.inline(lexerRule.getValue());
            this.output.println(" ;").println();
        }
        this.keywordsInProduction.clear();
        this.currentProduction = null;
    }

    private void addFragmentRule(CharacterSet characters) {
        String rule = this.currentProduction + "_" + this.nextLexerRule++;
        this.fragmentRules.put(rule, characters);
        this.lexerRule(rule);
    }

    @Override
    protected void alternativesLinePrefix(int altPrefix) {
        if (altPrefix > 0) {
            this.output.println();
            while (altPrefix-- > 0) {
                this.output.append(' ');
            }
        }
    }

    @Override
    protected void alternativesSeparator() {
        this.output.append(" | ");
    }

    @Override
    protected void sequenceSeparator() {
        this.output.append(" ");
    }

    @Override
    protected void groupPrefix() {
        this.output.append("( ");
    }

    @Override
    protected void groupSuffix() {
        this.output.append(" )");
    }

    @Override
    protected boolean optionalPrefix() {
        return false;
    }

    @Override
    protected void optionalSuffix() {
        this.output.append("?");
    }

    @Override
    protected void repeat(int minTimes, Integer maxTimes, Runnable repeated) {
        if (maxTimes == null) {
            if (minTimes == 0) {
                this.groupWith('(', repeated, ')');
                this.output.append("*");
                return;
            }
            if (minTimes == 1) {
                this.groupWith('(', repeated, ')');
                this.output.append("+");
                return;
            }
        } else {
            if (maxTimes == 1 && minTimes == 0) {
                this.groupWith('(', repeated, ')');
                this.optionalSuffix();
                return;
            }
            if (minTimes == maxTimes) {
                this.groupWith('(', () -> {
                    for (int i = 0; i < minTimes; ++i) {
                        if (i > 0) {
                            this.sequenceSeparator();
                        }
                        repeated.run();
                    }
                }, ')');
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("The Antlr formatter does not support minTimes=%d, maxTimes=%s", minTimes, maxTimes));
    }

    @Override
    protected void characterSet(CharacterSet characters) {
        String setName = characters.name();
        if (setName == null) {
            this.addFragmentRule(characters);
        } else if (setName.equals("EOI")) {
            this.output.append("EOF");
        } else {
            this.fragmentRules.put(setName, characters);
            this.lexerRule(setName);
        }
    }

    @Override
    protected void nonTerminal(NonTerminal nonTerminal) {
        if (nonTerminal.production().lexer()) {
            this.lexerRule(nonTerminal.productionName());
        } else {
            this.parserRule(nonTerminal.productionName());
        }
    }

    private static String unspaceString(String original) {
        return original.replaceAll("(\\s+|-|\\.)", "_");
    }

    private String parserRule(String name) {
        String handle = this.prefix(Antlr4.unspaceString(name));
        this.output.append(handle);
        return handle;
    }

    private String lexerRule(String original) {
        String name = Antlr4.unspaceString(original);
        int cp = name.codePointAt(0);
        if (!Character.isUpperCase(cp)) {
            name = name.codePoints().noneMatch(Character::isUpperCase) ? name.toUpperCase() : new StringBuilder(name.length()).appendCodePoint(Character.toUpperCase(cp)).append(name, Character.charCount(cp), name.length()).toString();
        }
        this.output.append(name);
        return name;
    }

    @Override
    protected String prefix(String s) {
        return prefix + s;
    }

    @Override
    protected void literal(String value) {
        this.escapeAndEnclose(value);
    }

    private boolean reserved(String ruleName) {
        return ruleName.equals("SKIP") || ruleName.equals("MORE");
    }

    private void inline(String value) {
        this.group(() -> {
            int cp;
            String sep = "";
            int start = 0;
            int end = value.length();
            for (int i = 0; i < end; i += Character.charCount(cp)) {
                cp = value.charAt(i);
                if (!Character.isLowerCase(cp) && !Character.isUpperCase(cp) && !Character.isTitleCase(cp)) continue;
                if (start < i) {
                    this.output.append(sep);
                    sep = " ";
                    this.escapeAndEnclose(value.substring(start, i));
                }
                this.output.append(sep);
                sep = " ";
                start = i + Character.charCount(cp);
                cp = Character.toUpperCase(cp);
                String upper = String.valueOf((char)cp);
                this.groupWith('(', () -> {
                    this.escapeAndEnclose(upper);
                    this.alternativesSeparator();
                    this.escapeAndEnclose(upper.toLowerCase());
                }, ')');
            }
            if (start < value.length()) {
                this.output.append(sep);
                this.escapeAndEnclose(value.substring(start));
            }
        });
    }

    @Override
    protected void caseInsensitive(String value) {
        if (value.length() == 1) {
            this.inline(value);
        } else {
            Object lexerRule = value.toUpperCase();
            if (!Character.isLetter(value.codePointAt(0)) || this.reserved((String)lexerRule)) {
                lexerRule = "L_" + (String)lexerRule;
            }
            this.output.append((String)lexerRule);
            this.keywordsInProduction.put((String)lexerRule, value);
        }
    }

    private void escapeAndEnclose(String value) {
        this.output.append("'").escape(value, Antlr4::escapes).append("'");
    }

    @Override
    protected void caseInsensitiveProductionStart(String name) {
        this.currentProduction = name;
        this.lexerRule(this.currentProduction);
        this.output.append(" : ");
        this.nextLexerRule = 0;
    }

    @Override
    protected void epsilon() {
    }

    private static String escapes(int cp) {
        switch (cp) {
            case 13: {
                return "\\r";
            }
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 39: {
                return "\\'";
            }
            case 92: {
                return "\\\\";
            }
        }
        if (cp >= 128) {
            String hex = Integer.toHexString(cp);
            return "\\u" + (hex.length() < 4 ? "00" : "") + Integer.toHexString(cp);
        }
        return null;
    }

    private static void codePoint(Output output, int cp) {
        switch (cp) {
            case 13: {
                output.append("\\r");
                break;
            }
            case 10: {
                output.append("\\n");
                break;
            }
            case 9: {
                output.append("\\t");
                break;
            }
            case 8: {
                output.append("\\b");
                break;
            }
            case 12: {
                output.append("\\f");
                break;
            }
            case 92: {
                output.append("\\\\");
                break;
            }
            case 45: {
                output.append("\\-");
                break;
            }
            case 93: {
                output.append("\\]");
                break;
            }
            default: {
                if (32 <= cp && cp <= 126) {
                    output.appendCodePoint(cp);
                    break;
                }
                output.format("\\u%04X", cp);
            }
        }
    }

    static {
        prefix = PREFIX = "oC_";
    }

    private static class SetFormatter
    implements CharacterSet.DefinitionVisitor<RuntimeException> {
        private final Output output;

        SetFormatter(Output output) {
            this.output = output;
        }

        @Override
        public void visitCodePoint(int cp) {
            if (cp <= 65535) {
                Antlr4.codePoint(this.output, cp);
            }
        }

        @Override
        public void visitRange(int start, int end) {
            if (end <= 65535) {
                Antlr4.codePoint(this.output, start);
                this.output.append('-');
                Antlr4.codePoint(this.output, end);
            } else if (start <= 65535) {
                Antlr4.codePoint(this.output, start);
                this.output.append('-');
                Antlr4.codePoint(this.output, 65535);
            }
        }
    }

    private static class AnyCharacterExceptFormatter
    implements CharacterSet.DefinitionVisitor.NamedSetVisitor<RuntimeException>,
    CharacterSet.ExclusionVisitor<RuntimeException> {
        private final Output output;

        AnyCharacterExceptFormatter(Output output) {
            this.output = output;
        }

        @Override
        public CharacterSet.ExclusionVisitor<RuntimeException> visitSet(String name) {
            this.output.append("~[");
            return this;
        }

        @Override
        public void visitCodePoint(int cp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void excludeCodePoint(int cp) {
            Antlr4.codePoint(this.output, cp);
        }

        @Override
        public void excludeRange(int start, int end) {
            Antlr4.codePoint(this.output, start);
            this.output.append('-');
            Antlr4.codePoint(this.output, end);
        }

        @Override
        public void excludeSet(String name) {
            throw new UnsupportedOperationException("ANY except a named set.");
        }

        @Override
        public void close() {
            this.output.append("]");
        }
    }

    private static class Antlr4Tree
    implements Parser.ParseTree {
        private final ParseTree tree;

        Antlr4Tree(ParseTree tree) {
            this.tree = tree;
        }
    }

    private static class AntlrMessageLogger
    implements ProductionMappingListener,
    ANTLRToolListener {
        private final Output output;
        private final ErrorManager errMgr;
        private boolean errors;
        private final Map<String, Production> productions = new HashMap<String, Production>();
        private final List<Message> messages = new ArrayList<Message>();

        AntlrMessageLogger(Tool tool, Output output) {
            this.errMgr = tool.errMgr;
            this.output = output;
            tool.addListener((ANTLRToolListener)this);
        }

        @Override
        public void map(String name, Production production) {
            this.productions.put(name, production);
        }

        public void info(String msg) {
            this.output.format("ANTLR Parser Generator: %s%n", msg);
        }

        public void error(ANTLRMessage msg) {
            this.errors = true;
            this.messages.add(new Message(true, msg));
        }

        public void warning(ANTLRMessage msg) {
            this.messages.add(new Message(false, msg));
        }

        public void report(Output.Readable source, Grammar grammar) {
            if (!this.messages.isEmpty()) {
                this.messages.sort(Comparator.comparingInt(msg -> msg.message.line).thenComparing(msg -> msg.message.charPosition));
                source.lines(new BiConsumer<String, Integer>(){
                    Iterator<Message> iterator;
                    Message message;
                    {
                        this.iterator = messages.iterator();
                        this.message = this.iterator.next();
                    }

                    @Override
                    public void accept(String line, Integer no) {
                        output.format("%7d: ", no).println(line);
                        while (this.message != null && this.message.message.line <= no) {
                            if (this.message.message.charPosition >= 0) {
                                output.append(this.message.error ? "ERROR:   " : "WARNING: ").repeat(32, this.message.message.charPosition).append('^').println();
                            }
                            output.append(this.message.error ? "ERROR:   " : "WARNING: ").println(errMgr.getMessageTemplate(this.message.message).render());
                            this.message = this.iterator.hasNext() ? this.iterator.next() : null;
                        }
                    }
                });
                HashMap<String, List<Message>> productions = new HashMap<String, List<Message>>();
                for (Message message : this.messages) {
                    this.addProductions(productions, message, message.message.getArgs());
                }
                for (Map.Entry entry : productions.entrySet()) {
                    Production production;
                    this.output.println();
                    try {
                        production = grammar.production((String)entry.getKey());
                    }
                    catch (IllegalArgumentException noSuchProduction) {
                        production = null;
                    }
                    if (production != null) {
                        ISO14977.append(production, this.output);
                    } else {
                        this.output.append("Keyword \"").append((String)entry.getKey()).println("\"");
                    }
                    for (Message message : (List)entry.getValue()) {
                        this.output.println(this.errMgr.getMessageTemplate(message.message).render());
                    }
                    this.output.println();
                }
                if (this.errors) {
                    throw new IllegalStateException("There were errors when generating the ANTLR parser. " + productions.size() + " productions in error: " + productions.keySet());
                }
            }
        }

        private void addProductions(Map<String, List<Message>> productions, Message message, Object obj) {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!(obj instanceof String)) break block2;
                            Production production = this.productions.get(obj);
                            productions.computeIfAbsent(production != null ? production.name() : (String)obj, key -> new ArrayList()).add(message);
                            break block3;
                        }
                        if (!(obj instanceof Rule)) break block4;
                        this.addProductions(productions, message, ((Rule)obj).name);
                        break block3;
                    }
                    if (!(obj instanceof Object[])) break block5;
                    for (Object object : (Object[])obj) {
                        this.addProductions(productions, message, object);
                    }
                    break block3;
                }
                if (!(obj instanceof Collection)) break block3;
                for (Object object : (Collection)obj) {
                    this.addProductions(productions, message, object);
                }
            }
        }

        static class Message {
            final boolean error;
            final ANTLRMessage message;

            Message(boolean error, ANTLRMessage message) {
                this.error = error;
                this.message = message;
            }
        }
    }

    private static class ParserGenerator {
        private ParserGenerator() {
        }

        static Parser generateParser(Grammar grammar, String root, Output output) {
            ANTLRReaderStream generatorInput;
            Output.Readable source = Output.stringBuilder();
            Tool tool = new Tool();
            AntlrMessageLogger messages = new AntlrMessageLogger(tool, output);
            try (Antlr4 antlr = new Antlr4(messages, source);){
                antlr.write(grammar);
            }
            try {
                generatorInput = new ANTLRReaderStream(source.reader());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create reader from buffer.");
            }
            GrammarRootAST ast = tool.parse(grammar.language(), (org.antlr.runtime.CharStream)generatorInput);
            org.antlr.v4.tool.Grammar g = tool.createGrammar(ast);
            tool.process(g, false);
            messages.report(source, grammar);
            String rootRuleName = Antlr4.ruleName(root);
            Rule rootRule = g.getRule(rootRuleName);
            if (rootRule == null) {
                throw new IllegalArgumentException("The generated parser does not define a rule for '" + root + "' (it should have been called '" + rootRuleName + "' by the parser).");
            }
            int rootRuleIndex = rootRule.index;
            return input -> {
                LexerInterpreter lexer = g.createLexerInterpreter((CharStream)CharStreams.fromString((String)input));
                ParserInterpreter parser = g.createParserInterpreter((TokenStream)new CommonTokenStream((TokenSource)lexer));
                ParserRuleContext tree = parser.parse(rootRuleIndex);
                return new Antlr4Tree((ParseTree)tree);
            };
        }
    }
}

