/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiFunction;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Reflection;
import org.opencypher.tools.grammar.Project;

interface Main
extends Serializable {
    public static void main(String ... args) throws Throwable {
        if (args == null || args.length < 1) {
            String path = Reflection.pathOf(Main.class);
            if (new File(path).isFile() && path.endsWith(".jar")) {
                System.err.printf("USAGE: java -jar %s <tool> ...%n", path);
            } else {
                System.err.printf("USAGE: java -cp %s %s <tool> ...%n", path, Main.class.getName());
            }
            System.exit(1);
        } else {
            Method main;
            String formatter = args[0];
            try {
                Class cls;
                if ((formatter.contains(".") || formatter.contains("/")) && Files.isRegularFile(Paths.get(formatter, new String[0]), new LinkOption[0])) {
                    cls = Project.class;
                    formatter = cls.getSimpleName();
                } else {
                    cls = Class.forName(Main.class.getPackage().getName() + "." + formatter);
                    args = Arrays.copyOfRange(args, 1, args.length);
                }
                main = cls.getDeclaredMethod("main", String[].class);
                if (!Modifier.isStatic(main.getModifiers()) || "Main".equals(formatter)) {
                    throw new IllegalArgumentException(formatter);
                }
            }
            catch (Exception e) {
                System.err.println("Unknown formatter: " + formatter);
                throw e;
            }
            try {
                main.invoke(null, new Object[]{args});
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    public void write(Grammar var1, Path var2, OutputStream var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Main program, OutputStream out, String ... args) throws Exception {
        if (args.length == 1) {
            Grammar.ParserOption[] options = Grammar.ParserOption.from(System.getProperties());
            Path grammarPath = null;
            String path = args[0];
            try (FileSystem fs = null;){
                URL resource;
                if (path.indexOf(47) == -1 && (resource = program.getClass().getResource("/" + path)) != null) {
                    URI uri = resource.toURI();
                    if ("jar".equalsIgnoreCase(uri.getScheme())) {
                        fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    grammarPath = Paths.get(uri);
                }
                if (grammarPath == null) {
                    grammarPath = Paths.get(path, new String[0]);
                }
                program.write(Grammar.parseXML(grammarPath, options), grammarPath.getParent(), out);
            }
        } else {
            System.err.println(program.usage((cp, cls) -> String.format("USAGE: java -cp %s %s <grammar.xml>%n", cp, cls)));
            System.exit(1);
        }
    }

    public static void execute(Main program, String ... args) throws Exception {
        OutputStream outStream;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String outFile = null;
        int index = argList.indexOf("-o");
        if (index >= 0) {
            argList.remove(index);
            outFile = (String)argList.remove(index);
            outStream = new FileOutputStream(outFile);
        } else {
            outStream = System.out;
        }
        Main.execute(program, outStream, argList.toArray(new String[argList.size()]));
        if (outFile != null) {
            System.out.println("Wrote output grammar to " + outFile);
        }
    }

    default public String usage(BiFunction<String, String, String> usage) {
        Class<?> implClass = Reflection.lambdaClass(this);
        return usage.apply(Reflection.pathOf(implClass), implClass.getName());
    }
}

