/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.g4processors.BNFProcessor;
import org.opencypher.tools.g4processors.G4Processor;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.grammar.SQLBNF;
import org.opencypher.tools.grammar.Xml;

public class TranslateGrammar {
    public static void main(String[] args) throws Exception {
        OutputStream outStream;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String inXml = TranslateGrammar.getArg("x", argList);
        String inG4 = TranslateGrammar.getArg("g", argList);
        String inBnf = TranslateGrammar.getArg("b", argList);
        String outXml = TranslateGrammar.getArg("X", argList);
        String outG4 = TranslateGrammar.getArg("G", argList);
        String outBnf = TranslateGrammar.getArg("B", argList);
        boolean includeLegacy = TranslateGrammar.getBooleanArg("legacy", argList);
        if (argList.size() != 0) {
            TranslateGrammar.usage(args);
            System.exit(1);
        }
        if (includeLegacy) {
            System.setProperty(Grammar.ParserOption.INCLUDE_LEGACY.name(), "true");
        }
        Callable<Grammar> parser = null;
        int inputOptions = 0;
        if (inXml != null) {
            ++inputOptions;
            Grammar.ParserOption[] parserOptions = Grammar.ParserOption.from(System.getProperties());
            parser = () -> Grammar.parseXML(Paths.get(inXml, new String[0]), parserOptions);
        }
        if (inG4 != null) {
            ++inputOptions;
            G4Processor g4Processor = new G4Processor();
            parser = () -> g4Processor.processFile(inG4);
        }
        if (inBnf != null) {
            ++inputOptions;
            BNFProcessor bnfProcessor = new BNFProcessor();
            parser = () -> bnfProcessor.processFile(inBnf);
        }
        if (inputOptions != 1) {
            System.err.println("Exactly one input grammar must be specified");
            TranslateGrammar.usage(args);
            System.exit(1);
        }
        Grammar grammar = parser.call();
        boolean written = false;
        if (outXml != null) {
            outStream = outXml.equals("-") ? System.out : new FileOutputStream(outXml);
            Xml.write(grammar, outStream);
            outStream.close();
            written = true;
        }
        if (outG4 != null) {
            outStream = outG4.equals("-") ? System.out : new FileOutputStream(outG4);
            Antlr4.setPrefix("");
            Antlr4.write(grammar, outStream);
            outStream.close();
            written = true;
        }
        if (outBnf != null) {
            outStream = outBnf.equals("-") ? System.out : new FileOutputStream(outBnf);
            SQLBNF.write(grammar, outStream);
            outStream.close();
            written = true;
        }
        if (!written) {
            Xml.write(grammar, System.out);
        }
    }

    static String getArg(String key, List<String> argList) {
        int index = argList.indexOf("-" + key);
        if (index >= 0) {
            argList.remove(index);
            return argList.remove(index);
        }
        return null;
    }

    static boolean getBooleanArg(String key, List<String> argList) {
        int index = argList.indexOf("-" + key);
        if (index >= 0) {
            argList.remove(index);
            return true;
        }
        return false;
    }

    static void usage(String[] args) {
        System.err.println("Arguments:\n      -x <path> : input xml file path\n      -g <path> : input antlr G4 file path\n      -b <path> : input SQL BNF file path\n      -X <path>: output xml file path\n      -G <path or .> : output antlr G4 file path or . for sysout\n      -B <path or .> : output SQL BNF file path or . for sysout\n      -legacy : output SQL BNF file path or . for sysout\n One input file path must be given\n Zero or more output file paths may be given\n If no output file path is given, the output will go to sysout.");
    }
}

