/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.EnumSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opencypher.tools.xml.NodeBuilder;
import org.opencypher.tools.xml.ParserStateMachine;
import org.opencypher.tools.xml.Resolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlParser<Root> {
    private static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private final Class<Root> root;
    private final NodeBuilder builder;

    public static <T> XmlParser<T> xmlParser(Class<T> root) {
        return new XmlParser<T>(root, NodeBuilder.tree(root));
    }

    @SafeVarargs
    public static <T> XmlParser<T> combine(Class<T> base, XmlParser<? extends T> ... parsers) {
        NodeBuilder[] rootBuilders = new NodeBuilder[parsers.length];
        for (int i = 0; i < parsers.length; ++i) {
            rootBuilders[i] = parsers[i].builder;
        }
        return new XmlParser<T>(base, NodeBuilder.choice(rootBuilders));
    }

    public Root parse(Path input, Option ... options) throws ParserConfigurationException, SAXException, IOException {
        final Path base = input.getParent();
        return (Root)new Resolver(options){

            @Override
            Path path(String path) {
                return base.resolve(path);
            }
        }.parse(input, this);
    }

    public Root parse(Reader input, Option ... options) throws ParserConfigurationException, SAXException, IOException {
        return this.parse(new Resolver(options){

            @Override
            Path path(String path) {
                throw new IllegalStateException("Cannot resolve path in input from reader");
            }
        }, new InputSource(input));
    }

    public Root parse(InputStream input, Option ... options) throws ParserConfigurationException, SAXException, IOException {
        return this.parse(new Resolver(options){

            @Override
            Path path(String path) {
                throw new IllegalStateException("Cannot resolve path in input from stream");
            }
        }, new InputSource(input));
    }

    private Root parse(Resolver resolver, InputSource input) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(resolver, input, resolver.options);
    }

    Root parse(Resolver resolver, InputSource input, EnumSet<Option> options) throws ParserConfigurationException, SAXException, IOException {
        ParserStateMachine stateMachine = new ParserStateMachine(resolver, this.builder, options);
        SAXParser parser = XmlParser.saxParser(true);
        parser.setProperty(LEXICAL_HANDLER, stateMachine);
        parser.parse(input, (DefaultHandler)stateMachine);
        return this.root.cast(stateMachine.produceRoot());
    }

    private XmlParser(Class<Root> root, NodeBuilder builder) {
        this.root = root;
        this.builder = builder;
    }

    public String toString() {
        return String.format("XmlParser{%s as %s}", this.builder, this.root);
    }

    static SAXParser saxParser(boolean validateDTD) throws ParserConfigurationException, SAXException {
        SAXParserFactory sax = SAXParserFactory.newInstance();
        sax.setNamespaceAware(true);
        if (!validateDTD) {
            sax.setValidating(false);
            sax.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        return sax.newSAXParser();
    }

    public static enum Option {
        FAIL_ON_UNKNOWN_ATTRIBUTE;

    }
}

