/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import org.junit.Assert;
import org.junit.Test;
import org.opencypher.tools.Option;

public class OptionTest {
    @Test
    public void shouldInvokeDefaultsIfNoOverride() throws Exception {
        Options options = (Options)Option.options(Options.class, (Option[])new Option[0]);
        Assert.assertEquals((Object)"foo", (Object)options.foo());
    }

    @Test
    public void shouldOverride() throws Exception {
        Options options = (Options)Option.options(Options.class, (Option[])new Option[]{Option.option((String)"foo", foo -> "bar")});
        Assert.assertEquals((Object)"bar", (Object)options.foo());
    }

    @Test
    public void shouldRejectInvalidOverride() throws Exception {
        try {
            Option.options(Options.class, (Option[])new Option[]{Option.option((String)"baz", baz -> 11)});
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"No such option: baz", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldRequireOverrideForMethodWithoutDefault() throws Exception {
        try {
            Option.options(Options.WithMandatory.class, (Option[])new Option[0]);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Missing required option: mandatory", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAllowOperators() throws Exception {
        Options.WithOperator operator = (Options.WithOperator)Option.options(Options.WithOperator.class, (Option[])new Option[]{Option.option((String)"prefix", prefix -> "Hello ")});
        String result = operator.anOperator("World");
        Assert.assertEquals((Object)"Hello World", (Object)result);
    }

    public static interface Options {
        default public String foo() {
            return "foo";
        }

        public static interface WithOperator {
            default public String anOperator(String parameter) {
                return this.prefix() + parameter;
            }

            public String prefix();
        }

        public static interface WithMandatory {
            public long mandatory();
        }
    }
}

