/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.opencypher.grammar.Fixture;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.g4processors.BNFProcessor;
import org.opencypher.tools.grammar.SQLBNF;
import org.opencypher.tools.grammar.Xml;
import org.opencypher.tools.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNFProcessorTest {
    @Rule
    public final Fixture fixture = new Fixture();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNFProcessorTest.class.getName());
    private static final Pattern XMLANG_PATTERN = Pattern.compile("name=(?:'|\")(\\w+)(?:'|\\\")");

    @Test
    public void oneProduction() {
        this.roundTripBNF("<alpha> ::= ALPHA");
    }

    @Test
    public void twoProductions() {
        this.roundTripBNF("<alpha> ::= ALPHA <beta>", "", "<beta> ::= BETA");
    }

    @Test
    public void twoLiterals() {
        this.roundTripBNF("<alphabeta> ::= ALPHA BETA");
    }

    @Test
    public void alternatives() {
        this.roundTripBNF("<choice> ::= ALPHA | BETA");
    }

    @Test
    public void alternativesAgain() {
        this.roundTripBNF("<choice> ::= ALPHA ", "     | BETA");
    }

    @Test
    public void reference() {
        this.roundTripBNF("<one> ::=  <beta>", "", "<beta> ::= BETA");
    }

    @Test
    public void repeatGroup() {
        this.roundTripBNF("<some> ::=  { ALPHA <beta> } ...", "", "<beta> ::= BETA");
    }

    @Test
    public void repeatOptionalGroup() {
        this.roundTripBNF("<some> ::=  [ ALPHA <beta> ] ...", "", "<beta> ::= BETA");
    }

    @Test
    public void optional() {
        this.roundTripBNF("<perhaps> ::=  [ <beta> ]", "", "<beta> ::= BETA");
    }

    @Test
    public void verticalBar() {
        this.roundTripBNF("<thing> ::= <vertical bar>", "", "<vertical bar> ::= |");
    }

    @Test
    public void keyword() {
        this.roundTripBNF("<something> ::= <STOP>", "", "<STOP> ::= <S> <T> <O> <P>", "", "<O> ::= O | o", "", "<P> ::= P | p", "", "<S> ::= S | s", "", "<T> ::= T | t");
    }

    @Test
    public void whitespace() {
        this.roundTripBNF("<whitespace> ::= \\u0020 | $TAB$ | $LF$ | \\u1680 | \\u180E | \\u2000 | \\u2001");
    }

    @Test
    public void exclamations() {
        this.roundTripBNF("<something> ::= !! something old", "    | <newthing>", "", "<newthing> ::= NEW");
    }

    @Test
    public void leadingDescription() {
        this.roundTripBNF("<something> ::= <newthing>", "", "// this is one", "<newthing> ::= NEW");
    }

    @Test
    public void leadingDescriptionLines() {
        this.roundTripBNF("<something> ::= <newthing>", "", "// this is line one", "//     this is line two", "//     this is line three", "<newthing> ::= NEW");
    }

    @Test
    public void retainHeader() {
        this.roundTripBNF("//", "// an example header", "//", "", "<something> ::= <newthing>", "", "// this is one", "<newthing> ::= NEW");
    }

    @Test
    public void firstDescription() {
        this.roundTripBNF("// an example header", "<something> ::= <newthing>", "", "// this is one", "<newthing> ::= NEW");
    }

    @Test
    public void trailingDescription() {
        String[] inputBnf = new String[]{"<something> ::= <newthing>", "// that might not work", "", "<newthing> ::= NEW"};
        String inBnf = Output.lines((String[])inputBnf).trim();
        BNFProcessor processor = new BNFProcessor();
        Grammar grammar = processor.processString(Output.lines((String[])inputBnf));
        String outputBnf = this.makeSQLBNF(grammar);
        String[] expected = new String[]{"// that might not work", "<something> ::= <newthing>", "", "<newthing> ::= NEW"};
        String expect = Output.lines((String[])expected).trim();
        Assert.assertEquals((Object)this.unPretty(expect), (Object)this.unPretty(outputBnf));
    }

    @Test
    public void bnfProduction() {
        this.roundTripBNF("<prodassign> ::= <assign>", "", "<assign> ::= ::=");
    }

    @Test
    public void bnfSymbolsProduction() {
        this.roundTrip(Grammar.grammar((String)"notequals", (Grammar.Option[])new Grammar.Option[0]).production("notequals", Grammar.literal((String)"<>"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void commaProduction() {
        this.roundTripBNF("<comma> ::= ,");
    }

    @Test
    public void punctuation() {
        this.roundTripBNF("<puncs> ::= +.*=");
    }

    @Test
    public void minus() {
        this.roundTripBNF("<mmm> ::= a-");
    }

    @Test
    public void commasProduction() {
        this.roundTripBNF("<list> ::= ONE <comma> TWO <comma> THREE", "", "<comma> ::= ,");
    }

    @Test
    public void charsetList() {
        this.roundTrip(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"[abcd]"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetName() {
        this.roundTrip(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"FF"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetNameWithException() {
        this.roundTrip(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"Lu").except(new int[]{88, 89}), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetExceptBackslash() {
        this.roundTrip(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", (Grammar.Term)Grammar.charactersOfSet((String)"ANY").except(new int[]{34, 92}), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void charsetRT() {
        this.roundTripBNF("<namedCharset> ::= $FF$");
    }

    @Test
    public void charsetChoice() {
        this.roundTripBNF("<IdentifierStart> ::= $ID_Start$", "  |  $Pc$");
    }

    @Ignore
    @Test
    public void commentInXML() throws Exception {
        Grammar grammar = this.xmlin("<production name=\"comment\">\n    <alt>      <seq>//\r\n        <repeat>\r\n          <character>\r\n            <except literal=\"&#10;\"/> <!-- Line Feed -->\r\n            <except literal=\"&#13;\"/> <!-- Carriage Return -->\r\n          </character>\r\n        </repeat>\r\n        <opt><literal value=\"&#13;\"/></opt> <!-- Carriage Return -->\r\n        <alt>\r\n          <literal value=\"&#10;\"/> <!-- Line Feed -->\r\n          <character set=\"EOI\"/>\r\n        </alt>\r\n      </seq>\r\n</alt>\n  </production>");
        this.roundTrip(grammar);
    }

    @Test
    public void xmlProduction() throws Exception {
        Grammar grammar = this.xmlin("<production name=\"alpha\">\n    <alt>a b c d e f g h i j k l m n o p q r s t u v x y z</alt>\n  </production>");
        this.roundTrip(grammar);
    }

    @Ignore
    @Test
    public void someGrammar() throws Exception {
        Grammar grammar = this.fixture.grammarResource("/somegrammar.xml", new Grammar.ParserOption[0]);
        this.roundTrip(grammar);
    }

    @Test
    public void doubleSlash() throws Exception {
        this.roundTrip(Grammar.grammar((String)"test", (Grammar.Option[])new Grammar.Option[0]).production("test", Grammar.literal((String)"//"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]));
    }

    @Test
    public void leftArrowHead() {
        this.roundTripBNF("<LeftArrowHead> ::= <less than>", "    |  \\u27E8", "    |  \\u3008", "    |  \\uFE64", "    |  \\uFF1C ", "", "<less than> ::= <");
    }

    @Test
    public void shouldRecycleCypher() throws Exception {
        Grammar grammar = Fixture.grammarResource(BNFProcessor.class, "/cypher.xml", new Grammar.ParserOption[0]);
        String firstBNF = this.makeSQLBNF(grammar);
        LOGGER.debug("Generated \n{}", (Object)firstBNF);
        BNFProcessor secondProcessor = new BNFProcessor();
        Grammar grammarTwo = secondProcessor.processString(firstBNF);
        String intermediateBNF = this.makeSQLBNF(grammarTwo);
        LOGGER.debug("Regenerated\n{}", (Object)intermediateBNF);
        Grammar grammarThree = secondProcessor.processString(intermediateBNF);
        String finalBNF = this.makeSQLBNF(grammarTwo);
        Assert.assertEquals((Object)intermediateBNF, (Object)finalBNF);
    }

    private void roundTrip(Grammar testGrammar) {
        String firstBNF = this.makeSQLBNF(testGrammar);
        LOGGER.debug("in \n{}", (Object)firstBNF);
        BNFProcessor processor = new BNFProcessor();
        Grammar grammar = processor.processString(firstBNF);
        String outputBNF = this.makeSQLBNF(grammar);
        LOGGER.debug("out \n{}", (Object)outputBNF);
        Assert.assertEquals((Object)this.unPretty(firstBNF), (Object)this.unPretty(outputBNF));
    }

    private String xmlout(Grammar testGrammar) {
        Output.Readable out = Output.stringBuilder();
        try {
            Xml.write((Grammar)testGrammar, (Output)out);
            return out.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed to create xml", e);
        }
    }

    private Grammar xmlin(String productions) {
        Matcher m = XMLANG_PATTERN.matcher(productions);
        if (m.find()) {
            String language = m.group(1);
            StringBuilder xb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<grammar language=\"").append(language).append("\" xmlns=\"http://opencypher.org/grammar\">\n").append(productions).append("\n</grammar>");
            String xmlString = xb.toString();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes(Charset.forName("UTF-8")));
            try {
                return Grammar.parseXML((InputStream)inputStream, (Grammar.ParserOption[])new Grammar.ParserOption[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse xml\n" + xmlString, e);
            }
        }
        throw new IllegalArgumentException("Cannot find first production name in " + productions);
    }

    private void roundTripBNF(String ... inputBnf) {
        String inBnf = Output.lines((String[])inputBnf).trim();
        BNFProcessor processor = new BNFProcessor();
        LOGGER.debug("in {}", (Object)inBnf);
        Grammar grammar = processor.processString(Output.lines((String[])inputBnf));
        String outputBnf = this.makeSQLBNF(grammar);
        LOGGER.debug("out {}", (Object)outputBnf);
        Assert.assertEquals((Object)this.unPretty(inBnf), (Object)this.unPretty(outputBnf));
    }

    private String makeSQLBNF(Grammar grammar) {
        StringWriter writer = new StringWriter();
        SQLBNF.write((Grammar)grammar, (Writer)writer);
        String outputBnf = writer.toString().trim();
        return outputBnf;
    }

    private String unPretty(String original) {
        original = original.replaceAll("\r", "");
        original = original.replaceAll("((?:!!|//).*?)\n", "$1@!@");
        original = original.replaceAll("\n\n", "#!#");
        original = original.replaceAll("\\s+", " ");
        original = original.replaceAll("@!@", "\n");
        original = original.replaceAll("#!#", "\n\n");
        original = original.replaceAll("\\s*\n\\s*", "\n");
        return original;
    }
}

