/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.opencypher.generator.Generator;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Assert;
import org.opencypher.tools.VerboseUnit;
import org.opencypher.tools.grammar.CypherGeneratorFactory;
import org.opencypher.tools.io.Output;

public class CypherGeneratorFactoryTest {
    @Rule
    public final VerboseUnit verboseUnit = new VerboseUnit(100000);
    private final StateStub state = new StateStub();

    @Test
    public void shouldGenerateIdentifier() throws Exception {
        Generator identifier = this.generator("identifier", Grammar.nonTerminal((String)"IdentifierStart"), Grammar.zeroOrMore((Grammar.Term)Grammar.nonTerminal((String)"IdentifierPart"), (Grammar.Term[])new Grammar.Term[0]));
        this.assertGenerates(identifier, Assert.with(String::length, Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void shouldGenerateNodeVariable() throws Exception {
        Generator node = this.generator("NodePattern", Grammar.literal((String)"("), Grammar.nonTerminal((String)"Variable"), Grammar.literal((String)")"));
        this.assertGenerates(node, Assert.with(String::length, Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))), Matchers.startsWith((String)"("), Matchers.endsWith((String)")"));
    }

    private Generator generator(String name, Grammar.Term first, Grammar.Term ... rest) {
        return new CypherGeneratorFactory(){

            protected CypherGeneratorFactory.State newContext() {
                return CypherGeneratorFactoryTest.this.state;
            }
        }.generator(Grammar.grammar((String)name, (Grammar.Option[])new Grammar.Option[0]).production(name, Grammar.sequence((Grammar.Term)first, (Grammar.Term[])rest), new Grammar.Term[0]).production("Variable", Grammar.nonTerminal((String)"SymbolicNameString"), new Grammar.Term[0]).production("LabelName", Grammar.nonTerminal((String)"SymbolicNameString"), new Grammar.Term[0]).production("RelTypeName", Grammar.nonTerminal((String)"SymbolicNameString"), new Grammar.Term[0]).production("FunctionName", Grammar.nonTerminal((String)"SymbolicNameString"), new Grammar.Term[0]).production("PropertyKeyName", Grammar.nonTerminal((String)"SymbolicNameString"), new Grammar.Term[0]).production("SymbolicNameString", Grammar.oneOf((Grammar.Term)Grammar.nonTerminal((String)"UnescapedSymbolicNameString"), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"EscapedSymbolicNameString")}), new Grammar.Term[0]).production("parameter", Grammar.sequence((Grammar.Term)Grammar.literal((String)"{"), (Grammar.Term[])new Grammar.Term[]{Grammar.oneOf((Grammar.Term)Grammar.nonTerminal((String)"UnescapedSymbolicNameString"), (Grammar.Term[])new Grammar.Term[]{Grammar.nonTerminal((String)"EscapedSymbolicNameString")}), Grammar.literal((String)"}")}), new Grammar.Term[0]).production("UnescapedSymbolicNameString", Grammar.sequence((Grammar.Term)Grammar.nonTerminal((String)"IdentifierStart"), (Grammar.Term[])new Grammar.Term[]{Grammar.zeroOrMore((Grammar.Term)Grammar.nonTerminal((String)"IdentifierPart"), (Grammar.Term[])new Grammar.Term[0])}), new Grammar.Term[0]).production("EscapedSymbolicNameString", Grammar.sequence((Grammar.Term)Grammar.literal((String)"`"), (Grammar.Term[])new Grammar.Term[]{Grammar.zeroOrMore((Grammar.Term)Grammar.anyCharacter().except(new int[]{96}), (Grammar.Term[])new Grammar.Term[0]), Grammar.literal((String)"`")}), new Grammar.Term[0]).production("IdentifierStart", (Grammar.Term)Grammar.charactersOfSet((String)"ID_Start"), new Grammar.Term[]{Grammar.charactersOfSet((String)"Sc"), Grammar.literal((String)"_;"), Grammar.literal((String)"\u203f;"), Grammar.literal((String)"\u2040;"), Grammar.literal((String)"\u2054;"), Grammar.literal((String)"\ufe33;"), Grammar.literal((String)"\ufe34;"), Grammar.literal((String)"\ufe4d;"), Grammar.literal((String)"\ufe4e;"), Grammar.literal((String)"\ufe4f;"), Grammar.literal((String)"\uff3f;")}).production("IdentifierPart", (Grammar.Term)Grammar.charactersOfSet((String)"ID_Continue"), new Grammar.Term[]{Grammar.charactersOfSet((String)"Sc")}).build(new Grammar.Builder.Option[]{Grammar.Builder.Option.IGNORE_UNUSED_PRODUCTIONS}));
    }

    @SafeVarargs
    private final void assertGenerates(Generator generator, Matcher<String> ... matches) throws Exception {
        this.verboseUnit.test(out -> {
            Output.Readable buffer = Output.stringBuilder();
            generator.generate(buffer.and(out));
            org.junit.Assert.assertThat((Object)buffer.toString(), (Matcher)Matchers.allOf((Matcher[])matches));
        });
    }

    private static class StateStub
    extends CypherGeneratorFactory.State {
        private StateStub() {
        }
    }
}

