/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Arrays;
import java.util.Objects;

public abstract class Conditional {
    public static final String XML_NAMESPACE = "http://opencypher.org/conditional";
    static final Conditional NONE = new Conditional(){

        @Override
        public boolean check(Flags flags) {
            return true;
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            return new SingleGiven(flag);
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            return new SingleUnless(flag);
        }
    };
    private static final Conditional UNSATISFIABLE = new Conditional(){

        @Override
        public boolean check(Flags flags) {
            return false;
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            return this;
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            return this;
        }
    };

    public abstract boolean check(Flags var1);

    abstract Conditional given(String var1);

    abstract Conditional unless(String var1);

    private static class Combined
    extends Conditional {
        private final String[] given;
        private final String[] unless;

        Combined(String[] given, String[] unless) {
            this.given = given;
            this.unless = unless;
        }

        @Override
        public boolean check(Flags flags) {
            for (String flag : this.given) {
                if (flags.isTrue(flag)) continue;
                return false;
            }
            for (String flag : this.unless) {
                if (!flags.isTrue(flag)) continue;
                return false;
            }
            return true;
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            for (String f : this.given) {
                if (!f.equals(flag)) continue;
                return this;
            }
            for (String f : this.unless) {
                if (!f.equals(flag)) continue;
                return UNSATISFIABLE;
            }
            String[] flags = Arrays.copyOf(this.given, this.given.length + 1);
            flags[this.given.length] = flag;
            return new Combined(flags, this.unless);
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            for (String f : this.unless) {
                if (!f.equals(flag)) continue;
                return this;
            }
            for (String f : this.given) {
                if (!f.equals(flag)) continue;
                return UNSATISFIABLE;
            }
            String[] flags = Arrays.copyOf(this.unless, this.unless.length + 1);
            flags[this.unless.length] = flag;
            return new Combined(this.given, flags);
        }
    }

    private static class SingleCombined
    extends Conditional {
        private final String given;
        private final String unless;

        SingleCombined(String given, String unless) {
            this.given = given;
            this.unless = unless;
        }

        @Override
        public boolean check(Flags flags) {
            return flags.isTrue(this.given) && !flags.isTrue(this.unless);
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            if (this.given.equals(flag)) {
                return this;
            }
            if (this.unless.equals(flag)) {
                return UNSATISFIABLE;
            }
            return new Combined(new String[]{this.given, flag}, new String[]{this.unless});
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            if (this.unless.equals(flag)) {
                return this;
            }
            if (this.given.equals(flag)) {
                return UNSATISFIABLE;
            }
            return new Combined(new String[]{this.given}, new String[]{this.unless, flag});
        }
    }

    private static class MultipleUnless
    extends Conditional {
        private final String[] flags;

        MultipleUnless(String ... flags) {
            this.flags = flags;
        }

        @Override
        public boolean check(Flags flags) {
            for (String flag : this.flags) {
                if (!flags.isTrue(flag)) continue;
                return false;
            }
            return true;
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            for (String f : this.flags) {
                if (!f.equals(flag)) continue;
                return UNSATISFIABLE;
            }
            return new Combined(new String[]{flag}, this.flags);
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            for (String f : this.flags) {
                if (!f.equals(flag)) continue;
                return this;
            }
            String[] flags = Arrays.copyOf(this.flags, this.flags.length + 1);
            flags[this.flags.length] = flag;
            return new MultipleUnless(flags);
        }
    }

    private static class MultipleGiven
    extends Conditional {
        private final String[] flags;

        MultipleGiven(String ... flags) {
            this.flags = flags;
        }

        @Override
        public boolean check(Flags flags) {
            for (String flag : this.flags) {
                if (flags.isTrue(flag)) continue;
                return false;
            }
            return true;
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            for (String f : this.flags) {
                if (!f.equals(flag)) continue;
                return this;
            }
            String[] flags = Arrays.copyOf(this.flags, this.flags.length + 1);
            flags[this.flags.length] = flag;
            return new MultipleGiven(flags);
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            for (String f : this.flags) {
                if (!f.equals(flag)) continue;
                return UNSATISFIABLE;
            }
            return new Combined(this.flags, new String[]{flag});
        }
    }

    private static class SingleUnless
    extends Conditional {
        private final String flag;

        SingleUnless(String flag) {
            this.flag = flag;
        }

        @Override
        public boolean check(Flags flags) {
            return !flags.isTrue(this.flag);
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            if (this.flag.equals(flag)) {
                return UNSATISFIABLE;
            }
            return new SingleCombined(flag, this.flag);
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            if (this.flag.equals(flag)) {
                return this;
            }
            return new MultipleUnless(this.flag, flag);
        }
    }

    private static class SingleGiven
    extends Conditional {
        private final String flag;

        SingleGiven(String flag) {
            this.flag = flag;
        }

        @Override
        public boolean check(Flags flags) {
            return flags.isTrue(this.flag);
        }

        @Override
        Conditional given(String flag) {
            Objects.requireNonNull(flag, "flag");
            if (this.flag.equals(flag)) {
                return this;
            }
            return new MultipleGiven(this.flag, flag);
        }

        @Override
        Conditional unless(String flag) {
            Objects.requireNonNull(flag, "flag");
            if (this.flag.equals(flag)) {
                return UNSATISFIABLE;
            }
            return new SingleCombined(this.flag, flag);
        }
    }

    public static interface Flags {
        public boolean isTrue(String var1);
    }
}

