/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.Node;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.ScopeRule;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermTransformation;

public interface Production {
    public String name();

    public String description();

    public Grammar.Term definition();

    public <Scope> Scope scope(Scope var1, ScopeRule.Transformation<Scope> var2);

    public <P, T, EX extends Exception> T transform(TermTransformation<P, T, EX> var1, P var2) throws EX;

    default public boolean isEmpty() {
        Grammar.Term def = this.definition();
        if (def instanceof Node) {
            Node node = (Node)def;
            return node.isEpsilon();
        }
        return def.transform(new TermTransformation<Void, Boolean, RuntimeException>(){

            @Override
            public Boolean transformEpsilon(Void param) {
                return true;
            }

            @Override
            public Boolean transformAlternatives(Void param, Alternatives alternatives) {
                return false;
            }

            @Override
            public Boolean transformSequence(Void param, Sequence sequence) {
                return false;
            }

            @Override
            public Boolean transformLiteral(Void param, Literal literal) {
                return false;
            }

            @Override
            public Boolean transformNonTerminal(Void param, NonTerminal nonTerminal) {
                return false;
            }

            @Override
            public Boolean transformOptional(Void param, Optional optional) {
                return false;
            }

            @Override
            public Boolean transformRepetition(Void param, Repetition repetition) {
                return false;
            }

            @Override
            public Boolean transformCharacters(Void param, CharacterSet characters) {
                return false;
            }
        }, null);
    }

    public boolean skip();

    public boolean inline();

    public boolean legacy();

    public boolean lexer();

    public boolean bnfsymbols();

    public Collection<NonTerminal> references();

    default public Collection<Production> referencedFrom() {
        return this.references().stream().flatMap(nonTerminal -> {
            Production site = nonTerminal.declaringProduction();
            if (nonTerminal.skip() || site.skip()) {
                return Stream.empty();
            }
            if (site.inline()) {
                return site.referencedFrom().stream();
            }
            return Stream.concat(Stream.of(site), site.references().stream().filter(NonTerminal::inline).map(NonTerminal::declaringProduction));
        }).collect(Collectors.toSet());
    }
}

