/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public final class TextGlyphs {
    private final String text;
    private final GlyphVector glyphs;
    private Rectangle2D bounds;

    public TextGlyphs(String text, Font font, FontRenderContext renderContext) {
        this.text = text;
        this.glyphs = font.createGlyphVector(renderContext, text);
    }

    public String text() {
        return this.text;
    }

    public Font getFont() {
        return this.glyphs.getFont();
    }

    public double getWidth() {
        return this.bounds().getWidth();
    }

    public double getHeight() {
        return this.bounds().getHeight();
    }

    public Shape outline(double x, double y) {
        return this.glyphs.getOutline(this.offsetX(x), this.offsetY(y));
    }

    public float offsetX(double x) {
        return (float)(x - this.bounds().getMinX());
    }

    public float offsetY(double y) {
        return (float)(y - this.bounds().getMinY());
    }

    public Iterator<Shape> outlines(double x, double y) {
        final float xOff = this.offsetX(x);
        final float yOff = this.offsetY(y);
        final int n = this.glyphs.getNumGlyphs();
        return new Iterator<Shape>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            public Shape next() {
                return TextGlyphs.this.glyphs.getGlyphOutline(this.i++, xOff, yOff);
            }
        };
    }

    public String toString() {
        return "TextGlyphs[" + this.text + "]";
    }

    private Rectangle2D bounds() {
        if (this.bounds == null) {
            this.bounds = this.glyphs.getLogicalBounds();
        }
        return this.bounds;
    }
}

