/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.opencypher.tools.Functions;
import org.opencypher.tools.Reflection;

public interface Option<T>
extends Serializable {
    public static <T> Option<T> option(final String name, final Function<T, ?> lookup) {
        return new Option<T>(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public Object value(T options) {
                return lookup.apply(options);
            }
        };
    }

    public String name();

    public Object value(T var1);

    @SafeVarargs
    public static <T> T dynamicOptions(Class<T> optionsType, Function<Method, Object> lookup, Option<? super T> ... options) {
        return OptionHandler.create(optionsType, Objects.requireNonNull(lookup, "lookup"), options);
    }

    @SafeVarargs
    public static <T> T options(Class<T> optionsType, Option<? super T> ... options) {
        return OptionHandler.create(optionsType, null, options);
    }

    public static class OptionHandler<T>
    implements InvocationHandler {
        private final Function<Method, Object> dynamic;
        private final Map<String, Option<? super T>> options;

        @SafeVarargs
        private static <T> T create(Class<T> iFace, Function<Method, Object> lookup, Option<? super T> ... options) {
            if (!iFace.isInterface()) {
                throw new IllegalArgumentException("options must be an interface: " + iFace);
            }
            HashMap optionMap = new HashMap(Functions.map(Arrays.asList(options), Option::name));
            Map<String, Method> methods = Functions.map(Arrays.asList(iFace.getMethods()), method -> {
                if (method.getDeclaringClass() == Object.class) {
                    return null;
                }
                if (method.getParameterCount() != 0) {
                    if (method.isDefault()) {
                        return null;
                    }
                    throw new IllegalArgumentException("Options interface may not have methods with parameters: " + method);
                }
                if (!method.isDefault() && !optionMap.containsKey(method.getName()) && lookup == null) {
                    throw new IllegalArgumentException("Missing required option: " + method.getName());
                }
                return method.getName();
            });
            optionMap.keySet().forEach(name -> {
                Method method = (Method)methods.get(name);
                if (method == null) {
                    throw new IllegalArgumentException("No such option: " + name);
                }
            });
            return iFace.cast(Proxy.newProxyInstance(iFace.getClassLoader(), new Class[]{iFace}, new OptionHandler<T>(lookup == null ? name -> null : lookup, optionMap)));
        }

        private OptionHandler(Function<Method, Object> dynamic, Map<String, Option<? super T>> options) {
            this.dynamic = dynamic;
            this.options = options;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                switch (method.getName()) {
                    case "toString": {
                        return proxy.getClass().getName();
                    }
                    case "hashCode": {
                        return System.identityHashCode(proxy);
                    }
                    case "equals": {
                        return proxy == args[0];
                    }
                }
            }
            if (args != null && args.length > 0) {
                Object[] arguments = new Object[args.length + 1];
                arguments[0] = proxy;
                System.arraycopy(args, 0, arguments, 1, args.length);
                return Reflection.defaultInvoker(method).invokeWithArguments(arguments);
            }
            String name = method.getName();
            Option<Object> option = this.options.get(name);
            if (option == null) {
                Object value = this.dynamic.apply(method);
                if (value != null) {
                    option = OptionHandler.option(name, value);
                    this.options.put(name, option);
                } else {
                    option = OptionHandler.option(name, Reflection.defaultInvoker(method));
                    this.options.put(name, option);
                }
            }
            return OptionHandler.invoke(option, proxy);
        }

        private static Object invoke(Option option, Object options) {
            return option.value(options);
        }

        private static <T> Option<T> option(String name, Object value) {
            return Option.option(name, (T options) -> value);
        }

        private static <T> Option<T> option(String name, MethodHandle invoker) {
            return Option.option(name, (T options) -> Reflection.invoke(invoker, options));
        }
    }
}

